/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.time.Period;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.IsoDateUnit;
import net.time4j.IsoUnit;
import net.time4j.JSR310DurationAdapter;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SPX;
import net.time4j.StdNormalizer;
import net.time4j.TemporalType;
import net.time4j.Weekcycle;
import net.time4j.base.MathUtils;
import net.time4j.engine.AbstractDuration;
import net.time4j.engine.AbstractMetric;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Normalizer;
import net.time4j.engine.TimeMetric;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;
import net.time4j.format.TimeSpanFormatter;
import net.time4j.tz.Timezone;

public final class Duration<U extends IsoUnit>
extends AbstractDuration<U>
implements Serializable {
    private static final char ISO_DECIMAL_SEPARATOR = (char)(Boolean.getBoolean("net.time4j.format.iso.decimal.dot") ? 46 : 44);
    private static final long MRD = 1000000000L;
    private static final long MIO = 1000000L;
    private static final Duration ZERO = new Duration();
    private static final Formatter<CalendarUnit> CF_EXT_CAL = Duration.createAlternativeDateFormat(true, false);
    private static final Formatter<CalendarUnit> CF_EXT_ORD = Duration.createAlternativeDateFormat(true, true);
    private static final Formatter<CalendarUnit> CF_BAS_CAL = Duration.createAlternativeDateFormat(false, false);
    private static final Formatter<CalendarUnit> CF_BAS_ORD = Duration.createAlternativeDateFormat(false, true);
    private static final Formatter<ClockUnit> TF_EXT = Duration.createAlternativeTimeFormat(true);
    private static final Formatter<ClockUnit> TF_BAS = Duration.createAlternativeTimeFormat(false);
    private static final Comparator<TimeSpan.Item<? extends ChronoUnit>> ITEM_COMPARATOR = StdNormalizer.comparator();
    public static Normalizer<IsoUnit> STD_PERIOD = StdNormalizer.ofMixedUnits();
    public static Normalizer<CalendarUnit> STD_CALENDAR_PERIOD = StdNormalizer.ofCalendarUnits();
    public static Normalizer<ClockUnit> STD_CLOCK_PERIOD = StdNormalizer.ofClockUnits();
    private static final int PRINT_STYLE_NORMAL = 0;
    private static final int PRINT_STYLE_ISO = 1;
    private static final int PRINT_STYLE_XML = 2;
    private static final long serialVersionUID = -6321211763598951499L;
    private static final TimeMetric<CalendarUnit, Duration<CalendarUnit>> YMD_METRIC = Duration.in((IsoUnit[])new CalendarUnit[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.DAYS});
    private static final TimeMetric<ClockUnit, Duration<ClockUnit>> CLOCK_METRIC = Duration.in((IsoUnit[])new ClockUnit[]{ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS, ClockUnit.NANOS});
    private static final TimeMetric<IsoDateUnit, Duration<IsoDateUnit>> WEEK_BASED_METRIC = Duration.in((IsoUnit[])new IsoDateUnit[]{CalendarUnit.weekBasedYears(), CalendarUnit.WEEKS, CalendarUnit.DAYS});
    private static final int SUPER_TYPE = -1;
    private static final int CALENDAR_TYPE = 0;
    private static final int CLOCK_TYPE = 1;
    private static final int WEEK_BASED_TYPE = 2;
    private final transient List<TimeSpan.Item<U>> items;
    private final transient boolean negative;

    Duration(List<TimeSpan.Item<U>> list, boolean bl2) {
        boolean bl3 = list.isEmpty();
        if (bl3) {
            this.items = Collections.emptyList();
        } else {
            list.sort(ITEM_COMPARATOR);
            this.items = Collections.unmodifiableList(list);
        }
        this.negative = !bl3 && bl2;
    }

    private Duration(Duration<U> duration, boolean bl2) {
        this.items = duration.items;
        this.negative = bl2 != duration.negative;
    }

    private Duration() {
        this.items = Collections.emptyList();
        this.negative = false;
    }

    public static <U extends IsoUnit> Duration<U> ofZero() {
        return ZERO;
    }

    public static <U extends IsoUnit> Duration<U> of(long l2, U u2) {
        if (l2 == 0L) {
            return Duration.ofZero();
        }
        Object object = u2;
        long l3 = l2;
        if (l2 < 0L) {
            l3 = MathUtils.safeNegate(l2);
        }
        if (u2 instanceof ClockUnit) {
            switch (u2.getSymbol()) {
                case '3': {
                    object = (IsoUnit)Duration.cast(ClockUnit.NANOS);
                    l3 = MathUtils.safeMultiply(l3, 1000000L);
                    break;
                }
                case '6': {
                    object = (IsoUnit)Duration.cast(ClockUnit.NANOS);
                    l3 = MathUtils.safeMultiply(l3, 1000L);
                    break;
                }
            }
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>(1);
        arrayList.add(TimeSpan.Item.of(l3, object));
        return new Duration<U>(arrayList, l2 < 0L);
    }

    public static Builder ofPositive() {
        return new Builder(false);
    }

    public static Builder ofNegative() {
        return new Builder(true);
    }

    public static Duration<CalendarUnit> ofCalendarUnits(int n2, int n3, int n4) {
        ArrayList arrayList = new ArrayList(3);
        if (n2 != 0) {
            arrayList.add(TimeSpan.Item.of(n2, CalendarUnit.YEARS));
        }
        if (n3 != 0) {
            arrayList.add(TimeSpan.Item.of(n3, CalendarUnit.MONTHS));
        }
        if (n4 != 0) {
            arrayList.add(TimeSpan.Item.of(n4, CalendarUnit.DAYS));
        }
        return new Duration<CalendarUnit>(arrayList, false);
    }

    public static Duration<ClockUnit> ofClockUnits(int n2, int n3, int n4) {
        ArrayList arrayList = new ArrayList(3);
        if (n2 != 0) {
            arrayList.add(TimeSpan.Item.of(n2, ClockUnit.HOURS));
        }
        if (n3 != 0) {
            arrayList.add(TimeSpan.Item.of(n3, ClockUnit.MINUTES));
        }
        if (n4 != 0) {
            arrayList.add(TimeSpan.Item.of(n4, ClockUnit.SECONDS));
        }
        return new Duration<ClockUnit>(arrayList, false);
    }

    public static Duration<IsoUnit> from(TemporalAmount temporalAmount) {
        Duration<IsoUnit> duration = Duration.ofZero();
        for (TemporalUnit temporalUnit : temporalAmount.getUnits()) {
            IsoUnit isoUnit;
            long l2;
            block22: {
                block21: {
                    l2 = temporalAmount.get(temporalUnit);
                    if (l2 == 0L) continue;
                    if (!(temporalUnit instanceof java.time.temporal.ChronoUnit)) break block21;
                    switch ((java.time.temporal.ChronoUnit)java.time.temporal.ChronoUnit.class.cast(temporalUnit)) {
                        case NANOS: {
                            isoUnit = ClockUnit.NANOS;
                            break block22;
                        }
                        case MICROS: {
                            isoUnit = ClockUnit.MICROS;
                            break block22;
                        }
                        case MILLIS: {
                            isoUnit = ClockUnit.MILLIS;
                            break block22;
                        }
                        case SECONDS: {
                            isoUnit = ClockUnit.SECONDS;
                            break block22;
                        }
                        case MINUTES: {
                            isoUnit = ClockUnit.MINUTES;
                            break block22;
                        }
                        case HOURS: {
                            isoUnit = ClockUnit.HOURS;
                            break block22;
                        }
                        case HALF_DAYS: {
                            isoUnit = ClockUnit.HOURS;
                            l2 = Math.multiplyExact(l2, 12L);
                            break block22;
                        }
                        case DAYS: {
                            isoUnit = CalendarUnit.DAYS;
                            break block22;
                        }
                        case WEEKS: {
                            isoUnit = CalendarUnit.WEEKS;
                            break block22;
                        }
                        case MONTHS: {
                            isoUnit = CalendarUnit.MONTHS;
                            break block22;
                        }
                        case YEARS: {
                            isoUnit = CalendarUnit.YEARS;
                            break block22;
                        }
                        case DECADES: {
                            isoUnit = CalendarUnit.DECADES;
                            break block22;
                        }
                        case CENTURIES: {
                            isoUnit = CalendarUnit.CENTURIES;
                            break block22;
                        }
                        case MILLENNIA: {
                            isoUnit = CalendarUnit.MILLENNIA;
                            break block22;
                        }
                        default: {
                            throw new IllegalArgumentException("Not supported: " + temporalUnit);
                        }
                    }
                }
                if (temporalUnit.equals(IsoFields.QUARTER_YEARS)) {
                    isoUnit = CalendarUnit.QUARTERS;
                } else if (temporalUnit.equals(IsoFields.WEEK_BASED_YEARS)) {
                    isoUnit = CalendarUnit.weekBasedYears();
                } else {
                    throw new IllegalArgumentException("Not supported: " + temporalUnit);
                }
            }
            duration = duration.plus(l2, isoUnit);
        }
        return duration.with(STD_PERIOD);
    }

    public static Duration<ClockUnit> from(java.time.Duration duration) {
        return TemporalType.THREETEN_DURATION.translate(duration);
    }

    public static Duration<CalendarUnit> from(Period period) {
        return TemporalType.THREETEN_PERIOD.translate(period);
    }

    @SafeVarargs
    public static <U extends IsoUnit> TimeMetric<U, Duration<U>> in(U ... UArray) {
        return new Metric((IsoUnit[])UArray);
    }

    public static <U extends IsoUnit> TimeMetric<U, Duration<U>> in(Collection<? extends U> collection) {
        return new Metric(collection);
    }

    public static TimeMetric<CalendarUnit, Duration<CalendarUnit>> inYearsMonthsDays() {
        return YMD_METRIC;
    }

    public static TimeMetric<ClockUnit, Duration<ClockUnit>> inClockUnits() {
        return CLOCK_METRIC;
    }

    public static TimeMetric<IsoDateUnit, Duration<IsoDateUnit>> inWeekBasedUnits() {
        return WEEK_BASED_METRIC;
    }

    public static TimeMetric<IsoUnit, Duration<IsoUnit>> in(Timezone timezone, IsoUnit ... isoUnitArray) {
        return new ZonalMetric(timezone, isoUnitArray);
    }

    @Override
    public List<TimeSpan.Item<U>> getTotalLength() {
        return this.items;
    }

    @Override
    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public boolean contains(IsoUnit isoUnit) {
        if (isoUnit == null) {
            return false;
        }
        boolean bl2 = this.isFractionUnit(isoUnit);
        int n2 = this.items.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TimeSpan.Item<U> item = this.items.get(i2);
            IsoUnit isoUnit2 = (IsoUnit)item.getUnit();
            if (!isoUnit2.equals(isoUnit) && (!bl2 || !this.isFractionUnit(isoUnit2))) continue;
            return item.getAmount() > 0L;
        }
        return false;
    }

    @Override
    public long getPartialAmount(IsoUnit isoUnit) {
        if (isoUnit == null) {
            return 0L;
        }
        boolean bl2 = this.isFractionUnit(isoUnit);
        int n2 = this.items.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TimeSpan.Item<U> item = this.items.get(i2);
            IsoUnit isoUnit2 = (IsoUnit)item.getUnit();
            if (isoUnit2.equals(isoUnit)) {
                return item.getAmount();
            }
            if (!bl2 || !this.isFractionUnit(isoUnit2)) continue;
            int n3 = isoUnit2.getSymbol() - 48;
            int n4 = isoUnit.getSymbol() - 48;
            int n5 = 1;
            int n6 = Math.abs(n3 - n4);
            for (int i3 = 0; i3 < n6; ++i3) {
                n5 *= 10;
            }
            if (n3 >= n4) {
                return item.getAmount() / (long)n5;
            }
            return item.getAmount() * (long)n5;
        }
        return 0L;
    }

    public static <U extends IsoUnit, T extends TimePoint<U, T>> Comparator<Duration<? extends U>> comparator(T t2) {
        return new LengthComparator(t2, null);
    }

    public static Comparator<Duration<ClockUnit>> comparatorOnClock() {
        return (duration, duration2) -> {
            long l2;
            long l3 = Duration.lengthInSeconds(duration);
            if (l3 < (l2 = Duration.lengthInSeconds(duration2))) {
                return -1;
            }
            if (l3 > l2) {
                return 1;
            }
            long l4 = duration.getPartialAmount((ChronoUnit)ClockUnit.NANOS) % 1000000000L;
            long l5 = duration2.getPartialAmount((ChronoUnit)ClockUnit.NANOS) % 1000000000L;
            if (duration.isNegative()) {
                l4 = Math.negateExact(l4);
            }
            if (duration2.isNegative()) {
                l5 = Math.negateExact(l5);
            }
            return l4 < l5 ? -1 : (l4 > l5 ? 1 : 0);
        };
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Duration<U> plus(long l2, U object) {
        void var3_4;
        if (object == null) {
            throw new NullPointerException("Missing chronological unit.");
        }
        long l3 = l2;
        Object object2 = object;
        boolean bl2 = false;
        if (l2 == 0L) {
            return this;
        }
        if (l2 < 0L) {
            l2 = MathUtils.safeNegate(l2);
            bl2 = true;
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>(this.getTotalLength());
        TimeSpan.Item<U> item = Duration.replaceFraction(l2, object);
        if (item != null) {
            l2 = item.getAmount();
            IsoUnit isoUnit = (IsoUnit)item.getUnit();
        }
        if (this.isEmpty()) {
            arrayList.add(item == null ? TimeSpan.Item.of(l2, var3_4) : item);
            return new Duration<U>(arrayList, bl2);
        }
        int n2 = this.getIndex((ChronoUnit)var3_4);
        boolean bl3 = this.isNegative();
        if (n2 < 0) {
            if (this.isNegative() != bl2) return this.plus(Duration.of(l3, object2));
            arrayList.add(TimeSpan.Item.of(l2, var3_4));
            return new Duration<U>(arrayList, bl3);
        } else {
            long l4 = MathUtils.safeAdd(MathUtils.safeMultiply(((TimeSpan.Item)arrayList.get(n2)).getAmount(), (long)(this.isNegative() ? -1 : 1)), MathUtils.safeMultiply(l2, (long)(bl2 ? -1 : 1)));
            if (l4 == 0L) {
                arrayList.remove(n2);
                return new Duration<U>(arrayList, bl3);
            } else {
                if (this.count() != 1 && this.isNegative() != l4 < 0L) return this.plus(Duration.of(l3, object2));
                long l5 = l4 < 0L ? MathUtils.safeNegate(l4) : l4;
                arrayList.set(n2, TimeSpan.Item.of(l5, var3_4));
                bl3 = l4 < 0L;
            }
        }
        return new Duration<U>(arrayList, bl3);
    }

    public Duration<U> plus(TimeSpan<? extends U> timeSpan) {
        Duration<? extends U> duration = Duration.merge(this, timeSpan);
        if (duration == null) {
            long[] lArray = new long[]{0L, 0L, 0L, 0L};
            if (Duration.summarize(this, lArray) && Duration.summarize(timeSpan, lArray)) {
                long l2 = lArray[0];
                long l3 = lArray[1];
                long l4 = lArray[2];
                long l5 = lArray[3];
                long l6 = l5 != 0L ? l5 : (l4 != 0L ? l4 : l3);
                if (!Duration.hasMixedSigns(l2, l6)) {
                    boolean bl2;
                    boolean bl3 = bl2 = l2 < 0L || l6 < 0L;
                    if (bl2) {
                        l2 = MathUtils.safeNegate(l2);
                        l3 = MathUtils.safeNegate(l3);
                        l4 = MathUtils.safeNegate(l4);
                        l5 = MathUtils.safeNegate(l5);
                    }
                    long l7 = l2 / 12L;
                    l2 %= 12L;
                    long l8 = 0L;
                    if (l5 != 0L) {
                        l8 = l5 % 1000000000L;
                        l4 = l5 / 1000000000L;
                    }
                    long l9 = l4 / 3600L;
                    long l10 = (l4 %= 3600L) / 60L;
                    l4 %= 60L;
                    HashMap<Enum, Long> hashMap = new HashMap<Enum, Long>();
                    hashMap.put(CalendarUnit.YEARS, l7);
                    hashMap.put(CalendarUnit.MONTHS, l2);
                    hashMap.put(CalendarUnit.DAYS, l3);
                    hashMap.put(ClockUnit.HOURS, l9);
                    hashMap.put(ClockUnit.MINUTES, l10);
                    hashMap.put(ClockUnit.SECONDS, l4);
                    hashMap.put(ClockUnit.NANOS, l8);
                    return Duration.create(hashMap, bl2);
                }
            }
            throw new IllegalStateException("Mixed signs in result time span not allowed: " + this + " PLUS " + timeSpan);
        }
        return duration;
    }

    public Duration<U> with(long l2, U object) {
        long l3 = l2 < 0L ? MathUtils.safeNegate(l2) : l2;
        TimeSpan.Item<U> item = Duration.replaceFraction(l3, object);
        if (item != null) {
            l3 = item.getAmount();
            object = (IsoUnit)item.getUnit();
        }
        long l4 = this.getPartialAmount((IsoUnit)object);
        return this.plus(MathUtils.safeSubtract(MathUtils.safeMultiply(l3, l2 < 0L ? -1L : 1L), MathUtils.safeMultiply(l4, this.isNegative() ? -1L : 1L)), object);
    }

    public Duration<U> abs() {
        if (this.isNegative()) {
            return this.inverse();
        }
        return this;
    }

    @Override
    public Duration<U> inverse() {
        return this.multipliedBy(-1);
    }

    public Duration<U> multipliedBy(int n2) {
        if (this.isEmpty() || n2 == 1) {
            return this;
        }
        if (n2 == 0) {
            return Duration.ofZero();
        }
        if (n2 == -1) {
            return new Duration<U>(this, true);
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>(this.count());
        int n3 = Math.abs(n2);
        int n4 = this.count();
        for (int i2 = 0; i2 < n4; ++i2) {
            TimeSpan.Item<U> item = this.getTotalLength().get(i2);
            arrayList.add(TimeSpan.Item.of(MathUtils.safeMultiply(item.getAmount(), (long)n3), (IsoUnit)item.getUnit()));
        }
        return new Duration<U>(arrayList, n2 < 0 != this.isNegative());
    }

    public List<Duration<U>> union(TimeSpan<? extends U> timeSpan) {
        Duration<? extends U> duration = Duration.merge(this, timeSpan);
        if (duration == null) {
            ArrayList<Duration<? extends U>> arrayList = new ArrayList<Duration<? extends U>>();
            arrayList.add(this);
            Duration<? extends U> duration2 = Duration.ofZero();
            Duration<? extends U> duration3 = duration2.plus(timeSpan);
            arrayList.add(duration3);
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.singletonList(duration);
    }

    public static Duration<IsoUnit> compose(Duration<CalendarUnit> duration, Duration<ClockUnit> duration2) {
        Duration<CalendarUnit> duration3 = Duration.ofZero();
        return duration3.plus(duration).plus(duration2);
    }

    public Duration<CalendarUnit> toCalendarPeriod() {
        if (this.isEmpty()) {
            return Duration.ofZero();
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>();
        for (TimeSpan.Item<U> item : this.items) {
            if (!(item.getUnit() instanceof CalendarUnit)) continue;
            arrayList.add(TimeSpan.Item.of(item.getAmount(), (CalendarUnit)CalendarUnit.class.cast(item.getUnit())));
        }
        if (arrayList.isEmpty()) {
            return Duration.ofZero();
        }
        return new Duration<CalendarUnit>(arrayList, this.isNegative());
    }

    public Duration<ClockUnit> toClockPeriod() {
        if (this.isEmpty()) {
            return Duration.ofZero();
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>();
        for (TimeSpan.Item<U> item : this.items) {
            if (!(item.getUnit() instanceof ClockUnit)) continue;
            arrayList.add(TimeSpan.Item.of(item.getAmount(), (ClockUnit)ClockUnit.class.cast(item.getUnit())));
        }
        if (arrayList.isEmpty()) {
            return Duration.ofZero();
        }
        return new Duration<ClockUnit>(arrayList, this.isNegative());
    }

    public Duration<ClockUnit> toClockPeriodWithDaysAs24Hours() {
        if (this.isEmpty()) {
            return Duration.ofZero();
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>();
        long l2 = 0L;
        for (TimeSpan.Item<U> item : this.items) {
            if (item.getUnit() instanceof ClockUnit) {
                arrayList.add(TimeSpan.Item.of(item.getAmount(), (ClockUnit)ClockUnit.class.cast(item.getUnit())));
                continue;
            }
            if (!((IsoUnit)item.getUnit()).equals(CalendarUnit.DAYS)) continue;
            l2 = Math.multiplyExact(item.getAmount(), 24L);
        }
        if (l2 != 0L) {
            boolean bl2 = false;
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TimeSpan.Item<ClockUnit> item = (TimeSpan.Item<ClockUnit>)arrayList.get(i2);
                if (item.getUnit() != ClockUnit.HOURS) continue;
                bl2 = true;
                item = TimeSpan.Item.of(Math.addExact(item.getAmount(), l2), ClockUnit.HOURS);
                arrayList.set(i2, item);
                break;
            }
            if (!bl2) {
                arrayList.add(TimeSpan.Item.of(l2, ClockUnit.HOURS));
            }
        } else if (arrayList.isEmpty()) {
            return Duration.ofZero();
        }
        return new Duration<ClockUnit>(arrayList, this.isNegative());
    }

    public TemporalAmount toTemporalAmount() {
        return new JSR310DurationAdapter(this);
    }

    public Duration<U> with(Normalizer<U> normalizer) {
        return Duration.convert(normalizer.normalize(this));
    }

    public Duration<U> truncatedTo(U u2) {
        if (this.isEmpty()) {
            return Duration.ofZero();
        }
        double d2 = u2.getLength();
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>();
        for (TimeSpan.Item<U> item : this.items) {
            if (Double.compare(((IsoUnit)item.getUnit()).getLength(), d2) < 0) break;
            arrayList.add(item);
        }
        if (arrayList.isEmpty()) {
            return Duration.ofZero();
        }
        return new Duration<U>(arrayList, this.isNegative());
    }

    public static Normalizer<IsoUnit> approximateHours(int n2) {
        return new ApproximateNormalizer(n2, ClockUnit.HOURS);
    }

    public static Normalizer<IsoUnit> approximateMinutes(int n2) {
        return new ApproximateNormalizer(n2, ClockUnit.MINUTES);
    }

    public static Normalizer<IsoUnit> approximateSeconds(int n2) {
        return new ApproximateNormalizer(n2, ClockUnit.SECONDS);
    }

    public static Normalizer<IsoUnit> approximateMaxUnitOnly() {
        return new ApproximateNormalizer(false);
    }

    public static Normalizer<IsoUnit> approximateMaxUnitOrWeeks() {
        return new ApproximateNormalizer(true);
    }

    public static <U extends IsoUnit> Collector<Duration<U>, ?, Duration<U>> summingUp() {
        return Collectors.reducing(Duration.ofZero(), Duration::plus);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)Duration.class.cast(object);
            return this.negative == duration.negative && this.getTotalLength().equals(duration.getTotalLength());
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.getTotalLength().hashCode();
        if (this.negative) {
            n2 ^= n2;
        }
        return n2;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    public String toStringISO() {
        return this.toString(1);
    }

    public String toStringXML() {
        return this.toString(2);
    }

    public static Duration<IsoUnit> parsePeriod(String string) throws ParseException {
        return Duration.parsePeriod(string, IsoUnit.class);
    }

    public static Duration<CalendarUnit> parseCalendarPeriod(String string) throws ParseException {
        return Duration.parsePeriod(string, CalendarUnit.class);
    }

    public static Duration<ClockUnit> parseClockPeriod(String string) throws ParseException {
        return Duration.parsePeriod(string, ClockUnit.class);
    }

    public static Duration<IsoDateUnit> parseWeekBasedPeriod(String string) throws ParseException {
        return Duration.parsePeriod(string, IsoDateUnit.class);
    }

    public static Formatter<IsoUnit> formatter(String string) {
        return Formatter.ofPattern(string);
    }

    public static <U extends IsoUnit> Formatter<U> formatter(Class<U> clazz, String string) {
        return Formatter.ofPattern(clazz, string);
    }

    private String toString(int n2) {
        IsoUnit isoUnit;
        if (n2 == 1 && this.isNegative()) {
            throw new ChronoException("Negative sign not allowed in ISO-8601.");
        }
        if (this.isEmpty()) {
            return "PT0S";
        }
        boolean bl2 = n2 == 2;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isNegative()) {
            stringBuilder.append('-');
        }
        stringBuilder.append('P');
        boolean bl3 = false;
        boolean bl4 = false;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n3 = this.count();
        block9: for (int i2 = 0; i2 < n3; ++i2) {
            TimeSpan.Item<U> item = this.getTotalLength().get(i2);
            isoUnit = (IsoUnit)item.getUnit();
            if (!bl3 && !isoUnit.isCalendrical()) {
                stringBuilder.append('T');
                bl3 = true;
            }
            long l5 = item.getAmount();
            int n4 = isoUnit.getSymbol();
            if (isoUnit == Weekcycle.YEARS) {
                bl4 = true;
            }
            if (n4 > 48 && n4 <= 57) {
                assert (n4 == 57);
                l2 = l5;
                continue;
            }
            if (n4 == 83) {
                l3 = l5;
                continue;
            }
            if (bl2 || n2 == 1) {
                switch (n4) {
                    case 68: {
                        if (l4 != 0L) {
                            l5 = MathUtils.safeAdd(l5, l4);
                            l4 = 0L;
                        }
                        stringBuilder.append(l5);
                        break;
                    }
                    case 72: 
                    case 77: 
                    case 89: {
                        stringBuilder.append(l5);
                        break;
                    }
                    case 87: {
                        if (n3 == 1) {
                            if (bl2) {
                                stringBuilder.append(MathUtils.safeMultiply(l5, 7L));
                                n4 = 68;
                                break;
                            }
                            stringBuilder.append(l5);
                            break;
                        }
                        l4 = MathUtils.safeMultiply(l5, 7L);
                        if (this.contains(CalendarUnit.DAYS)) continue block9;
                        stringBuilder.append(l4);
                        l4 = 0L;
                        n4 = 68;
                        break;
                    }
                    case 81: {
                        stringBuilder.append(MathUtils.safeMultiply(l5, 3L));
                        n4 = 77;
                        break;
                    }
                    case 69: {
                        stringBuilder.append(MathUtils.safeMultiply(l5, 10L));
                        n4 = 89;
                        break;
                    }
                    case 67: {
                        stringBuilder.append(MathUtils.safeMultiply(l5, 100L));
                        n4 = 89;
                        break;
                    }
                    case 73: {
                        stringBuilder.append(MathUtils.safeMultiply(l5, 1000L));
                        n4 = 89;
                        break;
                    }
                    default: {
                        String string = bl2 ? "XML" : "ISO";
                        throw new ChronoException("Special units cannot be output in " + string + "-mode: " + this.toString(0));
                    }
                }
            } else {
                stringBuilder.append(l5);
            }
            if (n4 == 0) {
                stringBuilder.append('{');
                stringBuilder.append(isoUnit);
                stringBuilder.append('}');
                continue;
            }
            stringBuilder.append((char)n4);
        }
        if (l2 != 0L) {
            l3 = MathUtils.safeAdd(l3, l2 / 1000000000L);
            stringBuilder.append(l3);
            stringBuilder.append(bl2 ? (char)'.' : (char)ISO_DECIMAL_SEPARATOR);
            String string = String.valueOf(l2 % 1000000000L);
            int n5 = 9 - string.length();
            for (n3 = 0; n3 < n5; ++n3) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
            stringBuilder.append('S');
        } else if (l3 != 0L) {
            stringBuilder.append(l3);
            stringBuilder.append('S');
        }
        if (bl4) {
            boolean bl5;
            boolean bl6 = bl5 = !bl3;
            if (bl5) {
                int n6 = this.count();
                for (n3 = 0; n3 < n6; ++n3) {
                    isoUnit = this.getTotalLength().get(n3).getUnit();
                    if (isoUnit == Weekcycle.YEARS || isoUnit == CalendarUnit.WEEKS || isoUnit == CalendarUnit.DAYS) continue;
                    bl5 = false;
                    break;
                }
            }
            if (!bl5) {
                n3 = stringBuilder.indexOf("Y");
                stringBuilder.replace(n3, n3 + 1, "{WEEK_BASED_YEARS}");
            }
        }
        return stringBuilder.toString();
    }

    private static boolean hasMixedSigns(long l2, long l3) {
        return l2 < 0L && l3 > 0L || l2 > 0L && l3 < 0L;
    }

    private int count() {
        return this.getTotalLength().size();
    }

    private static <U> boolean isEmpty(TimeSpan<U> timeSpan) {
        List<TimeSpan.Item<U>> list = timeSpan.getTotalLength();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (list.get(i2).getAmount() <= 0L) continue;
            return false;
        }
        return true;
    }

    private static <U extends IsoUnit> Duration<U> create(Map<U, Long> map, boolean bl2) {
        if (map.isEmpty()) {
            return Duration.ofZero();
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>(map.size());
        long l2 = 0L;
        for (Map.Entry<U, Long> entry : map.entrySet()) {
            long l3 = entry.getValue();
            if (l3 == 0L) continue;
            IsoUnit isoUnit = (IsoUnit)entry.getKey();
            if (isoUnit == ClockUnit.MILLIS) {
                l2 = MathUtils.safeAdd(l2, MathUtils.safeMultiply(l3, 1000000L));
                continue;
            }
            if (isoUnit == ClockUnit.MICROS) {
                l2 = MathUtils.safeAdd(l2, MathUtils.safeMultiply(l3, 1000L));
                continue;
            }
            if (isoUnit == ClockUnit.NANOS) {
                l2 = MathUtils.safeAdd(l2, l3);
                continue;
            }
            arrayList.add(TimeSpan.Item.of(l3, isoUnit));
        }
        if (l2 != 0L) {
            IsoUnit isoUnit = (IsoUnit)Duration.cast(ClockUnit.NANOS);
            arrayList.add(TimeSpan.Item.of(l2, isoUnit));
        } else if (arrayList.isEmpty()) {
            return Duration.ofZero();
        }
        return new Duration<U>(arrayList, bl2);
    }

    private int getIndex(ChronoUnit chronoUnit) {
        return Duration.getIndex(chronoUnit, this.getTotalLength());
    }

    private static <U extends ChronoUnit> int getIndex(ChronoUnit chronoUnit, List<TimeSpan.Item<U>> list) {
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            ChronoUnit chronoUnit2 = (ChronoUnit)list.get(n4).getUnit();
            int n5 = StdNormalizer.compare(chronoUnit2, chronoUnit);
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -1;
    }

    private static <U extends IsoUnit> TimeSpan.Item<U> replaceFraction(long l2, U object) {
        if (object.equals(ClockUnit.MILLIS)) {
            l2 = MathUtils.safeMultiply(l2, 1000000L);
            object = (IsoUnit)Duration.cast(ClockUnit.NANOS);
        } else if (object.equals(ClockUnit.MICROS)) {
            l2 = MathUtils.safeMultiply(l2, 1000L);
            object = (IsoUnit)Duration.cast(ClockUnit.NANOS);
        } else {
            return null;
        }
        return TimeSpan.Item.of(l2, object);
    }

    /*
     * WARNING - void declaration
     */
    private static <U extends IsoUnit> Duration<U> merge(Duration<U> duration, TimeSpan<? extends U> timeSpan) {
        int n2;
        if (duration.isEmpty()) {
            if (Duration.isEmpty(timeSpan)) {
                return duration;
            }
            if (timeSpan instanceof Duration) {
                return (Duration)Duration.cast(timeSpan);
            }
        }
        HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
        int n3 = super.count();
        for (n2 = 0; n2 < n3; ++n2) {
            TimeSpan.Item<U> item = duration.getTotalLength().get(n2);
            hashMap.put((IsoUnit)item.getUnit(), MathUtils.safeMultiply(item.getAmount(), (long)(duration.isNegative() ? -1 : 1)));
        }
        n2 = timeSpan.isNegative() ? 1 : 0;
        int n4 = timeSpan.getTotalLength().size();
        for (n3 = 0; n3 < n4; ++n3) {
            void object;
            Map.Entry entry = timeSpan.getTotalLength().get(n3);
            IsoUnit isoUnit = (IsoUnit)((TimeSpan.Item)((Object)entry)).getUnit();
            long l2 = ((TimeSpan.Item)((Object)entry)).getAmount();
            TimeSpan.Item<IsoUnit> item = Duration.replaceFraction(l2, isoUnit);
            if (item != null) {
                l2 = item.getAmount();
                IsoUnit l3 = item.getUnit();
            }
            if (hashMap.containsKey(object)) {
                hashMap.put(object, MathUtils.safeAdd((Long)hashMap.get(object), MathUtils.safeMultiply(l2, (long)(n2 != 0 ? -1 : 1))));
                continue;
            }
            hashMap.put(object, MathUtils.safeMultiply(l2, (long)(n2 != 0 ? -1 : 1)));
        }
        n3 = 0;
        if (duration.isNegative() == n2) {
            n3 = n2;
        } else {
            n4 = 1;
            for (Map.Entry entry : hashMap.entrySet()) {
                int n5;
                int n6 = n5 = (Long)entry.getValue() < 0L ? 1 : 0;
                if (n4 != 0) {
                    n3 = n5;
                    n4 = 0;
                    continue;
                }
                if (n3 == n5) continue;
                return null;
            }
        }
        if (n3 != 0) {
            for (Map.Entry entry : hashMap.entrySet()) {
                long l3 = (Long)entry.getValue();
                hashMap.put((IsoUnit)entry.getKey(), l3 < 0L ? MathUtils.safeNegate(l3) : l3);
            }
        }
        return Duration.create(hashMap, n3 != 0);
    }

    private static <U extends IsoUnit> boolean summarize(TimeSpan<? extends U> timeSpan, long[] lArray) {
        long l2 = lArray[0];
        long l3 = lArray[1];
        long l4 = lArray[2];
        long l5 = lArray[3];
        for (TimeSpan.Item<U> item : timeSpan.getTotalLength()) {
            Enum enum_;
            IsoUnit isoUnit = (IsoUnit)item.getUnit();
            long l6 = item.getAmount();
            if (timeSpan.isNegative()) {
                l6 = MathUtils.safeNegate(l6);
            }
            if (isoUnit instanceof CalendarUnit) {
                enum_ = (CalendarUnit)CalendarUnit.class.cast(isoUnit);
                switch (1.$SwitchMap$net$time4j$CalendarUnit[enum_.ordinal()]) {
                    case 1: {
                        l2 = MathUtils.safeAdd(l2, MathUtils.safeMultiply(l6, 12000L));
                        break;
                    }
                    case 2: {
                        l2 = MathUtils.safeAdd(l2, MathUtils.safeMultiply(l6, 1200L));
                        break;
                    }
                    case 3: {
                        l2 = MathUtils.safeAdd(l2, MathUtils.safeMultiply(l6, 120L));
                        break;
                    }
                    case 4: {
                        l2 = MathUtils.safeAdd(l2, MathUtils.safeMultiply(l6, 12L));
                        break;
                    }
                    case 5: {
                        l2 = MathUtils.safeAdd(l2, MathUtils.safeMultiply(l6, 3L));
                        break;
                    }
                    case 6: {
                        l2 = MathUtils.safeAdd(l2, l6);
                        break;
                    }
                    case 7: {
                        l3 = MathUtils.safeAdd(l3, MathUtils.safeMultiply(l6, 7L));
                        break;
                    }
                    case 8: {
                        l3 = MathUtils.safeAdd(l3, l6);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(enum_.name());
                    }
                }
                continue;
            }
            if (isoUnit instanceof ClockUnit) {
                enum_ = (ClockUnit)ClockUnit.class.cast(isoUnit);
                switch (1.$SwitchMap$net$time4j$ClockUnit[enum_.ordinal()]) {
                    case 1: {
                        l4 = MathUtils.safeAdd(l4, MathUtils.safeMultiply(l6, 3600L));
                        break;
                    }
                    case 2: {
                        l4 = MathUtils.safeAdd(l4, MathUtils.safeMultiply(l6, 60L));
                        break;
                    }
                    case 3: {
                        l4 = MathUtils.safeAdd(l4, l6);
                        break;
                    }
                    case 4: {
                        l5 = MathUtils.safeAdd(l5, MathUtils.safeMultiply(l6, 1000000L));
                        break;
                    }
                    case 5: {
                        l5 = MathUtils.safeAdd(l5, MathUtils.safeMultiply(l6, 1000L));
                        break;
                    }
                    case 6: {
                        l5 = MathUtils.safeAdd(l5, l6);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(enum_.name());
                    }
                }
                continue;
            }
            return false;
        }
        if (l5 != 0L) {
            l5 = MathUtils.safeAdd(l5, MathUtils.safeMultiply(l3, 86400000000000L));
            l5 = MathUtils.safeAdd(l5, MathUtils.safeMultiply(l4, 1000000000L));
            l3 = 0L;
            l4 = 0L;
        } else if (l4 != 0L) {
            l4 = MathUtils.safeAdd(l4, MathUtils.safeMultiply(l3, 86400L));
            l3 = 0L;
        }
        lArray[0] = l2;
        lArray[1] = l3;
        lArray[2] = l4;
        lArray[3] = l5;
        return true;
    }

    private static long lengthInSeconds(Duration<ClockUnit> duration) {
        long l2 = Math.multiplyExact(duration.getPartialAmount((ChronoUnit)ClockUnit.HOURS), 3600L);
        l2 = Math.addExact(l2, Math.multiplyExact(duration.getPartialAmount((ChronoUnit)ClockUnit.MINUTES), 60L));
        l2 = Math.addExact(l2, duration.getPartialAmount((ChronoUnit)ClockUnit.SECONDS));
        l2 = Math.addExact(l2, duration.getPartialAmount((ChronoUnit)ClockUnit.NANOS) / 1000000000L);
        if (duration.isNegative()) {
            l2 = Math.negateExact(l2);
        }
        return l2;
    }

    private static <U extends IsoUnit> Duration<U> convert(TimeSpan<U> timeSpan) {
        if (timeSpan instanceof Duration) {
            return (Duration)Duration.cast(timeSpan);
        }
        Duration<U> duration = Duration.ofZero();
        return duration.plus(timeSpan);
    }

    private boolean isFractionUnit(IsoUnit isoUnit) {
        char c2 = isoUnit.getSymbol();
        return c2 >= '1' && c2 <= '9';
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    private static <U extends IsoUnit> Duration<U> parsePeriod(String string, Class<U> clazz) throws ParseException {
        int n2 = 0;
        boolean bl2 = false;
        if (string.length() == 0) {
            throw new ParseException("Empty period string.", n2);
        }
        if (string.charAt(0) == '-') {
            bl2 = true;
            n2 = 1;
        }
        try {
            int n3;
            if (string.charAt(n2) != 'P') {
                throw new ParseException("Format symbol 'P' expected: " + string, n2);
            }
            ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>();
            boolean bl3 = (n3 = string.indexOf(84, ++n2)) == -1;
            int n4 = -1;
            if (clazz == CalendarUnit.class) {
                n4 = 0;
            } else if (clazz == ClockUnit.class) {
                n4 = 1;
            } else if (clazz == IsoDateUnit.class) {
                n4 = 2;
            }
            if (bl3) {
                if (n4 == 1) {
                    throw new ParseException("Format symbol 'T' expected: " + string, n2);
                }
                Duration.parse(string, n2, string.length(), n4 == -1 ? 0 : n4, arrayList);
            } else {
                if (n4 == 0 || n4 == 2) {
                    throw new ParseException("Unexpected time component found: " + string, n3);
                }
                boolean bl4 = false;
                if (n3 > n2) {
                    if (n4 == 1) {
                        throw new ParseException("Unexpected date component found: " + string, n2);
                    }
                    bl4 = Duration.parse(string.substring(0, n3), n2, n3, 0, arrayList);
                }
                if (bl4) {
                    Duration.parseAlt(string, n3 + 1, string.length(), false, arrayList);
                } else {
                    Duration.parse(string, n3 + 1, string.length(), 1, arrayList);
                }
            }
            return new Duration<U>(arrayList, bl2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ParseException parseException = new ParseException("Unexpected termination of period string: " + string, n2);
            parseException.initCause(indexOutOfBoundsException);
            throw parseException;
        }
    }

    private static <U extends ChronoUnit> boolean parse(String string, int n2, int n3, int n4, List<TimeSpan.Item<U>> list) throws ParseException {
        char c2 = string.charAt(n3 - 1);
        if (c2 >= '0' && c2 <= '9' && n4 != 2) {
            Duration.parseAlt(string, n2, n3, n4 == 0, list);
            return true;
        }
        if (n2 == n3) {
            throw new ParseException(string, n2);
        }
        StringBuilder stringBuilder = null;
        boolean bl2 = false;
        ChronoUnit chronoUnit = null;
        int n5 = n2;
        boolean bl3 = false;
        for (int i2 = n2; i2 < n3; ++i2) {
            long l2;
            char c3 = string.charAt(i2);
            if (c3 >= '0' && c3 <= '9') {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                    bl2 = false;
                    n5 = i2;
                }
                stringBuilder.append(c3);
                continue;
            }
            if (c3 == ',' || c3 == '.') {
                if (stringBuilder == null || n4 != 1) {
                    throw new ParseException("Decimal separator misplaced: " + string, i2);
                }
                bl2 = true;
                l2 = Duration.parseAmount(string, stringBuilder.toString(), n5);
                chronoUnit = Duration.addParsedItem(ClockUnit.SECONDS, chronoUnit, l2, string, i2, list);
                stringBuilder = null;
                bl3 = true;
                continue;
            }
            if (bl2) {
                throw new ParseException("Unexpected char '" + c3 + "' found: " + string, i2);
            }
            if (bl3) {
                if (c3 != 'S') {
                    throw new ParseException("Second symbol expected: " + string, i2);
                }
                if (stringBuilder == null) {
                    throw new ParseException("Decimal separator misplaced: " + string, i2 - 1);
                }
                if (stringBuilder.length() > 9) {
                    stringBuilder.delete(9, stringBuilder.length());
                }
                for (int i3 = stringBuilder.length(); i3 < 9; ++i3) {
                    stringBuilder.append('0');
                }
                bl2 = true;
                l2 = Duration.parseAmount(string, stringBuilder.toString(), n5);
                stringBuilder = null;
                chronoUnit = Duration.addParsedItem(ClockUnit.NANOS, chronoUnit, l2, string, i2, list);
                continue;
            }
            bl2 = true;
            l2 = Duration.parseAmount(string, stringBuilder == null ? String.valueOf(c3) : stringBuilder.toString(), n5);
            stringBuilder = null;
            IsoUnit isoUnit = n4 == 1 ? Duration.parseTimeSymbol(c3, string, i2) : (n4 == 2 ? Duration.parseWeekBasedSymbol(c3, string, i2) : Duration.parseDateSymbol(c3, string, i2));
            chronoUnit = Duration.addParsedItem(isoUnit, chronoUnit, l2, string, i2, list);
        }
        if (!bl2) {
            throw new ParseException("Unit symbol expected: " + string, n3);
        }
        return false;
    }

    private static <U extends ChronoUnit> void parseAlt(String string, int n2, int n3, boolean bl2, List<TimeSpan.Item<U>> list) throws ParseException {
        boolean bl3 = false;
        if (bl2) {
            ChronoUnit chronoUnit;
            long l2;
            long l3;
            if (n2 + 4 < n3) {
                boolean bl4 = bl3 = string.charAt(n2 + 4) == '-';
            }
            boolean bl5 = bl3 ? n2 + 8 == n3 : n2 + 7 == n3;
            Duration duration = (Duration)Duration.getAlternativeDateFormat(bl3, bl5).parse(string, n2);
            long l4 = duration.getPartialAmount(CalendarUnit.YEARS);
            if (bl5) {
                l3 = 0L;
                l2 = duration.getPartialAmount(CalendarUnit.DAYS);
            } else {
                l3 = duration.getPartialAmount(CalendarUnit.MONTHS);
                l2 = duration.getPartialAmount(CalendarUnit.DAYS);
                if (l3 > 12L) {
                    throw new ParseException("ISO-8601 prohibits months-part > 12: " + string, n2 + 4 + (bl3 ? 1 : 0));
                }
                if (l2 > 30L) {
                    throw new ParseException("ISO-8601 prohibits days-part > 30: " + string, n2 + 6 + (bl3 ? 2 : 0));
                }
            }
            if (l4 > 0L) {
                chronoUnit = (ChronoUnit)Duration.cast(CalendarUnit.YEARS);
                list.add(TimeSpan.Item.of(l4, chronoUnit));
            }
            if (l3 > 0L) {
                chronoUnit = (ChronoUnit)Duration.cast(CalendarUnit.MONTHS);
                list.add(TimeSpan.Item.of(l3, chronoUnit));
            }
            if (l2 > 0L) {
                chronoUnit = (ChronoUnit)Duration.cast(CalendarUnit.DAYS);
                list.add(TimeSpan.Item.of(l2, chronoUnit));
            }
        } else {
            long l5;
            long l6;
            long l7;
            Duration duration;
            long l8;
            if (n2 + 2 < n3) {
                boolean bl6 = bl3 = string.charAt(n2 + 2) == ':';
            }
            if ((l8 = (duration = (Duration)Duration.getAlternativeTimeFormat(bl3).parse(string, n2)).getPartialAmount(ClockUnit.HOURS)) > 0L) {
                if (l8 > 24L) {
                    throw new ParseException("ISO-8601 prohibits hours-part > 24: " + string, n2);
                }
                ChronoUnit chronoUnit = (ChronoUnit)Duration.cast(ClockUnit.HOURS);
                list.add(TimeSpan.Item.of(l8, chronoUnit));
            }
            if ((l7 = duration.getPartialAmount(ClockUnit.MINUTES)) > 0L) {
                if (l7 > 60L) {
                    throw new ParseException("ISO-8601 prohibits minutes-part > 60: " + string, n2 + 2 + (bl3 ? 1 : 0));
                }
                ChronoUnit chronoUnit = (ChronoUnit)Duration.cast(ClockUnit.MINUTES);
                list.add(TimeSpan.Item.of(l7, chronoUnit));
            }
            if ((l6 = duration.getPartialAmount(ClockUnit.SECONDS)) > 0L) {
                if (l6 > 60L) {
                    throw new ParseException("ISO-8601 prohibits seconds-part > 60: " + string, n2 + 4 + (bl3 ? 2 : 0));
                }
                ChronoUnit chronoUnit = (ChronoUnit)Duration.cast(ClockUnit.SECONDS);
                list.add(TimeSpan.Item.of(l6, chronoUnit));
            }
            if ((l5 = duration.getPartialAmount(ClockUnit.NANOS)) > 0L) {
                ChronoUnit chronoUnit = (ChronoUnit)Duration.cast(ClockUnit.NANOS);
                list.add(TimeSpan.Item.of(l5, chronoUnit));
            }
        }
    }

    private static Formatter<CalendarUnit> createAlternativeDateFormat(boolean bl2, boolean bl3) {
        String string = bl2 ? (bl3 ? "YYYY-DDD" : "YYYY-MM-DD") : (bl3 ? "YYYYDDD" : "YYYYMMDD");
        return Formatter.ofPattern(CalendarUnit.class, string);
    }

    private static Formatter<CalendarUnit> getAlternativeDateFormat(boolean bl2, boolean bl3) {
        if (bl2) {
            return bl3 ? CF_EXT_ORD : CF_EXT_CAL;
        }
        return bl3 ? CF_BAS_ORD : CF_BAS_CAL;
    }

    private static Formatter<ClockUnit> createAlternativeTimeFormat(boolean bl2) {
        String string = bl2 ? "hh[:mm[:ss[,fffffffff]]]" : "hh[mm[ss[,fffffffff]]]";
        return Formatter.ofPattern(ClockUnit.class, string);
    }

    private static Formatter<ClockUnit> getAlternativeTimeFormat(boolean bl2) {
        return bl2 ? TF_EXT : TF_BAS;
    }

    private static CalendarUnit parseDateSymbol(char c2, String string, int n2) throws ParseException {
        switch (c2) {
            case 'I': {
                return CalendarUnit.MILLENNIA;
            }
            case 'C': {
                return CalendarUnit.CENTURIES;
            }
            case 'E': {
                return CalendarUnit.DECADES;
            }
            case 'Y': {
                return CalendarUnit.YEARS;
            }
            case 'Q': {
                return CalendarUnit.QUARTERS;
            }
            case 'M': {
                return CalendarUnit.MONTHS;
            }
            case 'W': {
                return CalendarUnit.WEEKS;
            }
            case 'D': {
                return CalendarUnit.DAYS;
            }
        }
        throw new ParseException("Symbol '" + c2 + "' not supported: " + string, n2);
    }

    private static ClockUnit parseTimeSymbol(char c2, String string, int n2) throws ParseException {
        switch (c2) {
            case 'H': {
                return ClockUnit.HOURS;
            }
            case 'M': {
                return ClockUnit.MINUTES;
            }
            case 'S': {
                return ClockUnit.SECONDS;
            }
        }
        throw new ParseException("Symbol '" + c2 + "' not supported: " + string, n2);
    }

    private static IsoDateUnit parseWeekBasedSymbol(char c2, String string, int n2) throws ParseException {
        switch (c2) {
            case 'Y': {
                return CalendarUnit.weekBasedYears();
            }
            case 'W': {
                return CalendarUnit.WEEKS;
            }
            case 'D': {
                return CalendarUnit.DAYS;
            }
        }
        throw new ParseException("Symbol '" + c2 + "' not supported: " + string, n2);
    }

    private static <U extends ChronoUnit> ChronoUnit addParsedItem(ChronoUnit chronoUnit, ChronoUnit chronoUnit2, long l2, String string, int n2, List<TimeSpan.Item<U>> list) throws ParseException {
        if (chronoUnit2 == null || Double.compare(chronoUnit.getLength(), chronoUnit2.getLength()) < 0) {
            if (l2 != 0L) {
                ChronoUnit chronoUnit3 = (ChronoUnit)Duration.cast(chronoUnit);
                list.add(TimeSpan.Item.of(l2, chronoUnit3));
            }
            return chronoUnit;
        }
        if (Double.compare(chronoUnit.getLength(), chronoUnit2.getLength()) == 0) {
            throw new ParseException("Duplicate unit items: " + string, n2);
        }
        throw new ParseException("Wrong order of unit items: " + string, n2);
    }

    private static long parseAmount(String string, String string2, int n2) throws ParseException {
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ParseException parseException = new ParseException(string, n2);
            parseException.initCause(numberFormatException);
            throw parseException;
        }
    }

    private Object writeReplace() {
        return new SPX(this, 6);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    public static class Builder {
        private final List<TimeSpan.Item<IsoUnit>> items = new ArrayList<TimeSpan.Item<IsoUnit>>(10);
        private final boolean negative;
        private boolean millisSet = false;
        private boolean microsSet = false;
        private boolean nanosSet = false;

        Builder(boolean bl2) {
            this.negative = bl2;
        }

        public Builder years(int n2) {
            this.set(n2, CalendarUnit.YEARS);
            return this;
        }

        public Builder months(int n2) {
            this.set(n2, CalendarUnit.MONTHS);
            return this;
        }

        public Builder days(int n2) {
            this.set(n2, CalendarUnit.DAYS);
            return this;
        }

        public Builder hours(int n2) {
            this.set(n2, ClockUnit.HOURS);
            return this;
        }

        public Builder minutes(int n2) {
            this.set(n2, ClockUnit.MINUTES);
            return this;
        }

        public Builder seconds(int n2) {
            this.set(n2, ClockUnit.SECONDS);
            return this;
        }

        public Builder millis(int n2) {
            this.millisCalled();
            this.update(n2, 1000000L);
            return this;
        }

        public Builder micros(int n2) {
            this.microsCalled();
            this.update(n2, 1000L);
            return this;
        }

        public Builder nanos(int n2) {
            this.nanosCalled();
            this.update(n2, 1L);
            return this;
        }

        public Duration<IsoUnit> build() {
            if (this.items.isEmpty()) {
                throw new IllegalStateException("Not set any amount and unit.");
            }
            return new Duration<IsoUnit>(this.items, this.negative);
        }

        private void set(long l2, IsoUnit isoUnit) {
            int n2 = this.items.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.items.get(i2).getUnit() != isoUnit) continue;
                throw new IllegalStateException("Already registered: " + isoUnit);
            }
            if (l2 != 0L) {
                TimeSpan.Item<IsoUnit> item = TimeSpan.Item.of(l2, isoUnit);
                this.items.add(item);
            }
        }

        private void update(long l2, long l3) {
            if (l2 >= 0L) {
                ClockUnit clockUnit = ClockUnit.NANOS;
                for (int i2 = this.items.size() - 1; i2 >= 0; --i2) {
                    TimeSpan.Item<IsoUnit> item = this.items.get(i2);
                    if (!item.getUnit().equals(ClockUnit.NANOS)) continue;
                    this.items.set(i2, TimeSpan.Item.of(MathUtils.safeAdd(MathUtils.safeMultiply(l2, l3), item.getAmount()), clockUnit));
                    return;
                }
                if (l2 != 0L) {
                    this.items.add(TimeSpan.Item.of(MathUtils.safeMultiply(l2, l3), clockUnit));
                }
            } else {
                throw new IllegalArgumentException("Illegal negative amount: " + l2);
            }
        }

        private void millisCalled() {
            if (this.millisSet) {
                throw new IllegalStateException("Called twice for: " + ClockUnit.MILLIS.name());
            }
            this.millisSet = true;
        }

        private void microsCalled() {
            if (this.microsSet) {
                throw new IllegalStateException("Called twice for: " + ClockUnit.MICROS.name());
            }
            this.microsSet = true;
        }

        private void nanosCalled() {
            if (this.nanosSet) {
                throw new IllegalStateException("Called twice for: " + ClockUnit.NANOS.name());
            }
            this.nanosSet = true;
        }
    }

    private static class Metric<U extends IsoUnit>
    extends AbstractMetric<U, Duration<U>> {
        @SafeVarargs
        private Metric(U ... UArray) {
            super(UArray.length > 1, UArray);
        }

        private Metric(Collection<? extends U> collection) {
            super(collection.size() > 1, collection);
        }

        @Override
        protected Duration<U> createEmptyTimeSpan() {
            return Duration.ofZero();
        }

        @Override
        protected Duration<U> createTimeSpan(List<TimeSpan.Item<U>> list, boolean bl2) {
            return new Duration<U>(list, bl2);
        }

        @Override
        protected TimeSpan.Item<U> resolve(TimeSpan.Item<U> item) {
            IsoUnit isoUnit = (IsoUnit)item.getUnit();
            if (isoUnit.equals(ClockUnit.MILLIS)) {
                return TimeSpan.Item.of(Math.multiplyExact(item.getAmount(), 1000000L), ClockUnit.NANOS);
            }
            if (isoUnit.equals(ClockUnit.MICROS)) {
                return TimeSpan.Item.of(Math.multiplyExact(item.getAmount(), 1000L), ClockUnit.NANOS);
            }
            return item;
        }
    }

    private static class ZonalMetric
    implements TimeMetric<IsoUnit, Duration<IsoUnit>> {
        private final Timezone tz;
        private final TimeMetric<IsoUnit, Duration<IsoUnit>> metric;

        private ZonalMetric(Timezone timezone, IsoUnit ... isoUnitArray) {
            if (timezone == null) {
                throw new NullPointerException("Missing timezone.");
            }
            this.tz = timezone;
            this.metric = new Metric<IsoUnit>(isoUnitArray);
        }

        @Override
        public <T extends TimePoint<? super IsoUnit, T>> Duration<IsoUnit> between(T t2, T t3) {
            T t4 = t2;
            T t5 = t3;
            boolean bl2 = false;
            if (t2.compareTo(t3) > 0) {
                t4 = t3;
                t5 = t2;
                bl2 = true;
            }
            int n2 = this.getOffset(t4);
            int n3 = this.getOffset(t5);
            t5 = t5.plus(n2 - n3, (ClockUnit)ClockUnit.SECONDS);
            AbstractDuration abstractDuration = this.metric.between(t4, t5);
            if (bl2) {
                abstractDuration = abstractDuration.inverse();
            }
            return abstractDuration;
        }

        private int getOffset(ChronoEntity<?> chronoEntity) {
            return this.tz.getStrategy().getOffset(chronoEntity.get(PlainDate.COMPONENT), chronoEntity.get(PlainTime.COMPONENT), this.tz).getIntegralAmount();
        }
    }

    private static class LengthComparator<U extends IsoUnit, T extends TimePoint<U, T>>
    implements Comparator<Duration<? extends U>> {
        private final T base;

        private LengthComparator(T t2) {
            if (t2 == null) {
                throw new NullPointerException("Missing base time point.");
            }
            this.base = t2;
        }

        @Override
        public int compare(Duration<? extends U> duration, Duration<? extends U> duration2) {
            boolean bl2 = duration.isNegative();
            boolean bl3 = duration2.isNegative();
            if (bl2 && !bl3) {
                return -1;
            }
            if (!bl2 && bl3) {
                return 1;
            }
            if (duration.isEmpty() && duration2.isEmpty()) {
                return 0;
            }
            return ((TimePoint)((TimePoint)this.base).plus(duration)).compareTo(((TimePoint)this.base).plus(duration2));
        }

        /* synthetic */ LengthComparator(TimePoint timePoint, 1 var2_2) {
            this(timePoint);
        }
    }

    private static class ApproximateNormalizer
    implements Normalizer<IsoUnit> {
        private final boolean daysToWeeks;
        private final int steps;
        private final ClockUnit unit;

        ApproximateNormalizer(boolean bl2) {
            this.daysToWeeks = bl2;
            this.steps = 1;
            this.unit = null;
        }

        ApproximateNormalizer(int n2, ClockUnit clockUnit) {
            if (n2 < 1) {
                throw new IllegalArgumentException("Step width is not positive: " + n2);
            }
            if (clockUnit.compareTo(ClockUnit.SECONDS) > 0) {
                throw new IllegalArgumentException("Unsupported unit.");
            }
            this.daysToWeeks = false;
            this.steps = n2;
            this.unit = clockUnit;
        }

        @Override
        public Duration<IsoUnit> normalize(TimeSpan<? extends IsoUnit> timeSpan) {
            double d2 = 0.0;
            boolean bl2 = true;
            int n2 = timeSpan.getTotalLength().size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TimeSpan.Item<? extends IsoUnit> item = timeSpan.getTotalLength().get(i2);
                d2 += (double)item.getAmount() * item.getUnit().getLength();
                if (item.getAmount() <= 0L) continue;
                bl2 = false;
            }
            if (bl2) {
                return Duration.ofZero();
            }
            IsoUnit isoUnit = this.unit == null ? ApproximateNormalizer.maxUnit(d2) : this.unit;
            double d3 = isoUnit.getLength() * (double)this.steps;
            long l2 = (long)(d2 + d3 / 2.0);
            int n3 = (int)Math.floor(d3);
            l2 = MathUtils.floorDivide(l2, n3) * (long)n3;
            int n4 = 0;
            int n5 = 0;
            int n6 = ApproximateNormalizer.safeCast((double)l2 / CalendarUnit.YEARS.getLength());
            l2 = (long)((double)l2 - (double)n6 * CalendarUnit.YEARS.getLength());
            int n7 = ApproximateNormalizer.safeCast((double)l2 / CalendarUnit.MONTHS.getLength());
            l2 = (long)((double)l2 - (double)n7 * CalendarUnit.MONTHS.getLength());
            int n8 = ApproximateNormalizer.safeCast((double)l2 / CalendarUnit.WEEKS.getLength());
            l2 = (long)((double)l2 - (double)n8 * CalendarUnit.WEEKS.getLength());
            int n9 = ApproximateNormalizer.safeCast((double)l2 / CalendarUnit.DAYS.getLength());
            l2 = (long)((double)l2 - (double)n9 * CalendarUnit.DAYS.getLength());
            int n10 = ApproximateNormalizer.safeCast((double)l2 / ClockUnit.HOURS.getLength());
            if (ClockUnit.HOURS.equals(this.unit)) {
                n10 /= this.steps;
                n10 *= this.steps;
            } else {
                l2 = (long)((double)l2 - (double)n10 * ClockUnit.HOURS.getLength());
                n4 = ApproximateNormalizer.safeCast((double)l2 / ClockUnit.MINUTES.getLength());
                if (ClockUnit.MINUTES.equals(this.unit)) {
                    n4 /= this.steps;
                    n4 *= this.steps;
                } else {
                    l2 = (long)((double)l2 - (double)n4 * ClockUnit.MINUTES.getLength());
                    n5 = ApproximateNormalizer.safeCast((double)l2 / ClockUnit.SECONDS.getLength());
                    n5 /= this.steps;
                    n5 *= this.steps;
                }
            }
            n9 += n8 * 7;
            n8 = 0;
            if (this.unit == null) {
                if (n6 > 0) {
                    n5 = 0;
                    n4 = 0;
                    n10 = 0;
                    n9 = 0;
                    n7 = 0;
                } else if (n7 > 0) {
                    n5 = 0;
                    n4 = 0;
                    n10 = 0;
                    n9 = 0;
                } else if (n9 > 0) {
                    if (n9 >= 7 && this.daysToWeeks) {
                        n8 = (int)(((double)n9 + 3.5) / 7.0);
                        n9 = 0;
                    }
                    n5 = 0;
                    n4 = 0;
                    n10 = 0;
                } else if (n10 > 0) {
                    n5 = 0;
                    n4 = 0;
                } else if (n4 > 0) {
                    n5 = 0;
                }
                if (n8 > 0) {
                    return Duration.of(timeSpan.isNegative() ? (long)(-n8) : (long)n8, CalendarUnit.WEEKS);
                }
            }
            AbstractDuration abstractDuration = Duration.ofPositive().years(n6).months(n7).days(n9).hours(n10).minutes(n4).seconds(n5).build();
            if (timeSpan.isNegative()) {
                abstractDuration = abstractDuration.inverse();
            }
            return abstractDuration;
        }

        private static int safeCast(double d2) {
            if (d2 < -2.147483648E9 || d2 > 2.147483647E9) {
                throw new ArithmeticException("Out of range: " + d2);
            }
            return (int)d2;
        }

        private static IsoUnit maxUnit(double d2) {
            for (IsoUnit isoUnit : Arrays.asList(CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.DAYS, ClockUnit.HOURS, ClockUnit.MINUTES)) {
                if (!(d2 >= isoUnit.getLength())) continue;
                return isoUnit;
            }
            return ClockUnit.SECONDS;
        }
    }

    public static final class Formatter<U extends IsoUnit>
    extends TimeSpanFormatter<U, Duration<U>> {
        private static final String JODA_PATTERN = "'P'[-#################Y'Y'][-#################M'M'][-#################W'W'][-#################D'D']['T'[-#################h'H'][-#################m'M'][-#################s'S'[.fffffffff]]]";

        private Formatter(Class<U> clazz, String string) {
            super(clazz, string);
        }

        public static Formatter<IsoUnit> ofJodaStyle() {
            return Formatter.ofPattern(IsoUnit.class, JODA_PATTERN);
        }

        public static Formatter<IsoUnit> ofPattern(String string) {
            return Formatter.ofPattern(IsoUnit.class, string);
        }

        public static <U extends IsoUnit> Formatter<U> ofPattern(Class<U> clazz, String string) {
            return new Formatter<U>(clazz, string);
        }

        public String format(TemporalAmount temporalAmount) {
            return this.format(Duration.from(temporalAmount));
        }

        public void print(TemporalAmount temporalAmount, Appendable appendable) throws IOException {
            this.print(Duration.from(temporalAmount), appendable);
        }

        @Override
        protected Duration<U> convert(Map<U, Long> map, boolean bl2) {
            return Duration.create(map, bl2);
        }

        @Override
        protected U getUnit(char c2) {
            Enum enum_;
            switch (c2) {
                case 'I': {
                    enum_ = CalendarUnit.MILLENNIA;
                    break;
                }
                case 'C': {
                    enum_ = CalendarUnit.CENTURIES;
                    break;
                }
                case 'E': {
                    enum_ = CalendarUnit.DECADES;
                    break;
                }
                case 'Y': {
                    enum_ = CalendarUnit.YEARS;
                    break;
                }
                case 'Q': {
                    enum_ = CalendarUnit.QUARTERS;
                    break;
                }
                case 'M': {
                    enum_ = CalendarUnit.MONTHS;
                    break;
                }
                case 'W': {
                    enum_ = CalendarUnit.WEEKS;
                    break;
                }
                case 'D': {
                    enum_ = CalendarUnit.DAYS;
                    break;
                }
                case 'h': {
                    enum_ = ClockUnit.HOURS;
                    break;
                }
                case 'm': {
                    enum_ = ClockUnit.MINUTES;
                    break;
                }
                case 's': {
                    enum_ = ClockUnit.SECONDS;
                    break;
                }
                case 'f': {
                    enum_ = ClockUnit.NANOS;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported pattern symbol: " + c2);
                }
            }
            try {
                return (U)enum_;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(classCastException.getMessage(), classCastException);
            }
        }
    }
}

