/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.time4j.ClockUnit;
import net.time4j.Meridiem;
import net.time4j.PlainTime;
import net.time4j.SPX;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;

public final class DayPeriod {
    private static final SortedMap<PlainTime, String> STD_RULES;
    private static DayPeriod FALLBACK;
    private static final AttributeKey<DayPeriod> CUSTOM;
    private final transient Locale locale;
    private final transient String calendarType;
    private final transient SortedMap<PlainTime, String> codeMap;

    private DayPeriod(Locale locale, String string, SortedMap<PlainTime, String> sortedMap) {
        this.locale = locale;
        this.calendarType = string;
        this.codeMap = Collections.unmodifiableSortedMap(sortedMap);
    }

    public static DayPeriod of(Locale locale) {
        return DayPeriod.of(locale, "iso8601");
    }

    public static DayPeriod of(Map<PlainTime, String> map) {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Label map is empty.");
        }
        TreeMap<PlainTime, String> treeMap = new TreeMap<PlainTime, String>(map);
        for (PlainTime plainTime : map.keySet()) {
            if (plainTime.getHour() == 24) {
                treeMap.put(PlainTime.midnightAtStartOfDay(), map.get(plainTime));
                treeMap.remove(plainTime);
                continue;
            }
            if (!map.get(plainTime).isEmpty()) continue;
            throw new IllegalArgumentException("Map has empty label: " + map);
        }
        return new DayPeriod(null, "", treeMap);
    }

    public ChronoFunction<ChronoDisplay, String> fixed() {
        return this.fixed(TextWidth.WIDE, OutputContext.FORMAT);
    }

    public ChronoFunction<ChronoDisplay, String> fixed(TextWidth textWidth, OutputContext outputContext) {
        return new PeriodName(true, textWidth, outputContext);
    }

    public ChronoFunction<ChronoDisplay, String> approximate() {
        return this.approximate(TextWidth.WIDE, OutputContext.FORMAT);
    }

    public ChronoFunction<ChronoDisplay, String> approximate(TextWidth textWidth, OutputContext outputContext) {
        return new PeriodName(false, textWidth, outputContext);
    }

    public PlainTime getStart(PlainTime plainTime) {
        PlainTime plainTime2 = plainTime.getHour() == 24 ? PlainTime.midnightAtStartOfDay() : plainTime;
        PlainTime plainTime3 = this.codeMap.lastKey();
        for (PlainTime plainTime4 : this.codeMap.keySet()) {
            if (plainTime2.isSimultaneous(plainTime4)) {
                return plainTime4;
            }
            if (plainTime2.isBefore(plainTime4)) break;
            plainTime3 = plainTime4;
        }
        return plainTime3;
    }

    public PlainTime getEnd(PlainTime plainTime) {
        PlainTime plainTime2 = plainTime.getHour() == 24 ? PlainTime.midnightAtStartOfDay() : plainTime;
        for (PlainTime plainTime3 : this.codeMap.keySet()) {
            if (!plainTime2.isBefore(plainTime3)) continue;
            return plainTime3;
        }
        return this.codeMap.firstKey();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DayPeriod) {
            DayPeriod dayPeriod = (DayPeriod)object;
            if (this.locale == null ? dayPeriod.locale != null : !this.locale.equals(dayPeriod.locale)) {
                return false;
            }
            return this.codeMap.equals(dayPeriod.codeMap) && this.calendarType.equals(dayPeriod.calendarType);
        }
        return false;
    }

    public int hashCode() {
        return this.codeMap.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("DayPeriod[");
        if (this.isPredefined()) {
            stringBuilder.append("locale=");
            stringBuilder.append(this.locale);
            stringBuilder.append(',');
            if (!this.calendarType.equals("iso8601")) {
                stringBuilder.append(",calendar-type=");
                stringBuilder.append(this.calendarType);
                stringBuilder.append(',');
            }
        }
        stringBuilder.append(this.codeMap);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static DayPeriod of(Locale locale, String string) {
        String string22;
        String string3 = locale.getLanguage();
        Map<String, String> map = DayPeriod.loadTextForms(locale, string);
        SortedMap<PlainTime, String> sortedMap = Collections.emptySortedMap();
        for (String string22 : map.keySet()) {
            if (!DayPeriod.accept(string22)) continue;
            int n2 = Integer.parseInt(string22.substring(1, 3));
            int n3 = Integer.parseInt(string22.substring(3, 5));
            PlainTime plainTime = PlainTime.midnightAtStartOfDay();
            if (n2 == 24) {
                if (n3 != 0) {
                    throw new IllegalStateException("Invalid time key: " + string22);
                }
            } else if (n2 >= 0 && n2 < 24 && n3 >= 0 && n3 < 60) {
                plainTime = plainTime.plus((long)(n2 * 60 + n3), ClockUnit.MINUTES);
            } else {
                throw new IllegalStateException("Invalid time key: " + string22);
            }
            if (sortedMap.isEmpty()) {
                sortedMap = new TreeMap<PlainTime, String>();
            }
            sortedMap.put(plainTime, map.get(string22));
        }
        if (sortedMap.isEmpty() || string3.isEmpty()) {
            return FALLBACK;
        }
        Iterator<String> iterator = sortedMap.keySet().iterator();
        string22 = "";
        while (iterator.hasNext()) {
            PlainTime plainTime = (PlainTime)((Object)iterator.next());
            String string4 = (String)sortedMap.get(plainTime);
            if (string4.equals(string22)) {
                iterator.remove();
                continue;
            }
            string22 = string4;
        }
        return new DayPeriod(locale, string, sortedMap);
    }

    private boolean isPredefined() {
        return this.locale != null;
    }

    private static String getFixedCode(PlainTime plainTime) {
        int n2 = (Integer)plainTime.get(PlainTime.MINUTE_OF_DAY);
        if (n2 == 0 || n2 == 1440) {
            return "midnight";
        }
        if (n2 < 720) {
            return "am";
        }
        if (n2 == 720) {
            return "noon";
        }
        return "pm";
    }

    private static String createKey(Map<String, String> map, TextWidth textWidth, OutputContext outputContext, String string) {
        String string2;
        if (textWidth == TextWidth.SHORT) {
            textWidth = TextWidth.ABBREVIATED;
        }
        if (!map.containsKey(string2 = DayPeriod.toPrefix(textWidth, outputContext) + string)) {
            if (outputContext == OutputContext.STANDALONE) {
                string2 = textWidth == TextWidth.ABBREVIATED ? DayPeriod.createKey(map, textWidth, OutputContext.FORMAT, string) : DayPeriod.createKey(map, TextWidth.ABBREVIATED, outputContext, string);
            } else if (textWidth != TextWidth.ABBREVIATED) {
                string2 = DayPeriod.createKey(map, TextWidth.ABBREVIATED, outputContext, string);
            }
        }
        return string2;
    }

    private static String toPrefix(TextWidth textWidth, OutputContext outputContext) {
        char c2;
        switch (textWidth) {
            case WIDE: {
                c2 = 'w';
                break;
            }
            case NARROW: {
                c2 = 'n';
                break;
            }
            default: {
                c2 = 'a';
            }
        }
        if (outputContext == OutputContext.STANDALONE) {
            c2 = Character.toUpperCase(c2);
        }
        return "P(" + c2 + ")_";
    }

    private static Map<String, String> loadTextForms(Locale locale, String string) {
        Map<String, String> map = CalendarText.getInstance(string, locale).getTextForms();
        if (!string.equals("iso8601") && !"true".equals(map.get("hasDayPeriods"))) {
            map = CalendarText.getIsoInstance(locale).getTextForms();
        }
        return map;
    }

    private static boolean accept(String string) {
        return string.charAt(0) == 'T' && string.length() == 5 && Character.isDigit(string.charAt(1));
    }

    static {
        TreeMap<PlainTime, String> treeMap = new TreeMap<PlainTime, String>();
        treeMap.put(PlainTime.midnightAtStartOfDay(), "am");
        treeMap.put(PlainTime.of(12), "pm");
        STD_RULES = Collections.unmodifiableSortedMap(treeMap);
        FALLBACK = new DayPeriod(Locale.ROOT, "iso8601", STD_RULES);
        CUSTOM = Attributes.createKey("CUSTOM_DAY_PERIOD", DayPeriod.class);
    }

    private class PeriodName
    implements ChronoFunction<ChronoDisplay, String> {
        private final boolean fixed;
        private final TextWidth width;
        private final OutputContext outputContext;

        PeriodName(boolean bl2, TextWidth textWidth, OutputContext outputContext) {
            if (textWidth == null) {
                throw new NullPointerException("Missing text width.");
            }
            if (outputContext == null) {
                throw new NullPointerException("Missing output context.");
            }
            this.fixed = bl2;
            this.width = textWidth;
            this.outputContext = outputContext;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String apply(ChronoDisplay chronoDisplay) {
            String string;
            PlainTime plainTime = chronoDisplay.get(PlainTime.COMPONENT);
            DayPeriod dayPeriod = DayPeriod.this;
            Locale locale = dayPeriod.locale;
            if (this.fixed) {
                String string2;
                String string3 = DayPeriod.getFixedCode(plainTime);
                if (!dayPeriod.isPredefined()) return string3;
                Map map = DayPeriod.loadTextForms(locale, dayPeriod.calendarType);
                if (!map.containsKey(string2 = DayPeriod.createKey(map, this.width, this.outputContext, string3))) {
                    if (string3.equals("midnight")) {
                        string2 = DayPeriod.createKey(map, this.width, this.outputContext, "am");
                    } else if (string3.equals("noon")) {
                        string2 = DayPeriod.createKey(map, this.width, this.outputContext, "pm");
                    }
                }
                if (!map.containsKey(string2)) return plainTime.get(PlainTime.AM_PM_OF_DAY).getDisplayName(locale == null ? Locale.ROOT : locale);
                return (String)map.get(string2);
            }
            if (!dayPeriod.isPredefined()) return (String)dayPeriod.codeMap.get(dayPeriod.getStart(plainTime));
            Map map = DayPeriod.loadTextForms(locale, dayPeriod.calendarType);
            if (plainTime.isMidnight() ? map.containsKey(string = DayPeriod.createKey(map, this.width, this.outputContext, "midnight")) : plainTime.isSimultaneous(PlainTime.of(12)) && map.containsKey(string = DayPeriod.createKey(map, this.width, this.outputContext, "noon"))) {
                return (String)map.get(string);
            }
            string = (String)dayPeriod.codeMap.get(dayPeriod.getStart(plainTime));
            String string4 = DayPeriod.createKey(map, this.width, this.outputContext, string);
            if (!map.containsKey(string4)) return plainTime.get(PlainTime.AM_PM_OF_DAY).getDisplayName(locale == null ? Locale.ROOT : locale);
            return (String)map.get(string4);
        }
    }

    static class Element
    extends BasicElement<String>
    implements TextElement<String>,
    ElementRule<ChronoEntity<?>, String> {
        private static final long serialVersionUID = 5589976208326940032L;
        private final transient boolean fixed;
        private final transient DayPeriod dayPeriod;

        Element(boolean bl2, Locale locale, String string) {
            this(bl2, DayPeriod.of(locale, string));
        }

        Element(boolean bl2, DayPeriod dayPeriod) {
            super(bl2 ? "FIXED_DAY_PERIOD" : "APPROXIMATE_DAY_PERIOD");
            this.fixed = bl2;
            this.dayPeriod = dayPeriod;
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }

        @Override
        public char getSymbol() {
            return this.fixed ? (char)'b' : 'B';
        }

        @Override
        public String getDefaultMinimum() {
            if (this.fixed) {
                return "am";
            }
            PlainTime plainTime = (PlainTime)this.dayPeriod.codeMap.firstKey();
            return (String)this.dayPeriod.codeMap.get(plainTime);
        }

        @Override
        public String getDefaultMaximum() {
            if (this.fixed) {
                return "pm";
            }
            PlainTime plainTime = (PlainTime)this.dayPeriod.codeMap.lastKey();
            return (String)this.dayPeriod.codeMap.get(plainTime);
        }

        @Override
        public boolean isDateElement() {
            return false;
        }

        @Override
        public boolean isTimeElement() {
            return true;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append(this.name());
            stringBuilder.append('@');
            stringBuilder.append(this.dayPeriod);
            return stringBuilder.toString();
        }

        @Override
        protected <T extends ChronoEntity<T>> ElementRule<T, String> derive(Chronology<T> chronology) {
            if (chronology.isRegistered(PlainTime.COMPONENT)) {
                return this;
            }
            return null;
        }

        @Override
        protected boolean doEquals(BasicElement<?> basicElement) {
            Element element = (Element)basicElement;
            return this.dayPeriod.equals(element.dayPeriod);
        }

        @Override
        public String getValue(ChronoEntity<?> chronoEntity) {
            Object object;
            PlainTime plainTime = chronoEntity.get(PlainTime.COMPONENT);
            if (this.fixed) {
                return DayPeriod.getFixedCode(plainTime);
            }
            if (this.dayPeriod.isPredefined()) {
                String string;
                object = DayPeriod.loadTextForms(this.getLocale(), this.getCalendarType());
                String string2 = null;
                if (plainTime.isMidnight()) {
                    string2 = "midnight";
                } else if (plainTime.isSimultaneous(PlainTime.of(12))) {
                    string2 = "noon";
                }
                if (string2 != null && object.containsKey(string = DayPeriod.createKey((Map)object, TextWidth.ABBREVIATED, OutputContext.FORMAT, string2))) {
                    return string2;
                }
            }
            object = this.dayPeriod.getStart(plainTime);
            return (String)this.dayPeriod.codeMap.get(object);
        }

        @Override
        public String getMinimum(ChronoEntity<?> chronoEntity) {
            return this.getDefaultMinimum();
        }

        @Override
        public String getMaximum(ChronoEntity<?> chronoEntity) {
            return this.getDefaultMaximum();
        }

        @Override
        public boolean isValid(ChronoEntity<?> chronoEntity, String string) {
            return false;
        }

        @Override
        public ChronoEntity<?> withValue(ChronoEntity<?> chronoEntity, String string, boolean bl2) {
            throw new IllegalArgumentException("Day period element cannot be set.");
        }

        @Override
        public ChronoElement<?> getChildAtFloor(ChronoEntity<?> chronoEntity) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(ChronoEntity<?> chronoEntity) {
            return null;
        }

        boolean isFixed() {
            return this.fixed;
        }

        Locale getLocale() {
            return this.dayPeriod.locale;
        }

        String getCalendarType() {
            return this.dayPeriod.calendarType;
        }

        Object getCodeMap() {
            return this.dayPeriod.codeMap;
        }

        private Object writeReplace() {
            return new SPX(this, 7);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            throw new InvalidObjectException("Serialization proxy required.");
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
            OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
            String string = this.fixed ? this.dayPeriod.fixed(textWidth, outputContext).apply(chronoDisplay) : this.dayPeriod.approximate(textWidth, outputContext).apply(chronoDisplay);
            appendable.append(string);
        }

        @Override
        public String parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            int n2 = parsePosition.getIndex();
            OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
            String string = this.parse(charSequence, parsePosition, attributeQuery, outputContext);
            if (string == null && attributeQuery.get(Attributes.PARSE_MULTIPLE_CONTEXT, Boolean.TRUE).booleanValue()) {
                parsePosition.setErrorIndex(-1);
                parsePosition.setIndex(n2);
                outputContext = outputContext == OutputContext.FORMAT ? OutputContext.STANDALONE : OutputContext.FORMAT;
                string = this.parse(charSequence, parsePosition, attributeQuery, outputContext);
            }
            return string;
        }

        private String parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery, OutputContext outputContext) {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            Map map = null;
            if (this.fixed) {
                arrayList.add("am");
                arrayList.add("pm");
                arrayList.add("midnight");
                arrayList.add("noon");
            } else {
                object = new LinkedHashSet(this.dayPeriod.codeMap.values());
                arrayList.addAll((Collection<String>)object);
                if (this.dayPeriod.isPredefined()) {
                    arrayList.add("midnight");
                    arrayList.add("noon");
                }
            }
            if (this.dayPeriod.isPredefined()) {
                map = DayPeriod.loadTextForms(this.getLocale(), this.getCalendarType());
            }
            object = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
            boolean bl2 = attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
            boolean bl3 = attributeQuery.get(Attributes.PARSE_PARTIAL_COMPARE, Boolean.FALSE);
            String string = null;
            int n2 = parsePosition.getIndex();
            int n3 = charSequence.length();
            int n4 = 0;
            for (String string2 : arrayList) {
                String string3 = null;
                if (this.dayPeriod.isPredefined()) {
                    String string4;
                    if (this.fixed) {
                        string4 = DayPeriod.createKey(map, object, outputContext, string2);
                        if (!map.containsKey(string4)) {
                            if (string2.equals("midnight")) {
                                string4 = DayPeriod.createKey(map, object, outputContext, "am");
                            } else if (string2.equals("noon")) {
                                string4 = DayPeriod.createKey(map, object, outputContext, "pm");
                            }
                        }
                    } else {
                        string4 = DayPeriod.createKey(map, object, outputContext, string2);
                    }
                    if (map.containsKey(string4)) {
                        string3 = (String)map.get(string4);
                    }
                } else {
                    string3 = string2;
                }
                if (string3 == null) continue;
                int n5 = n2;
                int n6 = string3.length();
                boolean bl4 = true;
                for (int i2 = 0; bl4 && i2 < n6; ++i2) {
                    if (n2 + i2 >= n3) {
                        bl4 = false;
                        continue;
                    }
                    char c2 = charSequence.charAt(n2 + i2);
                    char c3 = string3.charAt(i2);
                    if (bl2) {
                        bl4 = this.compareIgnoreCase(c2, c3);
                    } else {
                        boolean bl5 = bl4 = c2 == c3;
                    }
                    if (!bl4) continue;
                    ++n5;
                }
                if (bl3 || n6 == 1) {
                    if (n4 < n5 - n2) {
                        n4 = n5 - n2;
                        string = string2;
                        continue;
                    }
                    if (string == null || n4 != n5 - n2) continue;
                    if (this.fixed) {
                        string = null;
                        continue;
                    }
                    string = string + "|" + string2;
                    continue;
                }
                if (!bl4) continue;
                n4 = n6;
                if (string == null) {
                    string = string2;
                    continue;
                }
                if (this.fixed) {
                    string = null;
                    continue;
                }
                string = string + "|" + string2;
            }
            if (string == null) {
                parsePosition.setErrorIndex(n2);
            } else {
                parsePosition.setIndex(n2 + n4);
            }
            return string;
        }

        private boolean compareIgnoreCase(char c2, char c3) {
            if (c2 >= 'a' && c2 <= 'z') {
                c2 = (char)(c2 - 97 + 65);
            }
            if (c3 >= 'a' && c3 <= 'z') {
                c3 = (char)(c3 - 97 + 65);
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                return c2 == c3;
            }
            Locale locale = this.getLocale();
            String string = String.valueOf(c2).toUpperCase(locale);
            String string2 = String.valueOf(c3).toUpperCase(locale);
            return string.equals(string2);
        }
    }

    static class Extension
    implements ChronoExtension {
        Extension() {
        }

        @Override
        public boolean accept(Class<?> clazz) {
            return PlainTime.class.isAssignableFrom(clazz);
        }

        @Override
        public Set<ChronoElement<?>> getElements(Locale locale, AttributeQuery attributeQuery) {
            DayPeriod dayPeriod = Extension.from(locale, attributeQuery);
            HashSet<Element> hashSet = new HashSet<Element>();
            hashSet.add(new Element(false, dayPeriod));
            if (!attributeQuery.contains(CUSTOM)) {
                hashSet.add(new Element(true, dayPeriod));
            }
            return Collections.unmodifiableSet(hashSet);
        }

        @Override
        public ChronoEntity<?> resolve(ChronoEntity<?> chronoEntity, Locale locale, AttributeQuery attributeQuery) {
            if (chronoEntity.contains(PlainTime.COMPONENT) || chronoEntity.contains(PlainTime.HOUR_FROM_0_TO_24) || chronoEntity.contains(PlainTime.DIGITAL_HOUR_OF_DAY) || chronoEntity.contains(PlainTime.CLOCK_HOUR_OF_DAY)) {
                return chronoEntity;
            }
            DayPeriod dayPeriod = Extension.from(locale, attributeQuery);
            Element element = new Element(false, dayPeriod);
            if (chronoEntity.contains(element)) {
                String string = chronoEntity.get(element);
                int n2 = 0;
                int n3 = 0;
                Meridiem meridiem = null;
                do {
                    int n4;
                    String string2 = (n4 = string.indexOf(124, n2)) == -1 ? string.substring(n2) : string.substring(n2, n4);
                    n2 = n4 + 1;
                    ++n3;
                    if (dayPeriod.isPredefined() && meridiem == null) {
                        if (string2.equals("midnight")) {
                            meridiem = Meridiem.AM;
                            continue;
                        }
                        if (string2.equals("noon")) {
                            meridiem = Meridiem.PM;
                            continue;
                        }
                    }
                    for (PlainTime plainTime : dayPeriod.codeMap.keySet()) {
                        if (!((String)dayPeriod.codeMap.get(plainTime)).equals(string2)) continue;
                        Meridiem meridiem2 = null;
                        int n5 = Extension.getHour12(chronoEntity);
                        PlainTime plainTime2 = dayPeriod.getEnd(plainTime);
                        if (plainTime.getHour() >= 12) {
                            if (plainTime2.isAfter(plainTime) || plainTime2.isSimultaneous(PlainTime.midnightAtStartOfDay())) {
                                meridiem2 = Meridiem.PM;
                            } else if (n5 != -1) {
                                meridiem2 = n5 + 12 >= plainTime.getHour() ? Meridiem.PM : Meridiem.AM;
                            }
                        } else if (!plainTime2.isAfter(PlainTime.of(12))) {
                            meridiem2 = Meridiem.AM;
                        } else if (n5 != -1) {
                            Meridiem meridiem3 = meridiem2 = n5 >= plainTime.getHour() ? Meridiem.AM : Meridiem.PM;
                        }
                        if (meridiem2 == null) continue;
                        if (meridiem != null && meridiem != meridiem2) {
                            if (n5 == -1) {
                                meridiem = null;
                                continue;
                            }
                            if (string2.startsWith("night")) {
                                meridiem = n5 < 6 ? Meridiem.AM : Meridiem.PM;
                                continue;
                            }
                            if (string2.startsWith("afternoon")) {
                                meridiem = n5 < 6 ? Meridiem.PM : Meridiem.AM;
                                continue;
                            }
                            meridiem = null;
                            continue;
                        }
                        meridiem = meridiem2;
                    }
                } while (n2 > 0);
                if (meridiem != null) {
                    chronoEntity = chronoEntity.with(PlainTime.AM_PM_OF_DAY, meridiem);
                    if (n3 > 1) {
                        chronoEntity = chronoEntity.with(element, null);
                    }
                }
            } else {
                Element element2 = new Element(true, dayPeriod);
                if (chronoEntity.contains(element2)) {
                    String string = chronoEntity.get(element2);
                    chronoEntity = string.equals("am") || string.equals("midnight") ? chronoEntity.with(PlainTime.AM_PM_OF_DAY, Meridiem.AM) : chronoEntity.with(PlainTime.AM_PM_OF_DAY, Meridiem.PM);
                    chronoEntity = chronoEntity.with(element2, null);
                }
            }
            return chronoEntity;
        }

        @Override
        public boolean canResolve(ChronoElement<?> chronoElement) {
            return chronoElement instanceof Element;
        }

        private static int getHour12(ChronoEntity<?> chronoEntity) {
            int n2 = -1;
            if (chronoEntity.contains(PlainTime.CLOCK_HOUR_OF_AMPM)) {
                n2 = (Integer)chronoEntity.get(PlainTime.CLOCK_HOUR_OF_AMPM);
                if (n2 == 12) {
                    n2 = 0;
                }
            } else if (chronoEntity.contains(PlainTime.DIGITAL_HOUR_OF_AMPM)) {
                n2 = (Integer)chronoEntity.get(PlainTime.DIGITAL_HOUR_OF_AMPM);
            }
            return n2;
        }

        private static DayPeriod from(Locale locale, AttributeQuery attributeQuery) {
            if (attributeQuery.contains(CUSTOM)) {
                return (DayPeriod)attributeQuery.get(CUSTOM);
            }
            return DayPeriod.of(locale, attributeQuery.get(Attributes.CALENDAR_TYPE, "iso8601"));
        }
    }
}

