/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.yaml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import liquibase.GlobalConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.OfflineConnection;
import liquibase.exception.LiquibaseParseException;
import liquibase.parser.SnapshotParser;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.yaml.YamlParser;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.RestoredDatabaseSnapshot;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class YamlSnapshotParser
extends YamlParser
implements SnapshotParser {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DatabaseSnapshot parse(String path, ResourceAccessor resourceAccessor) throws LiquibaseParseException {
        Yaml yaml = new Yaml(new SafeConstructor());
        try (InputStream stream = resourceAccessor.openStream(null, path);){
            if (stream == null) {
                throw new LiquibaseParseException(path + " does not exist");
            }
            Map parsedYaml = this.getParsedYamlFromInputStream(yaml, stream);
            Map rootList = (Map)parsedYaml.get("snapshot");
            if (rootList == null) {
                throw new LiquibaseParseException("Could not find root snapshot node");
            }
            String shortName = (String)((Map)rootList.get("database")).get("shortName");
            Database database = (Database)DatabaseFactory.getInstance().getDatabase(shortName).getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            database.setConnection(new OfflineConnection("offline:" + shortName, null));
            RestoredDatabaseSnapshot snapshot = new RestoredDatabaseSnapshot(database);
            ParsedNode snapshotNode = new ParsedNode(null, "snapshot");
            snapshotNode.setValue(rootList);
            Map metadata = (Map)rootList.get("metadata");
            if (metadata != null) {
                snapshot.getMetadata().putAll(metadata);
            }
            snapshot.load(snapshotNode, resourceAccessor);
            RestoredDatabaseSnapshot restoredDatabaseSnapshot = snapshot;
            return restoredDatabaseSnapshot;
        }
        catch (LiquibaseParseException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new LiquibaseParseException(e3);
        }
    }

    private Map getParsedYamlFromInputStream(Yaml yaml, InputStream stream) throws LiquibaseParseException {
        Map parsedYaml;
        try (InputStreamReader inputStreamReader = new InputStreamReader(stream, GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue());){
            parsedYaml = (Map)yaml.load(inputStreamReader);
        }
        catch (Exception e2) {
            throw new LiquibaseParseException("Syntax error in " + this.getSupportedFileExtensions()[0] + ": " + e2.getMessage(), e2);
        }
        return parsedYaml;
    }
}

