/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.scenario.animation.AbstractPrimaryTimer;
import com.sun.scenario.animation.shared.TimelineClipCore;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.util.Duration;

public final class Timeline
extends Animation {
    final TimelineClipCore clipCore;
    private final ObservableList<KeyFrame> keyFrames = new TrackableObservableList<KeyFrame>(){

        @Override
        protected void onChanged(ListChangeListener.Change<KeyFrame> change) {
            while (change.next()) {
                String string;
                if (change.wasPermutated()) continue;
                for (KeyFrame keyFrame : change.getRemoved()) {
                    string = keyFrame.getName();
                    if (string == null) continue;
                    Timeline.this.getCuePoints().remove(string);
                }
                for (KeyFrame keyFrame : change.getAddedSubList()) {
                    string = keyFrame.getName();
                    if (string == null) continue;
                    Timeline.this.getCuePoints().put(string, keyFrame.getTime());
                }
                Duration duration = Timeline.this.clipCore.setKeyFrames(Timeline.this.getKeyFrames());
                Timeline.this.setCycleDuration(duration);
            }
        }
    };

    public final ObservableList<KeyFrame> getKeyFrames() {
        return this.keyFrames;
    }

    public Timeline(double d2, KeyFrame ... keyFrameArray) {
        super(d2);
        this.clipCore = new TimelineClipCore(this);
        this.getKeyFrames().setAll((KeyFrame[])keyFrameArray);
    }

    public Timeline(KeyFrame ... keyFrameArray) {
        this.clipCore = new TimelineClipCore(this);
        this.getKeyFrames().setAll((KeyFrame[])keyFrameArray);
    }

    public Timeline(double d2) {
        super(d2);
        this.clipCore = new TimelineClipCore(this);
    }

    public Timeline() {
        this.clipCore = new TimelineClipCore(this);
    }

    Timeline(AbstractPrimaryTimer abstractPrimaryTimer) {
        super(abstractPrimaryTimer);
        this.clipCore = new TimelineClipCore(this);
    }

    @Override
    void doPlayTo(long l2, long l3) {
        this.clipCore.playTo(l2);
    }

    @Override
    void doJumpTo(long l2, long l3, boolean bl2) {
        this.sync(false);
        this.setCurrentTicks(l2);
        this.clipCore.jumpTo(l2, bl2);
    }

    @Override
    void setCurrentRate(double d2) {
        super.setCurrentRate(d2);
        this.clipCore.notifyCurrentRateChanged();
    }

    @Override
    void doStart(boolean bl2) {
        super.doStart(bl2);
        this.clipCore.start(bl2);
    }

    @Override
    public void stop() {
        if (this.parent != null) {
            throw new IllegalStateException("Cannot stop when embedded in another animation");
        }
        if (this.getStatus() == Animation.Status.RUNNING) {
            this.clipCore.abort();
        }
        super.stop();
    }
}

