/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.CommandObject;
import jakarta.activation.DataHandler;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class CommandInfo {
    private String verb;
    private String className;

    public CommandInfo(String verb, String className) {
        this.verb = verb;
        this.className = className;
    }

    public String getCommandName() {
        return this.verb;
    }

    public String getCommandClass() {
        return this.className;
    }

    public Object getCommandObject(DataHandler dh2, ClassLoader loader) throws IOException, ClassNotFoundException {
        Object new_bean = null;
        new_bean = Beans.instantiate(loader, this.className);
        if (new_bean != null) {
            InputStream is2;
            if (new_bean instanceof CommandObject) {
                ((CommandObject)new_bean).setCommandContext(this.verb, dh2);
            } else if (new_bean instanceof Externalizable && dh2 != null && (is2 = dh2.getInputStream()) != null) {
                ((Externalizable)new_bean).readExternal(new ObjectInputStream(is2));
            }
        }
        return new_bean;
    }

    private static final class Beans {
        static final Method instantiateMethod;

        private Beans() {
        }

        static Object instantiate(ClassLoader loader, String cn2) throws IOException, ClassNotFoundException {
            block10: {
                if (instantiateMethod != null) {
                    try {
                        return instantiateMethod.invoke(null, loader, cn2);
                    }
                    catch (InvocationTargetException e2) {
                        InvocationTargetException exception = e2;
                        break block10;
                    }
                    catch (IllegalAccessException e3) {
                        IllegalAccessException exception = e3;
                        break block10;
                    }
                }
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    int i2;
                    int b2;
                    String cname = cn2.replace('/', '.');
                    if (cname.startsWith("[") && (b2 = cname.lastIndexOf(91) + 2) > 1 && b2 < cname.length()) {
                        cname = cname.substring(b2);
                    }
                    if ((i2 = cname.lastIndexOf(46)) != -1) {
                        security.checkPackageAccess(cname.substring(0, i2));
                    }
                }
                if (loader == null) {
                    loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            ClassLoader cl2 = null;
                            try {
                                cl2 = ClassLoader.getSystemClassLoader();
                            }
                            catch (SecurityException securityException) {
                                // empty catch block
                            }
                            return cl2;
                        }
                    });
                }
                Class<?> beanClass = Class.forName(cn2, true, loader);
                try {
                    return beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex2) {
                    throw new ClassNotFoundException(beanClass + ": " + ex2, ex2);
                }
            }
            return null;
        }

        static {
            Method m3;
            try {
                Class<?> c2 = Class.forName("java.beans.Beans");
                m3 = c2.getDeclaredMethod("instantiate", ClassLoader.class, String.class);
            }
            catch (ClassNotFoundException e2) {
                m3 = null;
            }
            catch (NoSuchMethodException e3) {
                m3 = null;
            }
            instantiateMethod = m3;
        }
    }
}

