/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.swe.common.simple.range;

import de.fraunhofer.iosb.ilt.swe.common.constraint.AllowedTimes;
import de.fraunhofer.iosb.ilt.swe.common.simple.AbstractSimpleComponent;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeRange
extends AbstractSimpleComponent<List<String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeRange.class);
    private String referenceTime;
    private String localFrame;
    private String uom;
    private AllowedTimes constraint;
    private List<String> value;

    public String getReferenceTime() {
        return this.referenceTime;
    }

    public void setReferenceTime(String referenceTime) {
        this.referenceTime = referenceTime;
    }

    public String getLocalFrame() {
        return this.localFrame;
    }

    public void setLocalFrame(String localFrame) {
        this.localFrame = localFrame;
    }

    public String getUom() {
        return this.uom;
    }

    public void setUom(String uom) {
        this.uom = uom;
    }

    public AllowedTimes getConstraint() {
        return this.constraint;
    }

    public void setConstraint(AllowedTimes constraint) {
        this.constraint = constraint;
    }

    @Override
    public List<String> getValue() {
        return this.value;
    }

    @Override
    public void setValue(List<String> value) {
        this.value = value;
    }

    @Override
    public boolean valueIsValid() {
        if (this.getValue() == null) {
            return false;
        }
        if (this.getConstraint() == null) {
            return true;
        }
        Iterator iterator = this.getValue().iterator();
        while (iterator.hasNext()) {
            String item = (String)iterator.next();
            if (this.constraint.isValid(item, this.uom)) continue;
            LOGGER.error("Item '{}' does not fit the constraint", (Object)item);
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.referenceTime);
        hash = 97 * hash + Objects.hashCode(this.localFrame);
        hash = 97 * hash + Objects.hashCode(this.uom);
        hash = 97 * hash + Objects.hashCode(this.constraint);
        hash = 97 * hash + Objects.hashCode(this.value);
        hash = 97 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeRange other = (TimeRange)obj;
        if (!Objects.equals(this.referenceTime, other.referenceTime)) {
            return false;
        }
        if (!Objects.equals(this.localFrame, other.localFrame)) {
            return false;
        }
        if (!Objects.equals(this.uom, other.uom)) {
            return false;
        }
        if (!Objects.equals(this.constraint, other.constraint)) {
            return false;
        }
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        return super.equals(obj);
    }
}

