/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.swe.common.constraint;

import de.fraunhofer.iosb.ilt.swe.common.constraint.AbstractConstraint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class AllowedTokens
extends AbstractConstraint {
    private List<String> value;
    private String pattern;

    public AllowedTokens() {
        this.value = new ArrayList<String>();
    }

    public AllowedTokens(String ... tokens) {
        this.value = Arrays.asList(tokens);
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.value);
        hash = 37 * hash + Objects.hashCode(this.pattern);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllowedTokens other = (AllowedTokens)obj;
        if (!Objects.equals(this.pattern, other.pattern)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    public AllowedTokens(String pattern) {
        this.pattern = pattern;
    }

    public List<String> getValue() {
        return this.value;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isValid(String input) {
        Pattern compiled;
        if (this.value != null) {
            for (String item : this.value) {
                if (!item.equals(input)) continue;
                return true;
            }
        }
        return this.pattern != null && !this.pattern.isEmpty() && (compiled = Pattern.compile(this.pattern)).matcher(input).matches();
    }

    public void setValue(List<String> value) {
        this.value = value;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

