/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.query;

import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.query.InvalidRelationException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ExpandedEntity {
    private final List<EntityType> entities;

    private ExpandedEntity(EntityType ... entities) throws InvalidRelationException {
        this.entities = new ArrayList<EntityType>(entities.length);
        for (int i2 = 0; i2 < entities.length; ++i2) {
            if (i2 > 0 && !entities[i2 - 1].hasRelationTo(entities[i2])) {
                throw new InvalidRelationException(String.format("%s is not directly related to %s", entities[i2].getName(), entities[i2 - 1].getName()));
            }
            this.entities.add(entities[i2]);
        }
    }

    public static ExpandedEntity from(EntityType ... entities) throws InvalidRelationException {
        return new ExpandedEntity(entities);
    }

    public String toString() {
        return this.entities.stream().map(e2 -> e2.getName()).collect(Collectors.joining("/"));
    }

    public EntityType getDirectSibling() {
        return this.entities.get(0);
    }
}

