/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.dao.LocationDao;
import de.fraunhofer.iosb.ilt.sta.jackson.LocationDeserializer;
import de.fraunhofer.iosb.ilt.sta.jackson.LocationSerializer;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.HistoricalLocation;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Location
extends Entity<Location> {
    private String name;
    private String description;
    private String encodingType;
    @JsonDeserialize(using=LocationDeserializer.class)
    @JsonSerialize(using=LocationSerializer.class)
    private Object location;
    private Map<String, Object> properties;
    private final EntityList<Thing> things = new EntityList(EntityType.THINGS);
    private final EntityList<HistoricalLocation> historicalLocations = new EntityList(EntityType.HISTORICAL_LOCATIONS);

    public Location() {
        super(EntityType.LOCATION);
    }

    public Location(String name, String description, String encodingType, Object location) {
        this();
        this.name = name;
        this.description = description;
        this.encodingType = encodingType;
        this.location = location;
    }

    @Override
    protected void ensureServiceOnChildren(SensorThingsService service) {
        this.things.setService(service, Thing.class);
        this.historicalLocations.setService(service, HistoricalLocation.class);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.encodingType, other.encodingType)) {
            return false;
        }
        if (!Objects.equals(this.location, other.location)) {
            return false;
        }
        if (!Objects.equals(this.properties, other.properties)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 59 * hash + Objects.hashCode(this.name);
        hash = 59 * hash + Objects.hashCode(this.description);
        hash = 59 * hash + Objects.hashCode(this.encodingType);
        hash = 59 * hash + Objects.hashCode(this.location);
        hash = 59 * hash + Objects.hashCode(this.properties);
        return hash;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public BaseDao<HistoricalLocation> historicalLocations() {
        return this.getService().historicalLocations().setParent(this);
    }

    @JsonProperty(value="HistoricalLocations")
    public EntityList<HistoricalLocation> getHistoricalLocations() {
        return this.historicalLocations;
    }

    @JsonProperty(value="HistoricalLocations")
    public void setHistoricalLocations(List<HistoricalLocation> historicalLocations) {
        this.historicalLocations.replaceAll(historicalLocations);
    }

    public Object getLocation() {
        return this.location;
    }

    public void setLocation(Object location) {
        this.location = location;
    }

    public BaseDao<Thing> things() {
        return this.getService().things().setParent(this);
    }

    @JsonProperty(value="Things")
    public EntityList<Thing> getThings() {
        return this.things;
    }

    @JsonProperty(value="Things")
    public void setThings(List<Thing> things) {
        this.things.replaceAll(things);
    }

    @Override
    public BaseDao<Location> getDao(SensorThingsService service) {
        return new LocationDao(service);
    }

    @Override
    public Location withOnlyId() {
        Location copy = new Location();
        copy.setId(this.id);
        return copy;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.getName();
    }
}

