/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.JsonPatchOperation;
import de.fraunhofer.iosb.ilt.sta.MqttException;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.Utils;
import de.fraunhofer.iosb.ilt.sta.dao.Dao;
import de.fraunhofer.iosb.ilt.sta.jackson.ObjectMapperFactory;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityProperty;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.Id;
import de.fraunhofer.iosb.ilt.sta.model.IdLong;
import de.fraunhofer.iosb.ilt.sta.model.IdString;
import de.fraunhofer.iosb.ilt.sta.query.Expansion;
import de.fraunhofer.iosb.ilt.sta.query.Query;
import de.fraunhofer.iosb.ilt.sta.service.MqttSubscription;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDao<T extends Entity<T>>
implements Dao<T> {
    public static final ContentType APPLICATION_JSON_PATCH = ContentType.create("application/json-patch+json", Consts.UTF_8);
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDao.class);
    private final SensorThingsService service;
    private final EntityType plural;
    private final EntityType singular;
    private final Class<T> entityClass;
    private Entity<?> parent;

    public BaseDao(SensorThingsService service, Class<T> entityClass) {
        this.service = service;
        this.plural = EntityType.listForClass(entityClass);
        this.singular = EntityType.singleForClass(entityClass);
        this.entityClass = entityClass;
    }

    public BaseDao(SensorThingsService service, Class<T> entityClass, Entity<?> parent) {
        this(service, entityClass);
        this.parent = parent;
    }

    public BaseDao<T> setParent(Entity<?> parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public void create(T entity) throws ServiceFailureException {
        HttpPost httpPost;
        String json;
        if (this.parent != null && !this.parent.getType().hasRelationTo(this.plural)) {
            throw new IllegalArgumentException("Can not create entity, not a list");
        }
        ObjectMapper mapper = ObjectMapperFactory.get();
        try {
            URIBuilder uriBuilder = new URIBuilder(this.service.getFullPath(this.parent, this.plural).toURI());
            json = mapper.writeValueAsString(entity);
            httpPost = new HttpPost(uriBuilder.build());
        }
        catch (JsonProcessingException | URISyntaxException ex2) {
            throw new ServiceFailureException("Failed to create entity.", ex2);
        }
        LOGGER.debug("Posting to: {}", (Object)httpPost.getURI());
        httpPost.setEntity(new StringEntity(json, ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse response = this.service.execute(httpPost);){
            Utils.throwIfNotOk(httpPost, response);
            Header locationHeader = response.getLastHeader("location");
            EntityUtils.consumeQuietly(response.getEntity());
            if (locationHeader == null) {
                throw new IllegalStateException("Server did not send a location header for the new entitiy.");
            }
            String newLocation = locationHeader.getValue();
            int pos1 = newLocation.indexOf(40) + 1;
            int pos2 = newLocation.indexOf(41, pos1);
            String stringId = newLocation.substring(pos1, pos2);
            ((Entity)entity).setId(Id.tryToParse(stringId));
            ((Entity)entity).setService(this.service);
        }
        catch (IOException exc) {
            throw new ServiceFailureException("Failed to create entity.", exc);
        }
    }

    @Override
    public T find(Entity<?> parent) throws ServiceFailureException {
        try {
            URL fullPath = this.service.getFullPath(parent, this.singular);
            return this.find(fullPath.toURI());
        }
        catch (URISyntaxException ex2) {
            throw new ServiceFailureException(ex2);
        }
    }

    @Override
    public T find(Id id2) throws ServiceFailureException {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.service.getEndpoint().toString() + this.entityPath(id2));
            return this.find(uriBuilder.build());
        }
        catch (URISyntaxException ex2) {
            throw new ServiceFailureException(ex2);
        }
    }

    public T find(long id2) throws ServiceFailureException {
        return this.find(new IdLong(id2));
    }

    public T find(String id2) throws ServiceFailureException {
        return this.find(new IdString(id2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T find(URI uri) throws ServiceFailureException {
        HttpGet httpGet = new HttpGet(uri);
        LOGGER.debug("Fetching: {}", (Object)uri);
        httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        try (CloseableHttpResponse response = this.service.execute(httpGet);){
            Utils.throwIfNotOk(httpGet, response);
            String returnContent = EntityUtils.toString(response.getEntity(), Consts.UTF_8);
            ObjectMapper mapper = ObjectMapperFactory.get();
            Entity entity2 = (Entity)mapper.readValue(returnContent, this.entityClass);
            entity2.setService(this.service);
            Entity entity = entity2;
            return (T)entity;
        }
        catch (IOException | ParseException ex2) {
            throw new ServiceFailureException(ex2);
        }
    }

    @Override
    public T find(Id id2, Expansion expansion) throws ServiceFailureException {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.service.getEndpoint().toString() + this.entityPath(id2));
            uriBuilder.addParameter("$expand", expansion.toString());
            return this.find(uriBuilder.build());
        }
        catch (URISyntaxException ex2) {
            throw new ServiceFailureException(ex2);
        }
    }

    @Override
    public void update(T entity) throws ServiceFailureException {
        HttpPatch httpPatch;
        String json;
        ObjectMapper mapper = ObjectMapperFactory.get();
        try {
            URIBuilder uriBuilder = new URIBuilder(this.service.getEndpoint().toString() + this.entityPath(((Entity)entity).getId()));
            json = mapper.writeValueAsString(entity);
            httpPatch = new HttpPatch(uriBuilder.build());
        }
        catch (JsonProcessingException | URISyntaxException ex2) {
            throw new ServiceFailureException(ex2);
        }
        LOGGER.debug("Patching: {}", (Object)httpPatch.getURI());
        httpPatch.setEntity(new StringEntity(json, ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse response = this.service.execute(httpPatch);){
            Utils.throwIfNotOk(httpPatch, response);
            EntityUtils.consumeQuietly(response.getEntity());
        }
        catch (IOException ex3) {
            throw new ServiceFailureException(ex3);
        }
    }

    @Override
    public void patch(T entity, List<JsonPatchOperation> patch) throws ServiceFailureException {
        HttpPatch httpPatch;
        String json;
        ObjectMapper mapper = ObjectMapperFactory.get();
        try {
            URIBuilder uriBuilder = new URIBuilder(this.service.getEndpoint().toString() + this.entityPath(((Entity)entity).getId()));
            json = mapper.writeValueAsString(patch);
            httpPatch = new HttpPatch(uriBuilder.build());
        }
        catch (JsonProcessingException | URISyntaxException ex2) {
            throw new ServiceFailureException(ex2);
        }
        LOGGER.debug("Patching: {} with patch {}", (Object)httpPatch.getURI(), (Object)patch);
        httpPatch.setEntity(new StringEntity(json, APPLICATION_JSON_PATCH));
        try (CloseableHttpResponse response = this.service.execute(httpPatch);){
            Utils.throwIfNotOk(httpPatch, response);
            EntityUtils.consumeQuietly(response.getEntity());
        }
        catch (IOException ex3) {
            throw new ServiceFailureException(ex3);
        }
    }

    @Override
    public void delete(T entity) throws ServiceFailureException {
        HttpDelete httpDelete;
        try {
            URIBuilder uriBuilder = new URIBuilder(this.service.getEndpoint().toString() + this.entityPath(((Entity)entity).getId()));
            httpDelete = new HttpDelete(uriBuilder.build());
        }
        catch (URISyntaxException ex2) {
            throw new ServiceFailureException(ex2);
        }
        LOGGER.debug("Deleting: {}", (Object)httpDelete.getURI());
        try (CloseableHttpResponse response = this.service.execute(httpDelete);){
            Utils.throwIfNotOk(httpDelete, response);
            EntityUtils.consumeQuietly(response.getEntity());
        }
        catch (IOException ex3) {
            throw new ServiceFailureException(ex3);
        }
    }

    @Override
    public Query<T> query() {
        return new Query<T>(this.service, this.entityClass, this.parent);
    }

    private String entityPath(Id id2) {
        return String.format("%s(%s)", this.plural.getName(), id2.getUrl());
    }

    protected SensorThingsService getService() {
        return this.service;
    }

    @Override
    public MqttSubscription subscribe(Consumer<T> handler) throws MqttException {
        return this.service.subscribe(this.getMqttTopic(), handler, this.entityClass, null);
    }

    @Override
    public MqttSubscription subscribe(Predicate<T> filter, Consumer<T> handler) throws MqttException {
        return this.service.subscribe(this.getMqttTopic(), handler, this.entityClass, filter);
    }

    private void validatePropertySelect(EntityProperty ... properties) throws MqttException {
        if (Stream.of(properties).anyMatch(x2 -> !this.singular.hasProperty((EntityProperty)((Object)x2)))) {
            throw new MqttException("use of unknown property in $select. Allowed properties for type " + this.singular.getName() + ": " + this.singular.getProperties().stream().map(x2 -> x2.getName()).collect(Collectors.joining(", ")));
        }
    }

    @Override
    public MqttSubscription subscribe(Predicate<T> filter, Consumer<T> handler, EntityProperty ... properties) throws MqttException {
        this.validatePropertySelect(properties);
        return this.service.subscribe(this.getMqttTopic(Arrays.asList(properties)), handler, this.entityClass, filter);
    }

    @Override
    public MqttSubscription subscribe(Consumer<T> handler, EntityProperty ... properties) throws MqttException {
        this.validatePropertySelect(properties);
        return this.service.subscribe(this.getMqttTopic(Arrays.asList(properties)), handler, this.entityClass, null);
    }

    public MqttSubscription subscribe(Entity entity, Consumer<T> handler) throws MqttException {
        return this.service.subscribe(this.getMqttTopic(entity), handler, this.entityClass, null);
    }

    protected String getMqttTopic() {
        if (this.parent != null && !this.parent.getType().hasRelationTo(this.plural)) {
            throw new IllegalArgumentException("Cannot create entity, not a list");
        }
        return this.service.getVersion().getUrlPattern() + "/" + this.service.getPath(this.parent, this.plural);
    }

    protected String getMqttTopic(Entity entity) throws MqttException {
        if (this.parent != null && !this.parent.getType().hasRelationTo(this.plural)) {
            throw new IllegalArgumentException("Cannot create entity, not a list");
        }
        return this.service.getVersion().getUrlPattern() + "/" + this.entityPath(entity.getId());
    }

    protected String getMqttTopic(List<EntityProperty> properties) throws MqttException {
        if (this.parent != null && !this.parent.getType().hasRelationTo(this.plural)) {
            throw new IllegalArgumentException("Cannot create entity, not a list");
        }
        String result = this.service.getVersion().getUrlPattern() + "/" + this.service.getPath(this.parent, this.plural);
        if (properties != null && !properties.isEmpty()) {
            if (properties.stream().anyMatch(x2 -> !this.singular.hasProperty((EntityProperty)((Object)x2)))) {
                throw new MqttException("Property not defined for this entity. Allowed properties: " + this.singular.getProperties());
            }
            result = result + "?$select=" + properties.stream().map(x2 -> x2.getName()).collect(Collectors.joining(","));
        }
        return result;
    }

    @Override
    public void unsubscribe(MqttSubscription subscription) throws MqttException {
        this.service.unsubscribe(subscription);
    }

    @Override
    public void unsubscribe() throws MqttException {
        this.service.unsubscribe(this.getMqttTopic());
    }
}

