/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.settings;

import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValue;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueBoolean;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceSettings
implements ConfigDefaults {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistenceSettings.class.getName());
    @DefaultValue(value="de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.imp.PostgresPersistenceManagerLong")
    public static final String TAG_IMPLEMENTATION_CLASS = "persistenceManagerImplementationClass";
    @DefaultValue(value="ServerGeneratedOnly")
    public static final String TAG_ID_GENERATION_MODE = "idGenerationMode";
    @DefaultValueBoolean(value=false)
    public static final String TAG_AUTO_UPDATE_DATABASE = "autoUpdateDatabase";
    @DefaultValueInt(value=200)
    public static final String TAG_SLOW_QUERY_THRESHOLD = "slowQueryThreshold";
    @DefaultValueInt(value=0)
    public static final String TAG_QUERY_TIMEOUT = "queryTimeout";
    @DefaultValue(value="full")
    public static final String TAG_COUNT_MODE = "countMode";
    @DefaultValueInt(value=10000)
    public static final String TAG_ESTIMATE_COUNT_THRESHOLD = "countEstimateThreshold";
    private String persistenceManagerImplementationClass;
    private String idGenerationMode;
    private boolean autoUpdateDatabase;
    private CountMode countMode;
    private int estimateCountThreshold;
    private int slowQueryThreshold;
    private boolean logSlowQueries;
    private int queryTimeout;
    private boolean timeoutQueries;
    private Settings customSettings;

    public PersistenceSettings(Settings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("settings most be non-null");
        }
        this.init(settings);
    }

    private void init(Settings settings) {
        this.persistenceManagerImplementationClass = settings.get(TAG_IMPLEMENTATION_CLASS, this.getClass());
        this.idGenerationMode = settings.get(TAG_ID_GENERATION_MODE, this.getClass());
        this.autoUpdateDatabase = settings.getBoolean(TAG_AUTO_UPDATE_DATABASE, this.getClass());
        this.slowQueryThreshold = settings.getInt(TAG_SLOW_QUERY_THRESHOLD, this.getClass());
        this.logSlowQueries = this.slowQueryThreshold > 0;
        this.queryTimeout = settings.getInt(TAG_QUERY_TIMEOUT, this.getClass());
        this.timeoutQueries = this.queryTimeout > 0;
        this.countMode = CountMode.fromValue(settings.get(TAG_COUNT_MODE, this.getClass()));
        this.estimateCountThreshold = settings.getInt(TAG_ESTIMATE_COUNT_THRESHOLD, this.getClass());
        this.customSettings = settings;
    }

    public String getPersistenceManagerImplementationClass() {
        return this.persistenceManagerImplementationClass;
    }

    public boolean isAutoUpdateDatabase() {
        return this.autoUpdateDatabase;
    }

    public Settings getCustomSettings() {
        return this.customSettings;
    }

    public String getIdGenerationMode() {
        return this.idGenerationMode;
    }

    public int getSlowQueryThreshold() {
        return this.slowQueryThreshold;
    }

    public boolean isLogSlowQueries() {
        return this.logSlowQueries;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public boolean isTimeoutQueries() {
        return this.timeoutQueries;
    }

    public CountMode getCountMode() {
        return this.countMode;
    }

    public int getEstimateCountThreshold() {
        return this.estimateCountThreshold;
    }

    public static enum CountMode {
        FULL,
        LIMIT_SAMPLE,
        SAMPLE_LIMIT,
        LIMIT_ESTIMATE,
        ESTIMATE_LIMIT;


        public static CountMode fromValue(String value) {
            try {
                return CountMode.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException exc) {
                LOGGER.error("No CountMode named {}, should be one of {}", (Object)value, (Object)CountMode.values());
                return FULL;
            }
        }
    }
}

