/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.service;

import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ServiceRequest {
    public static final ThreadLocal<ServiceRequest> LOCAL_REQUEST = new ThreadLocal();
    private String requestType;
    private String urlPath;
    private String urlQuery;
    private String contentString;
    private InputStream contentBinary;
    private Version version;
    private String contentType;
    private Map<String, List<String>> parameterMap;
    private Map<String, Object> attributeMap;
    private Principal userPrincipal;
    private CoreSettings coreSettings;

    protected ServiceRequest() {
    }

    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(Map<String, Object> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public CoreSettings getCoreSettings() {
        return this.coreSettings;
    }

    protected void setCoreSettings(CoreSettings coreSettings) {
        this.coreSettings = coreSettings;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getContentString() {
        if (this.contentString != null) {
            return this.contentString;
        }
        return new BufferedReader(new InputStreamReader(this.contentBinary, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
    }

    public Reader getContentReader() {
        if (this.contentString != null) {
            return new StringReader(this.contentString);
        }
        return new BufferedReader(new InputStreamReader(this.contentBinary, StandardCharsets.UTF_8));
    }

    public InputStream getContentStream() {
        if (this.contentString != null) {
            return new ByteArrayInputStream(this.contentString.getBytes(StandardCharsets.UTF_8));
        }
        return this.contentBinary;
    }

    public void setContent(InputStream content) {
        this.contentBinary = content;
    }

    public void setContent(String content) {
        this.contentString = content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Map<String, List<String>> getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = new HashMap<String, List<String>>();
        }
        return this.parameterMap;
    }

    public void setParameterMap(Map<String, List<String>> parameterMap) {
        this.parameterMap = parameterMap;
    }

    public String getParameter(String parameter) {
        return this.getParameter(parameter, null);
    }

    public String getParameter(String parameter, String dflt) {
        if (this.parameterMap == null) {
            return dflt;
        }
        List<String> list = this.parameterMap.get(parameter);
        if (list == null || list.isEmpty()) {
            return dflt;
        }
        return list.get(0);
    }

    public ServiceRequest addParameterIfAbsent(String name, String value) {
        this.getParameterMap().putIfAbsent(name, Arrays.asList(value));
        return this;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    public String getUrlQuery() {
        return this.urlQuery;
    }

    public void setUrlQuery(String urlQuery) {
        this.urlQuery = urlQuery;
    }

    public String getUrl() {
        if (this.urlQuery == null || this.urlQuery.isEmpty()) {
            return this.urlPath;
        }
        return this.urlPath + "?" + this.urlQuery;
    }

    public final void setUrl(String url) {
        if (url.contains("?")) {
            this.urlPath = url.substring(0, url.lastIndexOf(63));
            this.urlQuery = url.substring(url.indexOf(63) + 1);
        } else {
            this.urlPath = url;
            this.urlQuery = null;
        }
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }
}

