/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.service;

import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManagerFactory;
import de.fraunhofer.iosb.ilt.frostserver.service.Plugin;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginModel;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginResultFormat;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginRootDocument;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginService;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValue;
import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUser;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager
implements ConfigDefaults {
    public static final String VALUE_PROVIDED_PLUGINS = "de.fraunhofer.iosb.ilt.frostserver.plugin.coremodel.PluginCoreService,de.fraunhofer.iosb.ilt.frostserver.plugin.coremodel.PluginCoreModel,de.fraunhofer.iosb.ilt.frostserver.formatter.PluginResultFormatDefault,de.fraunhofer.iosb.ilt.frostserver.plugin.actuation.PluginActuation,de.fraunhofer.iosb.ilt.frostserver.plugin.multidatastream.PluginMultiDatastream,de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.PluginBatchProcessing,de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.PluginResultFormatDataArray,de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.PluginResultFormatCsv,de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.PluginResultFormatGeoJson,de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.PluginOpenApi,de.fraunhofer.iosb.ilt.frostserver.plugin.odata.PluginOData,de.fraunhofer.iosb.ilt.frostserver.plugin.modelloader.PluginModelLoader";
    @DefaultValue(value="de.fraunhofer.iosb.ilt.frostserver.plugin.coremodel.PluginCoreService,de.fraunhofer.iosb.ilt.frostserver.plugin.coremodel.PluginCoreModel,de.fraunhofer.iosb.ilt.frostserver.formatter.PluginResultFormatDefault,de.fraunhofer.iosb.ilt.frostserver.plugin.actuation.PluginActuation,de.fraunhofer.iosb.ilt.frostserver.plugin.multidatastream.PluginMultiDatastream,de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.PluginBatchProcessing,de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.PluginResultFormatDataArray,de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.PluginResultFormatCsv,de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.PluginResultFormatGeoJson,de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.PluginOpenApi,de.fraunhofer.iosb.ilt.frostserver.plugin.odata.PluginOData,de.fraunhofer.iosb.ilt.frostserver.plugin.modelloader.PluginModelLoader")
    public static final String TAG_PROVIDED_PLUGINS = "providedPlugins";
    @DefaultValue(value="")
    public static final String TAG_PLUGINS = "plugins";
    public static final String PATH_WILDCARD = "*";
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginManager.class);
    private final Map<Version, Map<String, PluginResultFormat>> resultFormatters = new HashMap<Version, Map<String, PluginResultFormat>>();
    private final Map<Version, Map<String, PluginService>> pathHandlers = new HashMap<Version, Map<String, PluginService>>();
    private final Map<Version, Map<String, PluginService>> requestTypeHandlers = new HashMap<Version, Map<String, PluginService>>();
    private final List<PluginRootDocument> serviceDocModifiers = new ArrayList<PluginRootDocument>();
    private final List<PluginModel> modelModifiers = new ArrayList<PluginModel>();
    private final Map<Class<? extends Plugin>, Object> plugins = new HashMap<Class<? extends Plugin>, Object>();
    private final Map<String, Version> versions = new TreeMap<String, Version>();
    private CoreSettings settings;

    public PluginManager setCoreSettings(CoreSettings settings) {
        this.settings = settings;
        return this;
    }

    public void init() {
        Settings pluginSettings = this.settings.getPluginSettings();
        String provided = pluginSettings.get(TAG_PROVIDED_PLUGINS, this.getClass()).trim();
        String extra = pluginSettings.get(TAG_PLUGINS, this.getClass()).trim();
        LOGGER.info("Loading plugins.");
        this.loadPlugins(provided);
        this.loadPlugins(extra);
        this.initPlugins(PersistenceManagerFactory.getInstance(this.settings).create());
    }

    public void initPlugins(PersistenceManager pm2) {
        ModelRegistry modelRegistry = this.settings.getModelRegistry();
        for (PluginModel plugin : this.modelModifiers) {
            plugin.registerEntityTypes();
        }
        ArrayList<PluginModel> redo = new ArrayList<PluginModel>(this.modelModifiers);
        int pass = 0;
        while (!redo.isEmpty() && pass < 5) {
            LOGGER.info("Initialising data model plugins. Pass {}, {} plugins.", (Object)(++pass), (Object)redo.size());
            Iterator it2 = redo.iterator();
            while (it2.hasNext()) {
                PluginModel plugin = (PluginModel)it2.next();
                if (!plugin.linkEntityTypes(pm2)) continue;
                it2.remove();
            }
        }
        if (!redo.isEmpty()) {
            LOGGER.error("Failed to initialise {} data model plugins:", (Object)redo.size());
            for (PluginModel plugin : redo) {
                LOGGER.error("    {}", (Object)plugin.getClass().getName());
            }
        }
        modelRegistry.initFinalise();
    }

    private void loadPlugins(String classList) {
        String[] split;
        if (classList.isEmpty()) {
            return;
        }
        for (String className : split = classList.trim().split(",")) {
            try {
                LOGGER.info("Loading {}", (Object)className);
                Class<?> clazz = Class.forName(className.trim());
                Object newInstance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(newInstance instanceof Plugin)) continue;
                Plugin plugin = (Plugin)newInstance;
                plugin.init(this.settings);
            }
            catch (ClassNotFoundException | NoClassDefFoundError ex2) {
                LOGGER.warn("Could not find given plugin class: '{}': {}", (Object)StringHelper.cleanForLogging(className), (Object)ex2.getMessage());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex3) {
                LOGGER.warn("Could not load given plugin class: '{}': {}", (Object)StringHelper.cleanForLogging(className), (Object)ex3.getMessage());
                LOGGER.info("Exception:", ex3);
            }
            catch (RuntimeException ex4) {
                LOGGER.warn("Plugin caused an exception during initialisation.", ex4);
            }
        }
    }

    public void registerPlugin(Plugin plugin) {
        if (plugin instanceof PluginService) {
            this.registerPlugin((PluginService)plugin);
        }
        if (plugin instanceof PluginRootDocument) {
            this.serviceDocModifiers.add((PluginRootDocument)plugin);
        }
        if (plugin instanceof PluginModel) {
            this.modelModifiers.add((PluginModel)plugin);
        }
        if (plugin instanceof PluginResultFormat) {
            this.registerPlugin((PluginResultFormat)plugin);
        }
        if (plugin instanceof LiquibaseUser) {
            this.settings.addLiquibaseUser((LiquibaseUser)((Object)plugin));
        }
        this.plugins.put(plugin.getClass(), plugin);
    }

    private void registerPlugin(PluginResultFormat plugin) {
        Collection<Version> pluginVersions = plugin.getVersions();
        for (String format : plugin.getFormatNames()) {
            for (Version version : pluginVersions) {
                if (!this.versions.containsKey(version.urlPart)) continue;
                this.resultFormatters.computeIfAbsent(version, v2 -> new TreeMap()).put(format.toLowerCase(), plugin);
            }
        }
    }

    private void registerPlugin(PluginService plugin) {
        Collection<Version> pluginVersions = plugin.getVersions();
        if (plugin.definesVersions()) {
            for (Version version : pluginVersions) {
                this.versions.put(version.urlPart, version);
            }
        }
        for (String path : plugin.getVersionedUrlPaths()) {
            for (Version version : pluginVersions) {
                if (!this.versions.containsKey(version.urlPart)) continue;
                this.pathHandlers.computeIfAbsent(version, v2 -> new TreeMap()).put(path, plugin);
            }
            for (String type : plugin.getRequestTypes()) {
                for (Version version : pluginVersions) {
                    if (!this.versions.containsKey(version.urlPart)) continue;
                    this.requestTypeHandlers.computeIfAbsent(version, t2 -> new TreeMap()).put(type, plugin);
                }
            }
        }
    }

    public <P extends Plugin> P getPlugin(Class<P> plugin) {
        return (P)((Plugin)this.plugins.get(plugin));
    }

    public List<PluginModel> getModelPlugins() {
        return this.modelModifiers;
    }

    public void modifyServiceDocument(ServiceRequest request, Map<String, Object> result) {
        for (PluginRootDocument plugin : this.serviceDocModifiers) {
            plugin.modifyServiceDocument(request, result);
        }
    }

    public PluginService getServiceForRequestType(Version version, String requestType) {
        Map<String, PluginService> types = this.requestTypeHandlers.get(version);
        if (types == null) {
            return null;
        }
        return types.get(requestType);
    }

    public PluginService getServiceForPath(Version version, String path) {
        Map<String, PluginService> paths = this.pathHandlers.get(version);
        if (paths == null) {
            return null;
        }
        PluginService service = paths.get(path);
        if (service == null) {
            return paths.get(PATH_WILDCARD);
        }
        return service;
    }

    public ResultFormatter getFormatter(Version version, String formatName) {
        Map<String, PluginResultFormat> formatters = this.resultFormatters.get(version);
        if (formatters == null) {
            return null;
        }
        PluginResultFormat plugin = formatters.get(formatName.toLowerCase());
        if (plugin == null) {
            return null;
        }
        return plugin.getResultFormatter(formatName);
    }

    public Version getVersion(String versionString) {
        return this.versions.get(versionString);
    }

    public Map<String, Version> getVersions() {
        return this.versions;
    }
}

