/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.NavigableElement;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotatable;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeEntity;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class NavigationPropertyMain<P extends NavigableElement>
implements Annotatable,
NavigationProperty<P> {
    private final String name;
    private PropertyType type;
    private EntityType entityType;
    private final boolean entitySet;
    private final Collection<String> aliases;
    private NavigationPropertyMain<?> inverse;
    private final List<Annotation> annotations = new ArrayList<Annotation>();

    private NavigationPropertyMain(String propertyName, boolean isSet) {
        this.name = propertyName;
        this.aliases = new ArrayList<String>();
        this.aliases.add(propertyName);
        this.entitySet = isSet;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
        this.type = this.entitySet ? new TypeEntitySet(entityType) : new TypeEntity(entityType);
    }

    public NavigationPropertyMain getInverse() {
        return this.inverse;
    }

    public final void setInverse(NavigationPropertyMain inverse) {
        this.inverse = inverse;
    }

    public final void setInverses(NavigationPropertyMain inverse) {
        this.inverse = inverse;
        inverse.setInverse(this);
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public boolean validFor(EntityType entityType) {
        return entityType.getProperty(this.name) instanceof NavigationProperty;
    }

    @Override
    public boolean isEntitySet() {
        return this.entitySet;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getJsonName() {
        return this.getName();
    }

    @Override
    public PropertyType getType() {
        return this.type;
    }

    @Override
    public P getFrom(Entity entity) {
        return (P)((NavigableElement)entity.getProperty(this));
    }

    @Override
    public void setOn(Entity entity, P value) {
        entity.setProperty(this, value);
    }

    @Override
    public boolean isSetOn(Entity entity) {
        return entity.isSetProperty(this);
    }

    @Override
    public String getNavigationLink(Entity parent) {
        String selfLink = parent.getSelfLink();
        if (selfLink == null) {
            return null;
        }
        Object link = selfLink + "/" + this.name;
        Query query = parent.getQuery();
        if (query != null && !query.getSettings().useAbsoluteNavigationLinks()) {
            ResourcePath path = query.getPath();
            String curPath = path.getServiceRootUrl() + "/" + path.getVersion().urlPart + path.getPath();
            link = UrlHelper.getRelativePath((String)link, curPath);
        }
        return link;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public NavigationPropertyMain<P> addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public NavigationPropertyMain<P> addAnnotations(List<Annotation> annotationsToAdd) {
        this.annotations.addAll(annotationsToAdd);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NavigationPropertyMain other = (NavigationPropertyMain)obj;
        return Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public String toString() {
        return this.getName();
    }

    public static class NavigationPropertyEntitySet
    extends NavigationPropertyMain<EntitySet> {
        public NavigationPropertyEntitySet(String propertyName) {
            super(propertyName, true);
        }

        public NavigationPropertyEntitySet(String propertyName, NavigationPropertyMain inverse) {
            super(propertyName, true);
            this.setInverses(inverse);
        }
    }

    public static class NavigationPropertyEntity
    extends NavigationPropertyMain<Entity> {
        public NavigationPropertyEntity(String propertyName) {
            super(propertyName, false);
        }

        public NavigationPropertyEntity(String propertyName, NavigationPropertyMain inverse) {
            super(propertyName, false);
            this.setInverses(inverse);
        }
    }
}

