/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotatable;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class EntityPropertyMain<P>
implements Annotatable,
EntityProperty<P> {
    public final String name;
    private final PropertyType type;
    public final boolean hasCustomProperties;
    public final boolean serialiseNull;
    private final Collection<String> aliases;
    private final List<Annotation> annotations = new ArrayList<Annotation>();

    public EntityPropertyMain(String name, PropertyType type) {
        this(name, type, false, false, new String[0]);
    }

    public EntityPropertyMain(String name, PropertyType type, String ... aliases) {
        this(name, type, false, false, aliases);
    }

    public EntityPropertyMain(String name, PropertyType type, boolean hasCustomProperties, boolean serialiseNull, String ... aliases) {
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        this.type = type;
        this.aliases = new ArrayList<String>();
        this.aliases.add(name);
        this.name = StringHelper.deCapitalize(name);
        this.aliases.addAll(Arrays.asList(aliases));
        this.hasCustomProperties = hasCustomProperties;
        this.serialiseNull = serialiseNull;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getJsonName() {
        return this.name;
    }

    public Collection<String> getAliases() {
        return this.aliases;
    }

    @Override
    public PropertyType getType() {
        return this.type;
    }

    @Override
    public P getFrom(Entity entity) {
        return entity.getProperty(this);
    }

    @Override
    public boolean isSetOn(Entity entity) {
        return entity.isSetProperty(this);
    }

    @Override
    public void setOn(Entity entity, P value) {
        entity.setProperty(this, value);
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public EntityPropertyMain<P> addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public EntityPropertyMain<P> addAnnotations(List<Annotation> annotationsToAdd) {
        this.annotations.addAll(annotationsToAdd);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityPropertyMain other = (EntityPropertyMain)obj;
        return Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public String toString() {
        return this.getName();
    }
}

