/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper;

import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.fieldmapper.FieldMapper;
import org.jooq.Binding;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FieldMapperAbstract
implements FieldMapper,
AnnotatedConfigurable<Void, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldMapperAbstract.class.getName());

    protected FieldMapperAbstract() {
    }

    public static int getOrRegisterField(String fieldName, Table dbTable, StaTable staTable) {
        return FieldMapperAbstract.getOrRegisterField(fieldName, dbTable, staTable, null);
    }

    public static int getOrRegisterField(String fieldName, Table dbTable, StaTable staTable, Binding binding) {
        int idx = staTable.indexOf(fieldName);
        if (idx >= 0) {
            return idx;
        }
        Field<?> dbField = dbTable.field(fieldName);
        if (dbField == null) {
            LOGGER.error("Could not find field {} on table {}.", (Object)fieldName, (Object)dbTable.getName());
            throw new IllegalArgumentException("Could not find field " + fieldName + " on table " + dbTable.getName());
        }
        DataType dataType = dbField.getDataType();
        LOGGER.info("  Registering {} -> {}.{} ({})", staTable.getName(), dbTable.getName(), fieldName, dataType);
        return staTable.registerField(fieldName, dataType, binding);
    }
}

