/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom.GeoJsonDeserializier;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.GeoJsonSerializer;
import de.fraunhofer.iosb.ilt.frostserver.model.DefaultEntity;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeValue;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PostgresPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.JsonValue;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.TableCollection;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.Utils;
import de.fraunhofer.iosb.ilt.frostserver.util.ParserUtils;
import de.fraunhofer.iosb.ilt.frostserver.util.SimpleJsonMapper;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.NoSuchEntityException;
import java.io.IOException;
import java.util.Map;
import net.time4j.Moment;
import net.time4j.range.MomentInterval;
import org.geojson.Crs;
import org.geojson.Feature;
import org.geojson.GeoJsonObject;
import org.geojson.jackson.CrsType;
import org.geolatte.common.dataformats.json.jackson.JsonException;
import org.geolatte.geom.Geometry;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityFactories {
    public static final String CAN_NOT_BE_NULL = " can not be null.";
    public static final String CHANGED_MULTIPLE_ROWS = "Update changed multiple rows.";
    public static final String NO_ID_OR_NOT_FOUND = " with no id or non existing.";
    public static final String CREATED_HL = "Created historicalLocation {}";
    public static final String LINKED_L_TO_HL = "Linked location {} to historicalLocation {}.";
    public static final String UNLINKED_L_FROM_T = "Unlinked {} locations from Thing {}.";
    public static final String LINKED_L_TO_T = "Linked Location {} to Thing {}.";
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityFactories.class);
    private static final Field NULL_FIELD = DSL.field("null", Object.class);
    private static ObjectMapper formatter;
    private final ModelRegistry modelRegistry;
    private final TableCollection tableCollection;

    public EntityFactories(ModelRegistry modelRegistry, TableCollection tableCollection) {
        this.modelRegistry = modelRegistry;
        this.tableCollection = tableCollection;
    }

    public ModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    public TableCollection getTableCollection() {
        return this.tableCollection;
    }

    public static Entity entityFromId(EntityType entityType, Record tuple, Field<?> path) {
        return EntityFactories.entityFromId(entityType, Utils.getFieldOrNull(tuple, path));
    }

    public static Entity entityFromId(EntityType entityType, Object id2) {
        if (id2 == null) {
            return null;
        }
        return new DefaultEntity(entityType, ParserUtils.idFromObject(id2));
    }

    public void insertUserDefinedId(PostgresPersistenceManager pm2, Map<Field, Object> clause, Field<?> idField, Entity entity) throws IncompleteEntityException {
        if (pm2.useClientSuppliedId(entity)) {
            pm2.modifyClientSuppliedId(entity);
            clause.put(idField, entity.getId().getValue());
        }
    }

    public void entityExistsOrCreate(PostgresPersistenceManager pm2, Entity e2) throws NoSuchEntityException, IncompleteEntityException {
        if (e2 == null) {
            throw new NoSuchEntityException("No entity!");
        }
        if (e2.getId() == null) {
            e2.complete();
            pm2.insert(e2);
            return;
        }
        if (this.entityExists(pm2, e2)) {
            return;
        }
        try {
            e2.complete();
        }
        catch (IncompleteEntityException exc) {
            throw new NoSuchEntityException("No such entity '" + e2.getEntityType() + "' with id " + e2.getId().getValue());
        }
        pm2.insert(e2);
    }

    public boolean entityExists(PostgresPersistenceManager pm2, EntityType type, Id entityId) {
        Object id2 = entityId.getValue();
        StaMainTable<?> table = this.tableCollection.getTableForType(type);
        DSLContext dslContext = pm2.getDslContext();
        Integer count = (Integer)((Record1)dslContext.selectCount().from((TableLike<?>)table).where(table.getId().equal(id2)).fetchOne()).component1();
        if (count > 1) {
            LOGGER.error("More than one instance of {} with id {}.", (Object)type, id2);
        }
        return count > 0;
    }

    public boolean entityExists(PostgresPersistenceManager pm2, Entity e2) {
        if (e2 == null || e2.getId() == null) {
            return false;
        }
        return this.entityExists(pm2, e2.getEntityType(), e2.getId());
    }

    public static void insertTimeValue(Map<Field, Object> clause, Field<Moment> startField, Field<Moment> endField, TimeValue time) {
        if (time.isInstant()) {
            TimeInstant timeInstant = time.getInstant();
            EntityFactories.insertTimeInstant(clause, endField, timeInstant);
            EntityFactories.insertTimeInstant(clause, startField, timeInstant);
        } else if (time.isInterval()) {
            TimeInterval timeInterval = time.getInterval();
            EntityFactories.insertTimeInterval(clause, startField, endField, timeInterval);
        }
    }

    public static void insertTimeInstant(Map<Field, Object> clause, Field<Moment> field, TimeInstant time) {
        if (time == null) {
            return;
        }
        clause.put(field, time.getDateTime());
    }

    public static void insertTimeInterval(Map<Field, Object> clause, Field<Moment> startField, Field<Moment> endField, TimeInterval time) {
        if (time == null) {
            return;
        }
        MomentInterval interval = time.getInterval();
        clause.put(startField, interval.getStartAsMoment());
        clause.put(endField, interval.getEndAsMoment());
    }

    public static void insertGeometry(Map<Field, Object> clause, Field<String> locationPath, Field<? extends Object> geomPath, String encodingType, Object location) {
        if (encodingType == null && location instanceof GeoJsonObject) {
            encodingType = "application/geo+json";
        }
        if (encodingType != null && GeoJsonDeserializier.ENCODINGS.contains(encodingType.toLowerCase())) {
            EntityFactories.insertGeometryKnownEncoding(location, clause, geomPath, locationPath);
        } else {
            String json = EntityFactories.objectToJson(location);
            clause.put(geomPath, NULL_FIELD);
            if (locationPath != null) {
                clause.put(locationPath, json);
            }
        }
    }

    private static void insertGeometryKnownEncoding(Object location, Map<Field, Object> clause, Field<? extends Object> geomPath, Field<String> locationPath) {
        String geoJson;
        GeoJsonObject geoJsonObject;
        Crs crs;
        String locJson;
        try {
            locJson = new GeoJsonSerializer().serialize(location);
        }
        catch (JsonProcessingException ex2) {
            LOGGER.error("Failed to store.", ex2);
            throw new IllegalArgumentException("encoding specifies geoJson, but location not parsable as such.");
        }
        Object geoLocation = location;
        if (location instanceof Feature) {
            geoLocation = ((Feature)location).getGeometry();
        }
        if (geoLocation instanceof GeoJsonObject && (crs = (geoJsonObject = (GeoJsonObject)geoLocation).getCrs()) == null) {
            crs = new Crs();
            crs.setType(CrsType.name);
            crs.getProperties().put("name", "EPSG:4326");
            geoJsonObject.setCrs(crs);
        }
        try {
            geoJson = new GeoJsonSerializer().serialize(geoLocation);
        }
        catch (JsonProcessingException ex3) {
            LOGGER.error("Failed to store.", ex3);
            throw new IllegalArgumentException("encoding specifies geoJson, but location not parsable as such.");
        }
        try {
            Utils.getGeoJsonMapper().fromJson(geoJson, Geometry.class);
        }
        catch (JsonException ex4) {
            throw new IllegalArgumentException("Invalid geoJson: " + ex4.getMessage());
        }
        String template = "ST_Force2D(ST_Transform(ST_GeomFromGeoJSON({0}), 4326))";
        clause.put(geomPath, DSL.field("ST_Force2D(ST_Transform(ST_GeomFromGeoJSON({0}), 4326))", Object.class, geoJson));
        if (locationPath != null) {
            clause.put(locationPath, locJson);
        }
    }

    public static Object reParseGeometry(String encodingType, Object object) {
        String json = EntityFactories.objectToJson(object);
        return Utils.locationFromEncoding(encodingType, json);
    }

    public static String objectToJson(JsonValue jsonValue) {
        return EntityFactories.objectToJson(jsonValue.getValue());
    }

    public static String objectToJson(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return EntityFactories.getFormatter().writeValueAsString(object);
        }
        catch (IOException ex2) {
            throw new IllegalStateException("Could not serialise object.", ex2);
        }
    }

    public static ObjectMapper getFormatter() {
        if (formatter == null) {
            formatter = SimpleJsonMapper.getSimpleObjectMapper();
        }
        return formatter;
    }
}

