/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySetImpl;
import de.fraunhofer.iosb.ilt.frostserver.model.core.NavigableElement;
import de.fraunhofer.iosb.ilt.frostserver.path.CustomLinksHelper;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementArrayIndex;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementCustomProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntityType;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePathVisitor;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PostgresPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.QueryBuilder;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.DataSize;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.QueryState;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyCustom;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.Metadata;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.PersistenceSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.ParserUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Cursor;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.conf.ParamType;
import org.jooq.exception.DataAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultBuilder
implements ResourcePathVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultBuilder.class);
    private final PostgresPersistenceManager pm;
    private final PersistenceSettings persistenceSettings;
    private final ResourcePath path;
    private final Query staQuery;
    private final QueryBuilder sqlQueryBuilder;
    private final ResultQuery<Record> sqlQuery;
    private final CustomLinksHelper customLinksHelper;
    private final DataSize dataSize;
    private final int estimateTreshold;
    private final PersistenceSettings.CountMode countMode;
    private Object resultObject;
    private String entityName;

    public ResultBuilder(PostgresPersistenceManager pm2, ResourcePath path, Query query, QueryBuilder sqlQueryBuilder, DataSize dataSize) {
        this.pm = pm2;
        this.path = path;
        this.staQuery = query;
        this.sqlQueryBuilder = sqlQueryBuilder;
        this.sqlQuery = sqlQueryBuilder.buildSelect();
        this.dataSize = dataSize;
        CoreSettings coreSettings = pm2.getCoreSettings();
        this.persistenceSettings = coreSettings.getPersistenceSettings();
        this.customLinksHelper = coreSettings.getCustomLinksHelper();
        this.countMode = this.persistenceSettings.getCountMode();
        this.estimateTreshold = this.persistenceSettings.getEstimateCountThreshold();
    }

    public Object getEntity() {
        return this.resultObject;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Query getStaQuery() {
        return this.staQuery;
    }

    public ResourcePath getPath() {
        return this.path;
    }

    public DataSize getDataSize() {
        return this.dataSize;
    }

    @Override
    public void visit(PathElementEntity element) {
        Result<Record> results = this.sqlQuery.fetch();
        if (results.size() > 1) {
            throw new IllegalStateException("Expecting an element, yet more than 1 result. Got " + results.size() + " results.");
        }
        if (results.isEmpty()) {
            return;
        }
        QueryState<?> queryState = this.sqlQueryBuilder.getQueryState();
        Entity entity = queryState.entityFromQuery((Record)results.get(0), new DataSize(this.pm.getCoreSettings().getDataSizeMax()));
        if (entity == null) {
            throw new IllegalStateException("Failed to create an entity from result set.");
        }
        entity.setQuery(this.staQuery);
        this.expandEntity(entity, this.staQuery);
        this.resultObject = entity;
    }

    public void expandEntity(Entity entity, Query query) {
        if (query == null) {
            return;
        }
        if (query.getMetadata() == Metadata.FULL) {
            this.customLinksHelper.expandCustomLinks(query, entity, this.path);
        }
        for (Expand expand : query.getExpand()) {
            this.addExpandToEntity(entity, expand);
        }
    }

    private void addExpandToEntity(Entity entity, Expand expand) {
        NavigationProperty firstNp = expand.getPath();
        NavigableElement existing = null;
        Object o2 = entity.getProperty(firstNp);
        if (o2 instanceof NavigableElement) {
            existing = (NavigableElement)o2;
        } else if (firstNp instanceof NavigationPropertyCustom) {
            NavigationPropertyCustom firstNpCust = (NavigationPropertyCustom)firstNp;
            Object id2 = firstNpCust.getTargetIdFrom(entity);
            if (id2 == null) {
                return;
            }
            existing = this.loadEntity(firstNp.getEntityType(), id2, expand);
            if (existing == null) {
                return;
            }
            firstNpCust.setElementOn(entity, existing);
        }
        Query subQuery = expand.getSubQuery();
        if (existing == null || existing.isEmpty()) {
            this.createExpandedElement(entity, firstNp, subQuery);
        } else if (existing instanceof EntitySet) {
            this.expandEntitySet((EntitySet)existing, subQuery);
        } else if (existing instanceof Entity) {
            this.expandEntity((Entity)existing, subQuery);
        }
    }

    private Entity loadEntity(EntityType type, Object id2, Expand expand) {
        try {
            return this.pm.get(type, ParserUtils.idFromObject(id2), expand.getSubQuery());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private void createExpandedElement(Entity entity, NavigationProperty firstNp, Query subQuery) {
        PathElementEntityType childPe;
        PathElementEntitySet parentCollection = new PathElementEntitySet(entity.getEntityType());
        PathElementEntity parent = new PathElementEntity(entity.getId(), entity.getEntityType(), parentCollection);
        ResourcePath ePath = new ResourcePath(this.path.getServiceRootUrl(), this.path.getVersion(), null);
        ePath.addPathElement(parentCollection, false, false);
        ePath.addPathElement(parent, false, true);
        if (firstNp.isEntitySet()) {
            childPe = new PathElementEntitySet((NavigationPropertyMain.NavigationPropertyEntitySet)firstNp, parent);
            ePath.addPathElement(childPe, true, false);
        } else {
            childPe = firstNp instanceof NavigationPropertyMain.NavigationPropertyEntity ? new PathElementEntity((NavigationPropertyMain.NavigationPropertyEntity)firstNp, (PathElement)parent) : new PathElementEntity(firstNp.getEntityType(), (PathElement)parent);
            ePath.addPathElement(childPe, true, false);
        }
        Object child = this.pm.get(ePath, subQuery);
        entity.setProperty(firstNp, child);
    }

    private void expandEntitySet(EntitySet entitySet, Query subQuery) {
        for (Entity subEntity : entitySet) {
            this.expandEntity(subEntity, subQuery);
        }
    }

    private <R extends Record> Cursor<R> timeQuery(ResultQuery<R> query) {
        Cursor<R> result;
        if (this.persistenceSettings.isTimeoutQueries()) {
            query.queryTimeout(this.persistenceSettings.getQueryTimeout());
        }
        if (!this.persistenceSettings.isLogSlowQueries()) {
            return query.fetchLazy();
        }
        long start = System.currentTimeMillis();
        try {
            result = query.fetchLazy();
        }
        catch (DataAccessException exc) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.info("Failed to run query:\n{}", (Object)query.getSQL(ParamType.INLINED));
            }
            throw new IllegalStateException("Failed to run query: " + exc.getMessage());
        }
        long end = System.currentTimeMillis();
        long duration = end - start;
        if (LOGGER.isInfoEnabled() && duration > (long)this.persistenceSettings.getSlowQueryThreshold()) {
            LOGGER.info("Slow Query executed in {} ms:\n{}", (Object)duration, (Object)query.getSQL(ParamType.INLINED));
        }
        return result;
    }

    private int timeCountQueryRecord(ResultQuery<Record> query) {
        try (Cursor<Record> countCursor = this.timeQuery(query);){
            int n2 = countCursor.fetchNext().get(0, Integer.class);
            return n2;
        }
    }

    private int timeCountQuery(ResultQuery<Record1<Integer>> query) {
        try (Cursor<Record1<Integer>> countCursor = this.timeQuery(query);){
            int n2 = countCursor.fetchNext().component1();
            return n2;
        }
    }

    @Override
    public void visit(PathElementEntitySet element) {
        EntitySet entitySet;
        if (this.staQuery.getTopOrDefault() > 0) {
            Cursor<Record> results = this.timeQuery(this.sqlQuery);
            entitySet = this.sqlQueryBuilder.getQueryState().createSetFromRecords(results, this);
        } else {
            entitySet = new EntitySetImpl(this.sqlQueryBuilder.getQueryState().getMainTable().getEntityType());
        }
        if (entitySet == null) {
            throw new IllegalStateException("Empty set!");
        }
        this.fetchAndAddCount(entitySet);
        this.resultObject = entitySet;
    }

    private void fetchAndAddCount(EntitySet entitySet) {
        if (LOGGER.isTraceEnabled()) {
            int estimate = this.timeCountQuery(this.sqlQueryBuilder.buildEstimateCountExplain());
            int sample = this.timeCountQueryRecord(this.sqlQueryBuilder.buildEstimateCountSample().countQuery) * 100;
            int limit = this.timeCountQuery(this.sqlQueryBuilder.buildCount(this.estimateTreshold));
            int full = this.timeCountQuery(this.sqlQueryBuilder.buildCount());
            LOGGER.trace("Estimate: {}, Sample: {}, Limit: {}, Full: {}", estimate, sample, limit, full);
        }
        if (this.staQuery.isCountOrDefault()) {
            switch (this.countMode) {
                case FULL: {
                    entitySet.setCount(this.timeCountQuery(this.sqlQueryBuilder.buildCount()));
                    return;
                }
                case LIMIT_ESTIMATE: {
                    this.countLimitEstimate(entitySet);
                    return;
                }
                case ESTIMATE_LIMIT: {
                    this.countEstimateLimit(entitySet);
                    return;
                }
                case LIMIT_SAMPLE: {
                    this.countLimitSample(entitySet);
                    return;
                }
                case SAMPLE_LIMIT: {
                    this.countSampleLimit(entitySet);
                    return;
                }
            }
            throw new AssertionError((Object)this.countMode.name());
        }
    }

    public void countSampleLimit(EntitySet entitySet) {
        QueryBuilder.CountSampleResult csr = this.sqlQueryBuilder.buildEstimateCountSample();
        int estimate = (int)((double)this.timeCountQueryRecord(csr.countQuery) * Math.pow(100.0, csr.sampledTables));
        if (estimate < this.estimateTreshold) {
            int count = this.timeCountQuery(this.sqlQueryBuilder.buildCount());
            entitySet.setCount(count);
            LOGGER.debug("Estimate: {}, Count: {}", (Object)estimate, (Object)count);
        } else {
            entitySet.setCount(estimate);
        }
    }

    public void countLimitSample(EntitySet entitySet) {
        int count = this.timeCountQuery(this.sqlQueryBuilder.buildCount(this.estimateTreshold));
        if (count < this.estimateTreshold) {
            entitySet.setCount(count);
        } else {
            QueryBuilder.CountSampleResult csr = this.sqlQueryBuilder.buildEstimateCountSample();
            int estimate = (int)((double)this.timeCountQueryRecord(csr.countQuery) * Math.pow(100.0, csr.sampledTables));
            entitySet.setCount(Math.max(count, estimate));
            LOGGER.debug("Estimate: {}, Count: {}", (Object)estimate, (Object)count);
        }
    }

    public void countEstimateLimit(EntitySet entitySet) {
        int estimate = this.timeCountQuery(this.sqlQueryBuilder.buildEstimateCountExplain());
        if (estimate < this.estimateTreshold) {
            int count = this.timeCountQuery(this.sqlQueryBuilder.buildCount(this.estimateTreshold));
            entitySet.setCount(count);
            LOGGER.debug("Estimate: {}, Count: {}", (Object)estimate, (Object)count);
        } else {
            entitySet.setCount(estimate);
        }
    }

    public void countLimitEstimate(EntitySet entitySet) {
        int count = this.timeCountQuery(this.sqlQueryBuilder.buildCount(this.estimateTreshold));
        if (count < this.estimateTreshold) {
            entitySet.setCount(count);
        } else {
            int estimate = this.timeCountQuery(this.sqlQueryBuilder.buildEstimateCountExplain());
            entitySet.setCount(Math.max(count, estimate));
            LOGGER.debug("Estimate: {}, Count: {}", (Object)estimate, (Object)count);
        }
    }

    @Override
    public void visit(PathElementProperty element) {
        element.getParent().visit(this);
        if (Entity.class.isAssignableFrom(this.resultObject.getClass())) {
            Object propertyValue = ((Entity)this.resultObject).getProperty(element.getProperty());
            HashMap entityMap = new HashMap();
            this.entityName = element.getProperty().name;
            entityMap.put(this.entityName, propertyValue);
            this.resultObject = entityMap;
        }
    }

    @Override
    public void visit(PathElementCustomProperty element) {
        Map map;
        Object inner;
        element.getParent().visit(this);
        String name = element.getName();
        if (this.resultObject instanceof Map && (inner = (map = (Map)this.resultObject).get(this.entityName)) instanceof Map && (map = (Map)inner).containsKey(name)) {
            Object propertyValue = map.get(name);
            HashMap entityMap = new HashMap();
            this.entityName = name;
            entityMap.put(this.entityName, propertyValue);
            this.resultObject = entityMap;
            return;
        }
        this.resultObject = null;
        this.entityName = null;
    }

    @Override
    public void visit(PathElementArrayIndex element) {
        element.getParent().visit(this);
        int index = element.getIndex();
        if (this.resultObject instanceof Map) {
            Map map = (Map)this.resultObject;
            Object inner = map.get(this.entityName);
            JsonNode propertyValue = null;
            if (inner instanceof ArrayNode && ((ArrayNode)inner).size() > index) {
                propertyValue = ((ArrayNode)inner).get(index);
            }
            if (inner instanceof List && ((List)inner).size() > index) {
                propertyValue = ((List)inner).get(index);
            }
            if (propertyValue != null) {
                HashMap<String, JsonNode> entityMap = new HashMap<String, JsonNode>();
                this.entityName = this.entityName + "[" + Integer.toString(index) + "]";
                entityMap.put(this.entityName, propertyValue);
                this.resultObject = entityMap;
                return;
            }
        }
        this.resultObject = null;
        this.entityName = null;
    }
}

