/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.path;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.query.Metadata;
import de.fraunhofer.iosb.ilt.frostserver.query.OrderBy;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Expression;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Path;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.Constant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.ConstantFactory;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.comparison.ComparisonFunction;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.comparison.Equal;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.comparison.GreaterThan;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.comparison.LessThan;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.logical.And;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.logical.Or;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.net.URLDecoder;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlHelper.class.getName());

    private UrlHelper() {
    }

    public static String generateNextLink(ResourcePath path, Query query) {
        return UrlHelper.generateNextLink(path, query, query.getTopOrDefault());
    }

    public static String generateNextLink(ResourcePath path, Query query, int resultCount) {
        if (query == null || query.getMetadata() == Metadata.OFF) {
            return null;
        }
        int oldSkip = query.getSkip(0);
        int newSkip = oldSkip + resultCount;
        query.setSkip(newSkip);
        String nextLink = path.toString() + "?" + query.toString(false);
        query.setSkip(oldSkip);
        return nextLink;
    }

    public static String generateNextLink(ResourcePath path, Query query, int resultCount, Entity last, Entity next) {
        String standardNextLink = UrlHelper.generateNextLink(path, query, resultCount);
        if (!query.isPkOrder()) {
            return standardNextLink;
        }
        SkipFilterGenerator sfg = new SkipFilterGenerator(last, next);
        for (OrderBy orderby : query.getOrderBy()) {
            if (sfg.addOrderBy(orderby)) break;
        }
        if (sfg.isFailed()) {
            return standardNextLink;
        }
        String skipFilter = sfg.getSkipFilter().toUrl();
        return standardNextLink + "&$skipFilter=" + StringHelper.urlEncode(skipFilter);
    }

    public static String generateSelfLink(Query query, String serviceRootUrl, Version version, EntityType entityType, Object id2) {
        if (query != null && query.getMetadata() != Metadata.FULL) {
            return null;
        }
        return serviceRootUrl + '/' + version.urlPart + '/' + entityType.plural + '(' + UrlHelper.quoteForUrl(id2) + ')';
    }

    public static String generateSelfLink(Query query, String serviceRootUrl, Version version, EntityType entityType, Id id2) {
        if (query != null && query.getMetadata() != Metadata.FULL) {
            return null;
        }
        return serviceRootUrl + '/' + version.urlPart + '/' + entityType.plural + '(' + id2.getUrl() + ')';
    }

    public static String generateSelfLink(Query query, String serviceRootUrl, Version version, Entity entity) {
        return UrlHelper.generateSelfLink(query, serviceRootUrl, version, entity.getEntityType(), entity.getId());
    }

    public static String generateSelfLink(Query query, ResourcePath path, Entity entity) {
        return UrlHelper.generateSelfLink(query, path.getServiceRootUrl(), path.getVersion(), entity.getEntityType(), entity.getId());
    }

    public static String generateNavLink(Query query, ResourcePath path, Entity parent, Entity entity, boolean absolute) {
        if (query != null && query.getMetadata() != Metadata.FULL) {
            return null;
        }
        Object result = UrlHelper.generateSelfLink(query, path, parent) + "/" + entity.getEntityType().entityName;
        if (!absolute) {
            String curPath = path.getServiceRootUrl() + path.getPath();
            result = UrlHelper.getRelativePath((String)result, curPath);
        }
        return result;
    }

    public static String generateNavLink(Query query, ResourcePath path, Entity parent, EntitySet es2, boolean absolute) {
        if (query != null && query.getMetadata() != Metadata.FULL) {
            return null;
        }
        Object result = UrlHelper.generateSelfLink(query, path, parent) + "/" + es2.getEntityType().plural;
        if (!absolute) {
            String curPath = path.getServiceRootUrl() + path.getPath();
            result = UrlHelper.getRelativePath((String)result, curPath);
        }
        return result;
    }

    public static String getRelativePath(String targetPath, String basePath) {
        String pathSeparator = "/";
        boolean targetIsDir = targetPath.endsWith("/");
        boolean baseIsDir = basePath.endsWith("/");
        String[] base = basePath.split(Pattern.quote("/"), -1);
        String[] target = targetPath.split(Pattern.quote("/"), 0);
        StringBuilder common = new StringBuilder();
        int commonIndex = 0;
        int baseLength = baseIsDir ? base.length : base.length - 1;
        for (int i2 = 0; i2 < target.length && i2 < baseLength && target[i2].equals(base[i2]); ++i2) {
            common.append(target[i2]).append("/");
            ++commonIndex;
        }
        if (commonIndex == 0) {
            return targetPath;
        }
        StringBuilder relative = new StringBuilder();
        if (base.length == commonIndex) {
            relative = new StringBuilder("./");
        } else {
            int numDirsUp = base.length - commonIndex - (targetIsDir ? 0 : 1);
            for (int i3 = 1; i3 <= numDirsUp; ++i3) {
                relative.append("..").append("/");
            }
        }
        if (targetPath.length() > common.length()) {
            relative.append(targetPath.substring(common.length()));
        }
        return relative.toString();
    }

    public static String quoteForUrl(Object in2) {
        if (in2 == null) {
            return "'null'";
        }
        if (in2 instanceof Number) {
            return in2.toString();
        }
        return "'" + StringHelper.escapeForStringConstant(in2.toString()) + "'";
    }

    public static Map<String, List<String>> splitQuery(String queryString) {
        if (StringHelper.isNullOrEmpty(queryString)) {
            return new LinkedHashMap<String, List<String>>();
        }
        return Arrays.stream(queryString.split("&")).map(UrlHelper::splitQueryParameter).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private static AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String it2) {
        int idx = it2.indexOf(61);
        String key = idx > 0 ? it2.substring(0, idx) : it2;
        String value = idx > 0 && it2.length() > idx + 1 ? it2.substring(idx + 1) : null;
        return new AbstractMap.SimpleImmutableEntry<String, Object>(key == null ? null : URLDecoder.decode(key, StringHelper.UTF8), (value == null ? null : URLDecoder.decode(value, StringHelper.UTF8)));
    }

    public static Map<String, String> decodePrefer(String input, Map<String, String> output) {
        String[] parts;
        if (output == null) {
            output = new HashMap<String, String>();
        }
        if (input == null || input.isEmpty()) {
            return output;
        }
        block4: for (String part : parts = StringUtils.split(input, ',')) {
            if (part == null) continue;
            String[] subParts = StringUtils.split(part, "=", 2);
            switch (subParts.length) {
                case 2: {
                    output.put(subParts[0].trim(), subParts[1].trim());
                    continue block4;
                }
                case 1: {
                    output.put(subParts[0].trim(), "");
                    continue block4;
                }
            }
        }
        return output;
    }

    private static class SkipFilterGenerator {
        final Entity last;
        final Entity next;
        private boolean done = false;
        private boolean failed = false;
        Expression skipFilter = null;
        And lastAnd = null;

        public SkipFilterGenerator(Entity last, Entity next) {
            this.last = last;
            this.next = next;
        }

        public boolean isFailed() {
            return this.failed || this.skipFilter == null;
        }

        private boolean setFailed() {
            this.failed = true;
            return this.setDone();
        }

        public boolean isDone() {
            return this.done;
        }

        private boolean setDone() {
            this.done = true;
            return this.done;
        }

        public Expression getSkipFilter() {
            return this.skipFilter;
        }

        public boolean addOrderBy(OrderBy orderby) {
            if (this.done) {
                return this.done;
            }
            Expression orderExpression = orderby.getExpression();
            if (!(orderExpression instanceof Path)) {
                return this.setFailed();
            }
            Path obPath = (Path)orderExpression;
            Object lastValue = this.last.getProperty(obPath);
            Object nextValue = this.next.getProperty(obPath);
            if (lastValue == null || nextValue == null) {
                LOGGER.debug("Order expression value is null, using normal nextLink: {}", (Object)orderExpression.toUrl());
                return this.setFailed();
            }
            Constant valueConstant = ConstantFactory.of(lastValue);
            if (valueConstant == null) {
                LOGGER.debug("Order expression value can not be made a constant, using normal nextLink: {}", (Object)orderExpression.toUrl());
                return this.setFailed();
            }
            if (lastValue.equals(nextValue)) {
                return this.handleValueEqual(obPath, valueConstant, orderby);
            }
            return this.handleValueDifferent(orderby, obPath, valueConstant);
        }

        private boolean handleValueEqual(Path obPath, Constant valueConstant, OrderBy orderby) {
            And newAnd = new And(new Equal(obPath, valueConstant));
            Or newFilter = orderby.getType() == OrderBy.OrderType.DESCENDING ? new Or(new LessThan(obPath, valueConstant), newAnd) : new Or(new GreaterThan(obPath, valueConstant), newAnd);
            if (this.lastAnd == null) {
                this.skipFilter = newFilter;
            } else {
                this.lastAnd.addParameter(newFilter);
            }
            this.lastAnd = newAnd;
            return this.done;
        }

        private boolean handleValueDifferent(OrderBy orderby, Path obPath, Constant valueConstant) {
            ComparisonFunction newFilter = orderby.getType() == OrderBy.OrderType.DESCENDING ? new LessThan(obPath, valueConstant) : new GreaterThan(obPath, valueConstant);
            if (this.lastAnd == null) {
                this.skipFilter = newFilter;
            } else {
                this.lastAnd.addParameter(newFilter);
            }
            LOGGER.debug("Hit value border for order, done.");
            return this.setDone();
        }
    }
}

