/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.path;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementArrayIndex;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ResourcePath {
    private String serviceRootUrl;
    private Version version;
    private String path;
    private boolean ref;
    private boolean value;
    private boolean entityProperty;
    private final List<PathElement> pathElements = new ArrayList<PathElement>();
    private PathElement mainElement;
    private PathElementEntity identifiedElement;

    public ResourcePath() {
    }

    public ResourcePath(String serviceRootUrl, Version version, String pathUrl) {
        this.version = version;
        this.serviceRootUrl = serviceRootUrl;
        this.path = pathUrl;
    }

    public boolean isRef() {
        return this.ref;
    }

    public ResourcePath setRef(boolean ref) {
        this.ref = ref;
        return this;
    }

    public boolean isValue() {
        return this.value;
    }

    public ResourcePath setValue(boolean value) {
        this.value = value;
        return this;
    }

    public boolean isEntityProperty() {
        return this.entityProperty;
    }

    public int size() {
        return this.pathElements.size();
    }

    public boolean isEmpty() {
        return this.pathElements.isEmpty();
    }

    public PathElement get(int index) {
        return this.pathElements.get(index);
    }

    public PathElement getMainElement() {
        return this.mainElement;
    }

    public EntityType getMainElementType() {
        if (this.mainElement instanceof PathElementEntity) {
            PathElementEntity entityPathElement = (PathElementEntity)this.mainElement;
            return entityPathElement.getEntityType();
        }
        if (this.mainElement instanceof PathElementEntitySet) {
            PathElementEntitySet entitySetPathElement = (PathElementEntitySet)this.mainElement;
            return entitySetPathElement.getEntityType();
        }
        return null;
    }

    public PathElement getLastElement() {
        if (this.pathElements.isEmpty()) {
            return null;
        }
        return this.pathElements.get(this.pathElements.size() - 1);
    }

    public PathElementEntity getIdentifiedElement() {
        return this.identifiedElement;
    }

    public ResourcePath setMainElement(PathElement mainElementType) {
        this.mainElement = mainElementType;
        return this;
    }

    public ResourcePath setIdentifiedElement(PathElementEntity identifiedElement) {
        this.identifiedElement = identifiedElement;
        return this;
    }

    public ResourcePath addPathElement(int index, PathElement pe2) {
        this.pathElements.add(index, pe2);
        return this;
    }

    public ResourcePath addPathElement(PathElement pe2) {
        this.addPathElement(pe2, false, false);
        return this;
    }

    public ResourcePath addPathElement(PathElement pe2, boolean isMain, boolean isIdentifier) {
        this.pathElements.add(pe2);
        if (isMain && pe2 instanceof PathElementEntity || pe2 instanceof PathElementEntitySet) {
            this.setMainElement(pe2);
        }
        if (isIdentifier && pe2 instanceof PathElementEntity) {
            PathElementEntity epe = (PathElementEntity)pe2;
            this.setIdentifiedElement(epe);
        }
        this.entityProperty = pe2 instanceof PathElementProperty;
        return this;
    }

    public ResourcePath compress() {
        for (int i2 = this.pathElements.size() - 1; i2 > 0; --i2) {
            PathElementEntity epe;
            if (!(this.pathElements.get(i2) instanceof PathElementEntity) || !(this.pathElements.get(i2 - 1) instanceof PathElementEntitySet) || (epe = (PathElementEntity)this.pathElements.get(i2)).getId() == null) continue;
            this.pathElements.subList(0, i2 - 1).clear();
            this.setIdentifiedElement(epe);
            this.pathElements.get(0).setParent(null);
            return this;
        }
        return this;
    }

    public String getServiceRootUrl() {
        return this.serviceRootUrl;
    }

    public ResourcePath setServiceRootUrl(String serviceRootUrl) {
        this.serviceRootUrl = serviceRootUrl;
        return this;
    }

    public Version getVersion() {
        return this.version;
    }

    public ResourcePath setVersion(Version version) {
        this.version = version;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public ResourcePath setPath(String pathUrl) {
        this.path = pathUrl;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.serviceRootUrl, this.ref, this.value, this.pathElements, this.mainElement, this.identifiedElement);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourcePath other = (ResourcePath)obj;
        return Objects.equals(this.serviceRootUrl, other.serviceRootUrl) && this.version == other.version && this.ref == other.ref && this.value == other.value && Objects.equals(this.pathElements, other.pathElements) && Objects.equals(this.mainElement, other.mainElement) && Objects.equals(this.identifiedElement, other.identifiedElement);
    }

    public String getFullUrl() {
        StringBuilder sb = new StringBuilder(this.serviceRootUrl).append('/').append(this.version.urlPart);
        for (PathElement rpe : this.pathElements) {
            if (rpe instanceof PathElementEntity && ((PathElementEntity)rpe).getId() != null) {
                PathElementEntity epe = (PathElementEntity)rpe;
                sb.append("(").append(epe.getId().getUrl()).append(")");
                continue;
            }
            if (rpe instanceof PathElementArrayIndex) {
                sb.append(rpe.toString());
                continue;
            }
            sb.append("/");
            sb.append(rpe.toString());
        }
        if (this.isRef()) {
            sb.append("/$ref");
        } else if (this.isValue()) {
            sb.append("/$value");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getFullUrl();
    }
}

