/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.path;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.path.CustomLinksHelper;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyCustom;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyCustomLink;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;

public class ParserHelper {
    private final CustomLinksHelper customLinksHelper;

    public ParserHelper(ModelRegistry modelRegistry) {
        this.customLinksHelper = new CustomLinksHelper(modelRegistry, false, 0);
    }

    public Property parseProperty(EntityType type, String propertyName, Property previous) {
        String decodedName = StringHelper.urlDecode(propertyName);
        if (previous instanceof EntityPropertyMain || previous instanceof EntityPropertyCustom) {
            return this.parseCustomProperty(decodedName);
        }
        NavigationPropertyMain navProp = type.getNavigationProperty(decodedName);
        if (navProp != null) {
            return navProp;
        }
        EntityPropertyMain entityProp = type.getEntityProperty(decodedName);
        if (entityProp != null) {
            return entityProp;
        }
        throw new IllegalArgumentException("Could not place " + propertyName + " under type " + type + " after " + previous);
    }

    private Property parseCustomProperty(String decodedName) {
        EntityType typeForCustomLink = this.customLinksHelper.getTypeForCustomLinkName(decodedName);
        if (typeForCustomLink == null) {
            return new EntityPropertyCustom(decodedName);
        }
        return new EntityPropertyCustomLink(decodedName, typeForCustomLink);
    }
}

