/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.path;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CustomLinksHelper {
    private final Pattern entityLinkNamePattern;
    private final ModelRegistry modelRegistry;
    private final boolean enable;
    private final int recurseDepth;

    public CustomLinksHelper(ModelRegistry modelRegistry, boolean enable, int recurseDepth) {
        this.enable = enable;
        this.recurseDepth = recurseDepth;
        this.modelRegistry = modelRegistry;
        String entityTypeRegex = StringUtils.join((Iterable)modelRegistry.getEntityTypes().stream().map(type -> type.entityName).collect(Collectors.toList()), '|');
        this.entityLinkNamePattern = Pattern.compile("([a-zA-Z0-9._-]+)\\.(" + entityTypeRegex + ")@iot\\.id");
    }

    public EntityType getTypeForCustomLinkName(String name) {
        String[] split = StringUtils.split(name, '.');
        if (split.length == 1) {
            return null;
        }
        String last = split[split.length - 1];
        return this.modelRegistry.getEntityTypeForName(last);
    }

    public void expandCustomLinks(Query query, Entity entity, ResourcePath path) {
        if (this.enable) {
            for (EntityPropertyMain property : entity.getEntityType().getEntityProperties()) {
                if (!property.hasCustomProperties) continue;
                this.expandCustomLinks(query, property, entity, path, this.recurseDepth);
            }
        }
    }

    private void expandCustomLinks(Query query, EntityPropertyMain property, Entity entity, ResourcePath path, int recurseDepth) {
        Object properties = entity.getProperty(property);
        if (properties instanceof Map) {
            this.expandCustomLinks(query, (Map)properties, path, recurseDepth);
        }
    }

    public void expandCustomLinks(Query query, Map<String, Object> properties, ResourcePath path, int recurseDepth) {
        if (properties == null) {
            return;
        }
        LinkedHashMap<CallSite, String> toAdd = new LinkedHashMap<CallSite, String>();
        for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
            String key;
            Matcher matcher;
            Object value = propertyEntry.getValue();
            if (value instanceof Map) {
                Map subMap = (Map)value;
                if (recurseDepth <= 0) continue;
                this.expandCustomLinks(query, subMap, path, recurseDepth - 1);
                continue;
            }
            if (!(value instanceof Number) && !(value instanceof String) || !(matcher = this.entityLinkNamePattern.matcher(key = propertyEntry.getKey())).matches()) continue;
            String name = matcher.group(1);
            EntityType type = this.modelRegistry.getEntityTypeForName(matcher.group(2));
            Object id2 = propertyEntry.getValue();
            String navLinkName = name + "." + type.entityName + "@iot.navigationLink";
            toAdd.put((CallSite)((Object)navLinkName), UrlHelper.generateSelfLink(query, path.getServiceRootUrl(), path.getVersion(), type, id2));
        }
        properties.putAll(toAdd);
    }

    public void cleanPropertiesMap(Entity entity) {
        if (!this.enable) {
            return;
        }
        for (EntityPropertyMain property : entity.getEntityType().getEntityProperties()) {
            Object properties;
            if (!property.hasCustomProperties || !((properties = entity.getProperty(property)) instanceof Map)) continue;
            this.cleanPropertiesMap((Map)properties, this.recurseDepth);
        }
    }

    private void cleanPropertiesMap(Map<String, Object> properties, int recurseDepth) {
        if (properties == null) {
            return;
        }
        ArrayList<CallSite> toRemove = new ArrayList<CallSite>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key;
            Matcher matcher;
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map subMap = (Map)value;
                if (recurseDepth <= 0) continue;
                this.cleanPropertiesMap(subMap, recurseDepth - 1);
                continue;
            }
            if (!(value instanceof Number) && !(value instanceof String) || !(matcher = this.entityLinkNamePattern.matcher(key = entry.getKey())).matches()) continue;
            String name = matcher.group(1);
            EntityType type = this.modelRegistry.getEntityTypeForName(matcher.group(2));
            String itemName = name + "." + type.entityName;
            String navLinkName = itemName + "@iot.navigationLink";
            toRemove.add((CallSite)((Object)itemName));
            toRemove.add((CallSite)((Object)navLinkName));
        }
        for (String string : toRemove) {
            properties.remove(string);
        }
    }
}

