/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.mqtt;

import de.fraunhofer.iosb.ilt.frostserver.messagebus.MessageListener;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.MqttServer;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.MqttServerFactory;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.SubscriptionManager;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.create.EntityCreateEvent;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.create.EntityCreateListener;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.Subscription;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.SubscriptionEvent;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.SubscriptionFactory;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.SubscriptionListener;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManagerFactory;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.service.Service;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequestBuilder;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponseDefault;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.MqttSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.UnknownVersionException;
import de.fraunhofer.iosb.ilt.frostserver.util.ChangingStatusLogger;
import de.fraunhofer.iosb.ilt.frostserver.util.ProcessorHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttManager
implements SubscriptionListener,
MessageListener,
EntityCreateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttManager.class);
    private final Map<EntityType, SubscriptionManager> subscriptions = new HashMap<EntityType, SubscriptionManager>();
    private final CoreSettings settings;
    private final SubscriptionFactory subscriptionFactory;
    private MqttServer server;
    private BlockingQueue<EntityChangedMessage> entityChangedEventQueue;
    private ExecutorService entityChangedExecutorService;
    private BlockingQueue<EntityCreateEvent> entityCreateEventQueue;
    private ExecutorService entityCreateExecutorService;
    private final ChangingStatusLogger statusLogger = new ChangingStatusLogger(LOGGER);
    private final AtomicInteger topicCount = new AtomicInteger();
    private final AtomicInteger entityChangedQueueSize = new AtomicInteger();
    private final AtomicInteger entityCreateQueueSize = new AtomicInteger();
    private final LoggingStatus logStatus = new LoggingStatus();
    private boolean enabledMqtt = false;
    private boolean shutdown = false;

    public MqttManager(CoreSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("setting must be non-null");
        }
        this.settings = settings;
        this.subscriptionFactory = new SubscriptionFactory(settings);
        this.init();
    }

    private void init() {
        ModelRegistry modelRegistry = this.settings.getModelRegistry();
        for (EntityType entityType : modelRegistry.getEntityTypes()) {
            this.subscriptions.put(entityType, new SubscriptionManager(entityType, this, this.topicCount));
        }
        MqttSettings mqttSettings = this.settings.getMqttSettings();
        if (mqttSettings.isEnableMqtt()) {
            this.enabledMqtt = true;
            this.shutdown = false;
            this.entityChangedEventQueue = new ArrayBlockingQueue<EntityChangedMessage>(mqttSettings.getSubscribeMessageQueueSize());
            this.entityChangedExecutorService = ProcessorHelper.createProcessors(mqttSettings.getSubscribeThreadPoolSize(), this.entityChangedEventQueue, this::handleEntityChangedEvent, "Mqtt-EntityChangedProcessor");
            this.entityCreateEventQueue = new ArrayBlockingQueue<EntityCreateEvent>(mqttSettings.getCreateMessageQueueSize());
            this.entityCreateExecutorService = ProcessorHelper.createProcessors(mqttSettings.getCreateThreadPoolSize(), this.entityCreateEventQueue, this::handleEntityCreateEvent, "Mqtt-EntityCreateProcessor");
            this.server = MqttServerFactory.getInstance().get(this.settings);
            this.server.addSubscriptionListener(this);
            this.server.addEntityCreateListener(this);
            this.server.start();
            long queueLoggingInterval = this.settings.getSettings().getInt("queueLoggingInterval", CoreSettings.class);
            if (queueLoggingInterval > 0L) {
                this.statusLogger.setLogIntervalMs(queueLoggingInterval).addLogStatus(this.logStatus).start();
            }
        } else {
            this.enabledMqtt = false;
            this.entityChangedExecutorService = null;
            this.entityChangedEventQueue = new ArrayBlockingQueue<EntityChangedMessage>(1);
            this.entityCreateExecutorService = null;
            this.entityCreateEventQueue = new ArrayBlockingQueue<EntityCreateEvent>(1);
            this.server = null;
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.statusLogger.stop();
        ProcessorHelper.shutdownProcessors(this.entityChangedExecutorService, this.entityChangedEventQueue, 10L, TimeUnit.SECONDS);
        ProcessorHelper.shutdownProcessors(this.entityCreateExecutorService, this.entityCreateEventQueue, 10L, TimeUnit.SECONDS);
        if (this.server != null) {
            this.server.stop();
        }
    }

    private void handleEntityChangedEvent(EntityChangedMessage message) {
        this.logStatus.setEntityChangedQueueSize(this.entityChangedQueueSize.decrementAndGet());
        EntityChangedMessage.Type eventType = message.getEventType();
        EntityType entityType = message.getEntityType();
        LOGGER.trace("Received a {} message for a {}.", (Object)eventType, (Object)entityType);
        if (eventType == EntityChangedMessage.Type.DELETE) {
            return;
        }
        if (!this.subscriptions.containsKey(entityType)) {
            return;
        }
        Entity entity = message.getEntity();
        Set<Property> fields2 = message.getFields();
        try (PersistenceManager persistenceManager = PersistenceManagerFactory.getInstance(this.settings).create();){
            this.subscriptions.get(entityType).handleEntityChanged(persistenceManager, entity, fields2);
        }
        catch (Exception ex2) {
            LOGGER.error("error handling MQTT subscriptions", ex2);
        }
    }

    public void notifySubscription(Subscription subscription, Entity entity) {
        String topic = subscription.getTopic();
        try {
            String payload = subscription.formatMessage(entity);
            this.server.publish(topic, payload, this.settings.getMqttSettings().getQosLevel());
        }
        catch (IOException ex2) {
            LOGGER.error("publishing to MQTT on topic '{}' failed", (Object)topic, (Object)ex2);
        }
    }

    private void handleEntityCreateEvent(EntityCreateEvent e2) {
        Version version;
        this.logStatus.setEntityCreateQueueSize(this.entityCreateQueueSize.decrementAndGet());
        String topic = e2.getTopic();
        try {
            version = MqttManager.getVersionFromTopic(this.settings, topic);
        }
        catch (UnknownVersionException ex2) {
            LOGGER.info("received message on topic '{}' which contains no version info.", (Object)topic);
            return;
        }
        String url = topic.replaceFirst(version.urlPart, "");
        try (Service service = new Service(this.settings);){
            ServiceResponseDefault serviceResponse = new ServiceResponseDefault();
            ServiceRequest serviceRequest = new ServiceRequestBuilder(this.settings, version).withRequestType("create").withContent(e2.getPayload()).withUrlPath(url).build();
            ServiceRequest.LOCAL_REQUEST.set(serviceRequest);
            service.execute(serviceRequest, serviceResponse);
            ServiceRequest.LOCAL_REQUEST.remove();
            if (!serviceResponse.isSuccessful()) {
                LOGGER.error("Creating entity via MQTT failed (topic: {}, payload: {}, code: {}, message: {})", topic, e2.getPayload(), serviceResponse.getCode(), serviceResponse.getMessage());
            }
        }
    }

    private void entityChanged(EntityChangedMessage e2) {
        if (this.shutdown || !this.enabledMqtt) {
            return;
        }
        if (this.entityChangedEventQueue.offer(e2)) {
            this.logStatus.setEntityChangedQueueSize(this.entityChangedQueueSize.incrementAndGet());
        } else {
            LOGGER.warn("EntityChangedevent discarded because message queue is full {}! Increase mqtt.SubscribeMessageQueueSize and/or mqtt.SubscribeThreadPoolSize.", (Object)this.entityChangedEventQueue.size());
        }
    }

    @Override
    public void onSubscribe(SubscriptionEvent e2) {
        Subscription subscription = this.subscriptionFactory.get(e2.getTopic());
        if (subscription == null) {
            return;
        }
        this.subscriptions.get(subscription.getEntityType()).addSubscription(subscription);
        this.logStatus.setTopicCount(this.topicCount.get());
    }

    @Override
    public void onUnsubscribe(SubscriptionEvent e2) {
        Subscription subscription = this.subscriptionFactory.get(e2.getTopic());
        if (subscription == null) {
            return;
        }
        this.subscriptions.get(subscription.getEntityType()).removeSubscription(subscription);
        this.logStatus.setTopicCount(this.topicCount.get());
    }

    @Override
    public void messageReceived(EntityChangedMessage message) {
        this.entityChanged(message);
    }

    @Override
    public void onEntityCreate(EntityCreateEvent e2) {
        if (this.shutdown || !this.enabledMqtt) {
            return;
        }
        if (this.entityCreateEventQueue.offer(e2)) {
            this.logStatus.setEntityCreateQueueSize(this.entityCreateQueueSize.incrementAndGet());
        } else {
            LOGGER.warn("EntityCreateEvent discarded because message queue is full {}! Increase mqtt.SubscribeMessageQueueSize and/or mqtt.SubscribeThreadPoolSize", (Object)this.entityCreateEventQueue.size());
        }
    }

    public static Version getVersionFromTopic(CoreSettings settings, String topic) throws UnknownVersionException {
        int pos = topic.indexOf(47);
        if (pos == -1) {
            throw new UnknownVersionException("Could not find version in topic " + topic);
        }
        String versionString = topic.substring(0, pos);
        Version version = settings.getPluginManager().getVersion(versionString);
        if (version == null) {
            throw new UnknownVersionException("Could not find version in topic " + topic);
        }
        return version;
    }

    private static class LoggingStatus
    extends ChangingStatusLogger.ChangingStatusDefault {
        public static final String MESSAGE = "entityCreateQueue: {}, entityChangedQueue: {}, topics: {}";
        public final Object[] status = this.getCurrentParams();

        public LoggingStatus() {
            super(MESSAGE, new Object[3]);
            Arrays.setAll(this.status, i2 -> 0);
        }

        public LoggingStatus setEntityCreateQueueSize(Integer size) {
            this.status[0] = size;
            return this;
        }

        public LoggingStatus setEntityChangedQueueSize(Integer size) {
            this.status[1] = size;
            return this;
        }

        public LoggingStatus setTopicCount(Integer count) {
            this.status[2] = count;
            return this;
        }
    }
}

