/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.loader;

import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableClass;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorClass;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefEntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefPropertyTypeSimple;
import java.util.ArrayList;
import java.util.List;

@ConfigurableClass
public class DefModel
implements AnnotatedConfigurable<Void, Void> {
    @ConfigurableField(editor=EditorList.class, label="Conformance", description="The conformance classes this model implements.")
    @EditorList.EdOptsList(editor=EditorString.class)
    @EditorString.EdOptsString
    private List<String> conformance;
    @ConfigurableField(editor=EditorList.class, label="Property Types", description="Custom property types.")
    @EditorList.EdOptsList(editor=EditorClass.class)
    @EditorClass.EdOptsClass(clazz=DefPropertyTypeSimple.class)
    private List<DefPropertyTypeSimple> simplePropertyTypes;
    @ConfigurableField(editor=EditorList.class, label="Entity Types", description="The entity types of the model.")
    @EditorList.EdOptsList(editor=EditorClass.class)
    @EditorClass.EdOptsClass(clazz=DefEntityType.class)
    private List<DefEntityType> entityTypes;

    public void init() {
        for (DefEntityType type : this.entityTypes) {
            type.init();
        }
    }

    public void registerPropertyTypes(ModelRegistry modelRegistry) {
        if (this.simplePropertyTypes != null) {
            for (DefPropertyTypeSimple propertyType : this.simplePropertyTypes) {
                modelRegistry.registerPropertyType(propertyType.getPropertyType());
            }
        }
    }

    public void registerEntityTypes(ModelRegistry modelRegistry) {
        for (DefEntityType defType : this.entityTypes) {
            modelRegistry.registerEntityType(defType.getEntityType(modelRegistry));
        }
    }

    public boolean linkEntityTypes(ModelRegistry modelRegistry) {
        for (DefEntityType defType : this.entityTypes) {
            defType.linkProperties(modelRegistry);
        }
        return true;
    }

    public List<DefEntityType> getEntityTypes() {
        if (this.entityTypes == null) {
            this.entityTypes = new ArrayList<DefEntityType>();
        }
        return this.entityTypes;
    }

    public DefModel setEntityTypes(List<DefEntityType> entityTypes) {
        this.entityTypes = entityTypes;
        return this;
    }

    public DefModel addEntityType(DefEntityType entityType) {
        this.getEntityTypes().add(entityType);
        return this;
    }

    public List<DefPropertyTypeSimple> getSimplePropertyTypes() {
        if (this.simplePropertyTypes == null) {
            this.simplePropertyTypes = new ArrayList<DefPropertyTypeSimple>();
        }
        return this.simplePropertyTypes;
    }

    public void setPropertyTypes(List<DefPropertyTypeSimple> simplePropertyTypes) {
        this.simplePropertyTypes = simplePropertyTypes;
    }

    public DefModel addSimplePropertyType(DefPropertyTypeSimple propertyType) {
        this.getSimplePropertyTypes().add(propertyType);
        return this;
    }

    public List<String> getConformance() {
        if (this.conformance == null) {
            this.conformance = new ArrayList<String>();
        }
        return this.conformance;
    }

    public void addConformance(String conformanceClass) {
        this.getConformance().add(conformanceClass);
    }
}

