/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.core;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;

public class IdString
implements Id {
    public static final String PERSISTENCE_TYPE_STRING = "STRING";
    private String value;

    public IdString(String value) {
        this.value = value;
    }

    @Override
    public String getBasicPersistenceType() {
        return PERSISTENCE_TYPE_STRING;
    }

    @Override
    public Object asBasicPersistenceType() {
        return this.value;
    }

    @Override
    public void fromBasicPersitenceType(Object data) {
        this.value = data.toString();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getUrl() {
        return "'" + StringHelper.urlEncode(StringHelper.escapeForStringConstant(this.value), true) + "'";
    }

    @Override
    public String getJson() {
        return "\"" + StringEscapeUtils.escapeJson(this.value) + "\"";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdString other = (IdString)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return Objects.toString(this.getValue());
    }
}

