/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.QueryDefaults;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EntityChangedMessage {
    private Type eventType;
    private Set<EntityPropertyMain> epFields;
    private Set<NavigationPropertyMain> npFields;
    private EntityType entityType;
    private Entity entity;

    public Type getEventType() {
        return this.eventType;
    }

    public EntityChangedMessage setEventType(Type eventType) {
        this.eventType = eventType;
        return this;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public EntityChangedMessage setEntityType(EntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    public Set<EntityPropertyMain> getEpFields() {
        return this.epFields;
    }

    public Set<NavigationPropertyMain> getNpFields() {
        return this.npFields;
    }

    @JsonIgnore
    public Set<Property> getFields() {
        if (this.epFields == null && this.npFields == null) {
            return Collections.emptySet();
        }
        HashSet<Property> fields2 = new HashSet<Property>();
        if (this.epFields != null) {
            fields2.addAll(this.epFields);
        }
        if (this.npFields != null) {
            fields2.addAll(this.npFields);
        }
        return fields2;
    }

    public EntityChangedMessage addField(Property field) {
        if (field instanceof EntityPropertyMain) {
            this.addEpField((EntityPropertyMain)field);
        } else if (field instanceof NavigationPropertyMain) {
            this.addNpField((NavigationPropertyMain)field);
        } else {
            throw new IllegalArgumentException("Field is not an entity or navigation property: " + field);
        }
        return this;
    }

    public EntityChangedMessage addEpField(EntityPropertyMain field) {
        if (this.epFields == null) {
            this.epFields = new HashSet<EntityPropertyMain>();
        }
        this.epFields.add(field);
        return this;
    }

    public EntityChangedMessage addNpField(NavigationPropertyMain field) {
        if (this.npFields == null) {
            this.npFields = new HashSet<NavigationPropertyMain>();
        }
        this.npFields.add(field);
        return this;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public EntityChangedMessage setEntity(Entity entity) {
        this.entity = entity;
        this.entityType = entity.getEntityType();
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityChangedMessage other = (EntityChangedMessage)obj;
        if (this.eventType != other.eventType) {
            return false;
        }
        if (!Objects.equals(this.epFields, other.epFields)) {
            return false;
        }
        if (this.entityType != other.entityType) {
            return false;
        }
        return Objects.equals(this.entity, other.entity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventType, this.epFields, this.entityType, this.entity});
    }

    public static class QueryGenerator {
        private final QueryDefaults queryDefaults = new QueryDefaults(true, false, 1, 1, false);
        public final Map<EntityType, Query> messageQueries = new ConcurrentHashMap<EntityType, Query>();

        public Query getQueryFor(EntityType entityType) {
            return this.messageQueries.computeIfAbsent(entityType, t2 -> {
                Query query = new Query(t2.getModelRegistry(), this.queryDefaults, new ResourcePath("", Version.V_1_0, "/" + entityType.entityName));
                for (EntityPropertyMain entityPropertyMain : entityType.getEntityProperties()) {
                    query.addSelect((Property)entityPropertyMain);
                }
                for (NavigationPropertyMain navigationPropertyMain : entityType.getNavigationEntities()) {
                    Query subQuery = new Query(t2.getModelRegistry(), this.queryDefaults, new ResourcePath("", Version.V_1_0, "/" + navigationPropertyMain.getName())).addSelect((Property)navigationPropertyMain.getEntityType().getPrimaryKey());
                    query.addExpand(new Expand(t2.getModelRegistry(), navigationPropertyMain).setSubQuery(subQuery));
                }
                return query;
            });
        }
    }

    public static enum Type {
        CREATE,
        UPDATE,
        DELETE;

    }
}

