/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.json.serialize.custom;

import de.fraunhofer.iosb.ilt.frostserver.json.serialize.custom.CustomSerializer;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.custom.DefaultSerializer;
import java.util.HashMap;
import java.util.Map;

public class CustomSerializationManager {
    private static CustomSerializationManager instance;
    private final Map<String, CustomSerializer> customSerializers = new HashMap<String, CustomSerializer>();

    private CustomSerializationManager() {
    }

    public static CustomSerializationManager getInstance() {
        if (instance == null) {
            instance = new CustomSerializationManager();
        }
        return instance;
    }

    public void registerSerializer(String encodingType, CustomSerializer serializer) {
        this.customSerializers.computeIfAbsent(encodingType, t2 -> serializer);
    }

    public CustomSerializer getSerializer(String encodingType) {
        CustomSerializer result = this.customSerializers.get(encodingType);
        if (result == null) {
            result = new DefaultSerializer();
        }
        return result;
    }
}

