/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.json.serialize;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.fraunhofer.iosb.ilt.frostserver.json.mixin.MixinUtils;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.DateSerialiser;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.EntityChangedMessageSerializer;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.EntityPropertySerialiser;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.EntitySerializer;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.EntitySetResultSerializer;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.EntityTypeSerialiser;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.MomentSerializer;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.OffsetDateTimeSerializer;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.TimeObjectSerializer;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.EntitySetResult;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeObject;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import java.io.IOException;
import java.io.Writer;
import java.time.OffsetDateTime;
import java.util.Date;
import net.time4j.Moment;

public class JsonWriter {
    private static ObjectMapper objectMapperInstance;

    public static ObjectMapper getObjectMapper() {
        if (objectMapperInstance == null) {
            JsonWriter.initObjectMapper();
        }
        return objectMapperInstance;
    }

    private static synchronized void initObjectMapper() {
        if (objectMapperInstance == null) {
            objectMapperInstance = JsonWriter.createObjectMapper();
        }
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.disable(SerializationFeature.FLUSH_AFTER_WRITE_VALUE);
        MixinUtils.addMixins(mapper);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Entity.class, new EntitySerializer());
        module.addSerializer(EntityChangedMessage.class, new EntityChangedMessageSerializer());
        module.addSerializer(EntitySetResult.class, new EntitySetResultSerializer());
        module.addSerializer(TimeObject.class, new TimeObjectSerializer());
        module.addSerializer(OffsetDateTime.class, new OffsetDateTimeSerializer());
        module.addSerializer(Moment.class, new MomentSerializer());
        module.addSerializer(EntityType.class, new EntityTypeSerialiser());
        module.addSerializer(Property.class, new EntityPropertySerialiser());
        module.addSerializer(Date.class, new DateSerialiser());
        mapper.registerModule(module);
        return mapper;
    }

    private JsonWriter() {
    }

    public static <T extends Entity> void writeEntity(Writer writer, T entity) throws IOException {
        JsonWriter.getObjectMapper().writeValue(writer, entity);
    }

    public static <T extends Entity> String writeEntity(T entity) throws IOException {
        return JsonWriter.getObjectMapper().writeValueAsString(entity);
    }

    public static void writeEntityCollection(Writer writer, EntitySet entityCollection) throws IOException {
        JsonWriter.getObjectMapper().writeValue(writer, (Object)new EntitySetResult(entityCollection));
    }

    public static String writeEntityCollection(EntitySet entityCollection) throws IOException {
        return JsonWriter.getObjectMapper().writeValueAsString(new EntitySetResult(entityCollection));
    }

    public static void writeObject(Writer writer, Object object) throws IOException {
        JsonWriter.getObjectMapper().writeValue(writer, object);
    }

    public static String writeObject(Object object) throws IOException {
        return JsonWriter.getObjectMapper().writeValueAsString(object);
    }
}

