/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.json.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.EntitySetResult;
import java.io.IOException;

public class EntitySetResultSerializer
extends JsonSerializer<EntitySetResult> {
    @Override
    public void serialize(EntitySetResult value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        long count = value.getValues().getCount();
        if (count >= 0L) {
            gen.writeNumberField("@iot.count", count);
        }
        gen.writeArrayFieldStart("value");
        for (Entity child : value.getValues()) {
            gen.writeObject(child);
        }
        gen.writeEndArray();
        String nextLink = value.getValues().getNextLink();
        if (nextLink != null) {
            gen.writeStringField("@iot.nextLink", nextLink);
        }
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, EntitySetResult value) {
        return value == null || value.getValues() == null;
    }
}

