/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.fx;

import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.editor.AbstractEditorMap;
import java.util.ArrayList;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;

public final class FactoryMapFx
implements GuiFactoryFx {
    private final AbstractEditorMap<?, ?> parentEditor;
    private BorderPane fxPaneRoot;
    private GridPane fxPaneList;
    private ComboBox<AbstractEditorMap.Item> fxBoxNames;
    private FlowPane controls;

    public FactoryMapFx(AbstractEditorMap<?, ?> parentEditor) {
        this.parentEditor = parentEditor;
    }

    @Override
    public Pane getNode() {
        if (this.fxPaneRoot == null) {
            this.createPane();
        }
        return this.fxPaneRoot;
    }

    private void createPane() {
        this.fxPaneRoot = new BorderPane();
        this.controls = new FlowPane();
        this.controls.setAlignment(Pos.BASELINE_LEFT);
        ArrayList optionals = new ArrayList();
        for (String optionName : this.parentEditor.getOptionalOptions()) {
            if (this.parentEditor.getRawValue().contains(optionName)) continue;
            optionals.add(this.parentEditor.getOptions().get(optionName));
        }
        optionals.sort((o1, o2) -> o1.label.compareTo(o2.label));
        this.fxBoxNames = new ComboBox(FXCollections.observableArrayList(optionals));
        this.controls.getChildren().add(this.fxBoxNames);
        Button addButton = new Button("+");
        addButton.setOnAction(event -> this.addItem());
        this.controls.getChildren().add(addButton);
        this.fxPaneRoot.setTop(this.controls);
        if (this.parentEditor.getOptionalOptions().isEmpty()) {
            this.controls.setVisible(false);
        }
        this.fxPaneList = new GridPane();
        this.fxPaneRoot.setStyle("    -fx-border-base: gray;    -fx-border-shadow: white;    -fx-light-border: derive(-fx-border-base, 25%);    -fx-border-color: -fx-light-border -fx-border-base -fx-border-base -fx-light-border;    -fx-border-insets: 0 1 1 0;    -fx-background-color: -fx-border-shadow, -fx-background;    -fx-background-insets: 1 0 0 1, 2;    -fx-padding: 2;");
        this.fxPaneRoot.setCenter(this.fxPaneList);
        this.fillComponent();
    }

    public void fillComponent() {
        this.controls.setVisible(this.parentEditor.canEdit() && !this.parentEditor.getOptionalOptions().isEmpty());
        this.fxPaneList.getChildren().clear();
        int row = 0;
        int endCol = -1;
        boolean canEdit = this.parentEditor.canEdit();
        String profile = this.parentEditor.getProfile();
        this.fxBoxNames.getItems().clear();
        for (Map.Entry<String, AbstractEditorMap.Item<?>> entry : this.parentEditor.getOptions().entrySet()) {
            String key = entry.getKey();
            AbstractEditorMap.Item<?> item = entry.getValue();
            if (canEdit && !this.parentEditor.getRawValue().contains(key)) {
                if (!item.hasGuiProfile(profile)) continue;
                this.fxBoxNames.getItems().add(item);
                continue;
            }
            if (!item.hasGuiProfile(profile) || !item.editor.canEdit() && item.editor.isDefault()) continue;
            if (!canEdit && !this.parentEditor.getRawValue().contains(key)) {
                this.parentEditor.getRawValue().add(key);
            }
            if ((endCol += item.colwidth) >= this.parentEditor.getColumns()) {
                endCol = item.colwidth - 1;
                ++row;
            }
            int startCol = endCol - item.colwidth + 1;
            int width = 3 * item.colwidth - 2;
            int x0 = startCol * 3;
            int x1 = x0 + 1;
            int x2 = x0 + width + 1;
            String label = item.editor.getLabel();
            if (label.isEmpty()) {
                label = key;
            }
            this.addToGridFx(row, x0, label, x1, item, width, x2, key);
        }
    }

    private void addToGridFx(int row, int x0, String label, int x1, AbstractEditorMap.Item<?> item, int width, int x2, String key) {
        Label fxLabel = new Label(label);
        fxLabel.setTooltip(new Tooltip(item.editor.getDescription()));
        GridPane.setConstraints(fxLabel, x0, row, 1, 1, HPos.LEFT, VPos.BASELINE, Priority.NEVER, Priority.NEVER);
        this.fxPaneList.getChildren().add(fxLabel);
        Node itemPane = item.editor.getGuiFactoryFx().getNode();
        GridPane.setConstraints(itemPane, x2, row, width, 1, HPos.LEFT, VPos.BASELINE, Priority.SOMETIMES, Priority.NEVER);
        this.fxPaneList.getChildren().add(itemPane);
        if (!this.parentEditor.getOptionalOptions().isEmpty()) {
            Button removeButton = new Button("\u2716");
            removeButton.setDisable(!item.optional);
            removeButton.setOnAction(event -> this.parentEditor.removeItem(key));
            GridPane.setConstraints(removeButton, x1, row, 1, 1, HPos.LEFT, VPos.TOP, Priority.NEVER, Priority.NEVER);
            this.fxPaneList.getChildren().add(removeButton);
        }
    }

    private void addItem() {
        AbstractEditorMap.Item item = (AbstractEditorMap.Item)this.fxBoxNames.getSelectionModel().getSelectedItem();
        if (item != null) {
            String key = item.getName();
            this.parentEditor.addItem(key);
        }
    }

    public void addItem(String key) {
        if (this.fxBoxNames != null) {
            this.fxBoxNames.getItems().remove(this.parentEditor.getOptions().get(key));
        }
        this.fillComponent();
    }

    public void removeItem(AbstractEditorMap.Item<?> item) {
        if (item.optional) {
            if (this.fxBoxNames != null) {
                this.fxBoxNames.getItems().add(item);
            }
            this.fillComponent();
        }
    }
}

