/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.fx;

import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;

public final class FactoryListFx<U, T extends ConfigEditor<U>>
implements GuiFactoryFx {
    private final EditorList<U, T> parentEditor;
    private BorderPane fxPaneRoot;
    private GridPane fxPaneList;
    private Button addButton;
    private boolean vertical = true;
    private String text = "Add item";

    public FactoryListFx(EditorList<U, T> parentEditor, boolean vertical) {
        this.parentEditor = parentEditor;
        this.vertical = vertical;
        if (parentEditor.getMinCount() != parentEditor.getMaxCount()) {
            this.text = "Items:";
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public Pane getNode() {
        if (this.fxPaneRoot == null) {
            this.createPane();
        }
        return this.fxPaneRoot;
    }

    private void createPane() {
        FlowPane controls = new FlowPane();
        controls.setAlignment(Pos.TOP_RIGHT);
        Label addLabel = new Label(this.text);
        addLabel.setAlignment(Pos.BASELINE_RIGHT);
        controls.getChildren().add(addLabel);
        this.addButton = new Button("+");
        this.addButton.setOnAction(event -> this.parentEditor.addItem());
        controls.getChildren().add(this.addButton);
        this.fxPaneList = new GridPane();
        this.fxPaneRoot = new BorderPane();
        this.fxPaneRoot.setStyle("    -fx-border-base: gray;    -fx-border-shadow: white;    -fx-light-border: derive(-fx-border-base, 25%);    -fx-border-color: -fx-light-border -fx-border-base -fx-border-base -fx-light-border;    -fx-border-insets: 0 1 1 0;    -fx-background-color: -fx-border-shadow, -fx-background;    -fx-background-insets: 1 0 0 1, 2;    -fx-padding: 2;");
        this.fxPaneRoot.setTop(controls);
        this.fxPaneRoot.setCenter(this.fxPaneList);
        this.fillComponent();
    }

    public void fillComponent() {
        if (this.fxPaneRoot == null) {
            this.createPane();
        }
        this.addButton.setVisible(this.parentEditor.canEdit());
        this.fxPaneList.getChildren().clear();
        if (this.parentEditor.getRawValue().isEmpty()) {
            this.fxPaneList.add(new Label("No items added."), 0, 0);
        }
        int row = 0;
        for (ConfigEditor item : this.parentEditor.getRawValue()) {
            Node pane = item.getGuiFactoryFx().getNode();
            GridPane.setConstraints(pane, this.vertical ? 0 : row, this.vertical ? row : 0, 1, 1, HPos.LEFT, VPos.BASELINE, Priority.ALWAYS, Priority.SOMETIMES);
            if (this.parentEditor.canEdit()) {
                Button removeButton = new Button("-");
                removeButton.setOnAction(event -> this.parentEditor.removeItem(item));
                GridPane.setConstraints(removeButton, this.vertical ? 1 : row, this.vertical ? row : 1, 1, 1, HPos.RIGHT, VPos.TOP, Priority.NEVER, Priority.NEVER);
                this.fxPaneList.getChildren().addAll((Node[])new Node[]{pane, removeButton});
            }
            ++row;
        }
    }
}

