/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.annotations;

import com.google.gson.JsonElement;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditors;
import de.fraunhofer.iosb.ilt.configurable.Configurable;
import de.fraunhofer.iosb.ilt.configurable.ConfigurationException;
import de.fraunhofer.iosb.ilt.configurable.ContentConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.Utils;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableClass;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableConstructor;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableParameter;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorMap;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationHelper.class.getName());

    private AnnotationHelper() {
    }

    public static final <C, D> Optional<EditorMap<?>> generateEditorFromAnnotations(Configurable<C, D> instance, C context, D edtCtx) {
        return AnnotationHelper.generateEditorFromAnnotations(instance.getClass(), context, edtCtx);
    }

    public static final <C, D> Optional<EditorMap<?>> generateEditorFromAnnotations(Class<?> configurableClass, C context, D edtCtx) {
        EditorMap map = new EditorMap();
        boolean annotated = false;
        Class<?> type = configurableClass;
        block2: do {
            ConfigurableClass classAnnotation;
            if ((classAnnotation = type.getAnnotation(ConfigurableClass.class)) != null) {
                annotated = true;
                if (classAnnotation.profilesEdit().isEmpty()) break;
                map.setProfilesEdit(classAnnotation.profilesEdit());
                break;
            }
            for (AnnotatedElement annotatedElement : type.getInterfaces()) {
                classAnnotation = ((Class)annotatedElement).getAnnotation(ConfigurableClass.class);
                if (classAnnotation == null) continue;
                annotated = true;
                if (classAnnotation.profilesEdit().isEmpty()) continue block2;
                map.setProfilesEdit(classAnnotation.profilesEdit());
                continue block2;
            }
        } while (!annotated && (type = type.getSuperclass()) != null);
        Field[] fields2 = FieldUtils.getAllFields(configurableClass);
        for (AnnotatedElement annotatedElement : fields2) {
            ConfigurableField annotation = ((Field)annotatedElement).getAnnotation(ConfigurableField.class);
            if (annotation == null) {
                LOGGER.debug("Field {} has no annotations.", (Object)annotatedElement);
                continue;
            }
            annotated = true;
            Class<? extends ConfigEditor> editorClass = annotation.editor();
            try {
                ConfigEditor fieldEditor = AnnotationHelper.createEditor(editorClass, (Field)annotatedElement, context, edtCtx);
                fieldEditor.setLabel(annotation.label());
                fieldEditor.setDescription(annotation.description());
                String jsonName = AnnotationHelper.jsonNameForField((Field)annotatedElement, annotation);
                map.addOption(((Field)annotatedElement).getName(), jsonName, fieldEditor, annotation);
            }
            catch (ReflectiveOperationException ex2) {
                LOGGER.error("could not instantiate give editor: {}", (Object)editorClass);
                LOGGER.info("Exception", ex2);
            }
        }
        if (!annotated) {
            annotated = AnnotationHelper.hasConfigurableConstructorAnnotation(configurableClass);
        }
        return annotated ? Optional.of(map) : Optional.empty();
    }

    public static <E, F, T extends ConfigEditor> T createEditor(Class<T> editorForClass, Field field, E context, F edtCtx) throws ReflectiveOperationException {
        ConfigEditor fieldEditor = (ConfigEditor)editorForClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        try {
            MethodUtils.invokeMethod((Object)fieldEditor, "setContexts", context, edtCtx);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exc) {
            LOGGER.trace("", exc);
        }
        fieldEditor.initFor(field);
        return (T)fieldEditor;
    }

    public static <E, F, T extends ConfigEditor> T createEditor(Class<T> editorForClass, Field field, E context, F edtCtx, String key) throws IllegalAccessException, ReflectiveOperationException {
        ConfigEditor fieldEditor = (ConfigEditor)editorForClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        try {
            MethodUtils.invokeMethod((Object)fieldEditor, "setContexts", context, edtCtx);
        }
        catch (ReflectiveOperationException exc) {
            LOGGER.trace("", exc);
        }
        fieldEditor.initFor(field, key);
        return (T)fieldEditor;
    }

    private static String jsonNameForField(Field field, ConfigurableField annotation) {
        if (annotation.jsonField().isEmpty()) {
            return field.getName();
        }
        return annotation.jsonField();
    }

    public static Set<String> csvToReadOnlySet(String csv) {
        String[] split;
        HashSet<String> set = new HashSet<String>();
        set.add("default");
        for (String item : split = csv.split(",")) {
            String lcItem = item.trim().toLowerCase();
            if (lcItem.isEmpty()) continue;
            set.add(lcItem);
        }
        return Collections.unmodifiableSet(set);
    }

    public static boolean hasConfigurableConstructorAnnotation(Class<?> configurableClass) {
        return AnnotationHelper.getConfigurableConstructor(configurableClass).isPresent();
    }

    public static Optional<Constructor<?>> getConfigurableConstructor(Class<?> configurableClass) {
        return Arrays.stream(configurableClass.getConstructors()).filter(ctor -> Objects.nonNull(ctor.getAnnotation(ConfigurableConstructor.class))).findFirst();
    }

    public static <T, R, E> T instantiateFrom(Constructor<?> configurableConstructor, JsonElement classConfig, R runtimeContext, E editorContext) throws ReflectiveOperationException, IllegalArgumentException, ConfigurationException {
        ContentConfigEditor editor = (ContentConfigEditor)ConfigEditors.buildEditorFromClass(configurableConstructor.getDeclaringClass(), runtimeContext, editorContext).get();
        editor.setConfig(classConfig);
        T instance = AnnotationHelper.instantiateFrom(configurableConstructor, classConfig, editor, runtimeContext);
        ((Configurable)instance).configure(classConfig, runtimeContext, editorContext, editor);
        return instance;
    }

    private static <T, R, E> T instantiateFrom(Constructor<?> configurableConstructor, JsonElement classConfig, ContentConfigEditor<?> editor, R runtimeContext) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] initargs = AnnotationHelper.buildConstructorInitargs(configurableConstructor, classConfig, editor, runtimeContext);
        return (T)configurableConstructor.newInstance(initargs);
    }

    private static <R> Object[] buildConstructorInitargs(Constructor<?> configurableConstructor, JsonElement classConfig, ContentConfigEditor<?> editor, R runtimeContext) {
        return Arrays.stream(configurableConstructor.getParameters()).map(param -> AnnotationHelper.buildConstructorInitarg(param, classConfig, editor, runtimeContext)).toArray();
    }

    private static <R> Object buildConstructorInitarg(Parameter parameter, JsonElement classConfig, ContentConfigEditor<?> editor, R runtimeContext) {
        try {
            ConfigurableParameter annotation = parameter.getAnnotation(ConfigurableParameter.class);
            if (annotation == null) {
                return null;
            }
            switch (annotation.type()) {
                case RUNTIME_CONTEXT: {
                    return runtimeContext;
                }
                case CLASS_CONFIG: {
                    return classConfig;
                }
                case JSON_FIELD: {
                    String jsonField = annotation.jsonField();
                    if (Utils.isNullOrEmpty(jsonField)) {
                        return null;
                    }
                    return editor.getValue(jsonField);
                }
            }
            return null;
        }
        catch (ConfigurationException exc) {
            throw new IllegalArgumentException(exc);
        }
    }

    public static boolean hasConfigurableConstructorParameter(Object instance, String jsonField) {
        if (instance == null) {
            return false;
        }
        Optional<Constructor<?>> configurableConstructor = AnnotationHelper.getConfigurableConstructor(instance.getClass());
        if (!configurableConstructor.isPresent()) {
            return false;
        }
        return Arrays.stream(configurableConstructor.get().getParameters()).map(parameter -> parameter.getAnnotation(ConfigurableParameter.class)).filter(Objects::nonNull).anyMatch(config -> config.jsonField().equals(jsonField));
    }
}

