/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.AffineTransformation;

public class GeometricShapeFactory {
    protected GeometryFactory geomFact;
    protected PrecisionModel precModel = null;
    protected Dimensions dim = new Dimensions();
    protected int nPts = 100;
    protected double rotationAngle = 0.0;

    public GeometricShapeFactory() {
        this(new GeometryFactory());
    }

    public GeometricShapeFactory(GeometryFactory geomFact) {
        this.geomFact = geomFact;
        this.precModel = geomFact.getPrecisionModel();
    }

    public void setEnvelope(Envelope env) {
        this.dim.setEnvelope(env);
    }

    public void setBase(Coordinate base) {
        this.dim.setBase(base);
    }

    public void setCentre(Coordinate centre) {
        this.dim.setCentre(centre);
    }

    public void setNumPoints(int nPts) {
        this.nPts = nPts;
    }

    public void setSize(double size) {
        this.dim.setSize(size);
    }

    public void setWidth(double width) {
        this.dim.setWidth(width);
    }

    public void setHeight(double height) {
        this.dim.setHeight(height);
    }

    public void setRotation(double radians2) {
        this.rotationAngle = radians2;
    }

    protected Geometry rotate(Geometry geom) {
        if (this.rotationAngle != 0.0) {
            AffineTransformation trans = AffineTransformation.rotationInstance(this.rotationAngle, this.dim.getCentre().x, this.dim.getCentre().y);
            geom.apply(trans);
        }
        return geom;
    }

    public Polygon createRectangle() {
        double y2;
        double x2;
        int i2;
        int ipt = 0;
        int nSide = this.nPts / 4;
        if (nSide < 1) {
            nSide = 1;
        }
        double XsegLen = this.dim.getEnvelope().getWidth() / (double)nSide;
        double YsegLen = this.dim.getEnvelope().getHeight() / (double)nSide;
        Coordinate[] pts = new Coordinate[4 * nSide + 1];
        Envelope env = this.dim.getEnvelope();
        for (i2 = 0; i2 < nSide; ++i2) {
            x2 = env.getMinX() + (double)i2 * XsegLen;
            y2 = env.getMinY();
            pts[ipt++] = this.coord(x2, y2);
        }
        for (i2 = 0; i2 < nSide; ++i2) {
            x2 = env.getMaxX();
            y2 = env.getMinY() + (double)i2 * YsegLen;
            pts[ipt++] = this.coord(x2, y2);
        }
        for (i2 = 0; i2 < nSide; ++i2) {
            x2 = env.getMaxX() - (double)i2 * XsegLen;
            y2 = env.getMaxY();
            pts[ipt++] = this.coord(x2, y2);
        }
        for (i2 = 0; i2 < nSide; ++i2) {
            x2 = env.getMinX();
            y2 = env.getMaxY() - (double)i2 * YsegLen;
            pts[ipt++] = this.coord(x2, y2);
        }
        pts[ipt++] = new Coordinate(pts[0]);
        LinearRing ring = this.geomFact.createLinearRing(pts);
        Polygon poly = this.geomFact.createPolygon(ring, null);
        return (Polygon)this.rotate(poly);
    }

    public Polygon createCircle() {
        return this.createEllipse();
    }

    public Polygon createEllipse() {
        Envelope env = this.dim.getEnvelope();
        double xRadius = env.getWidth() / 2.0;
        double yRadius = env.getHeight() / 2.0;
        double centreX = env.getMinX() + xRadius;
        double centreY = env.getMinY() + yRadius;
        Coordinate[] pts = new Coordinate[this.nPts + 1];
        int iPt = 0;
        for (int i2 = 0; i2 < this.nPts; ++i2) {
            double ang = (double)i2 * (Math.PI * 2 / (double)this.nPts);
            double x2 = xRadius * Math.cos(ang) + centreX;
            double y2 = yRadius * Math.sin(ang) + centreY;
            pts[iPt++] = this.coord(x2, y2);
        }
        pts[iPt] = new Coordinate(pts[0]);
        LinearRing ring = this.geomFact.createLinearRing(pts);
        Polygon poly = this.geomFact.createPolygon(ring, null);
        return (Polygon)this.rotate(poly);
    }

    public Polygon createSquircle() {
        return this.createSupercircle(4.0);
    }

    public Polygon createSupercircle(double power) {
        double recipPow = 1.0 / power;
        double radius = this.dim.getMinSize() / 2.0;
        Coordinate centre = this.dim.getCentre();
        double r4 = Math.pow(radius, power);
        double y0 = radius;
        double xyInt = Math.pow(r4 / 2.0, recipPow);
        int nSegsInOct = this.nPts / 8;
        int totPts = nSegsInOct * 8 + 1;
        Coordinate[] pts = new Coordinate[totPts];
        double xInc = xyInt / (double)nSegsInOct;
        for (int i2 = 0; i2 <= nSegsInOct; ++i2) {
            double x2 = 0.0;
            double y2 = y0;
            if (i2 != 0) {
                x2 = xInc * (double)i2;
                double x4 = Math.pow(x2, power);
                y2 = Math.pow(r4 - x4, recipPow);
            }
            pts[i2] = this.coordTrans(x2, y2, centre);
            pts[2 * nSegsInOct - i2] = this.coordTrans(y2, x2, centre);
            pts[2 * nSegsInOct + i2] = this.coordTrans(y2, -x2, centre);
            pts[4 * nSegsInOct - i2] = this.coordTrans(x2, -y2, centre);
            pts[4 * nSegsInOct + i2] = this.coordTrans(-x2, -y2, centre);
            pts[6 * nSegsInOct - i2] = this.coordTrans(-y2, -x2, centre);
            pts[6 * nSegsInOct + i2] = this.coordTrans(-y2, x2, centre);
            pts[8 * nSegsInOct - i2] = this.coordTrans(-x2, y2, centre);
        }
        pts[pts.length - 1] = new Coordinate(pts[0]);
        LinearRing ring = this.geomFact.createLinearRing(pts);
        Polygon poly = this.geomFact.createPolygon(ring, null);
        return (Polygon)this.rotate(poly);
    }

    public LineString createArc(double startAng, double angExtent) {
        Envelope env = this.dim.getEnvelope();
        double xRadius = env.getWidth() / 2.0;
        double yRadius = env.getHeight() / 2.0;
        double centreX = env.getMinX() + xRadius;
        double centreY = env.getMinY() + yRadius;
        double angSize = angExtent;
        if (angSize <= 0.0 || angSize > Math.PI * 2) {
            angSize = Math.PI * 2;
        }
        double angInc = angSize / (double)(this.nPts - 1);
        Coordinate[] pts = new Coordinate[this.nPts];
        int iPt = 0;
        for (int i2 = 0; i2 < this.nPts; ++i2) {
            double ang = startAng + (double)i2 * angInc;
            double x2 = xRadius * Math.cos(ang) + centreX;
            double y2 = yRadius * Math.sin(ang) + centreY;
            pts[iPt++] = this.coord(x2, y2);
        }
        LineString line = this.geomFact.createLineString(pts);
        return (LineString)this.rotate(line);
    }

    public Polygon createArcPolygon(double startAng, double angExtent) {
        Envelope env = this.dim.getEnvelope();
        double xRadius = env.getWidth() / 2.0;
        double yRadius = env.getHeight() / 2.0;
        double centreX = env.getMinX() + xRadius;
        double centreY = env.getMinY() + yRadius;
        double angSize = angExtent;
        if (angSize <= 0.0 || angSize > Math.PI * 2) {
            angSize = Math.PI * 2;
        }
        double angInc = angSize / (double)(this.nPts - 1);
        Coordinate[] pts = new Coordinate[this.nPts + 2];
        int iPt = 0;
        pts[iPt++] = this.coord(centreX, centreY);
        for (int i2 = 0; i2 < this.nPts; ++i2) {
            double ang = startAng + angInc * (double)i2;
            double x2 = xRadius * Math.cos(ang) + centreX;
            double y2 = yRadius * Math.sin(ang) + centreY;
            pts[iPt++] = this.coord(x2, y2);
        }
        pts[iPt++] = this.coord(centreX, centreY);
        LinearRing ring = this.geomFact.createLinearRing(pts);
        Polygon poly = this.geomFact.createPolygon(ring, null);
        return (Polygon)this.rotate(poly);
    }

    protected Coordinate coord(double x2, double y2) {
        Coordinate pt2 = new Coordinate(x2, y2);
        this.precModel.makePrecise(pt2);
        return pt2;
    }

    protected Coordinate coordTrans(double x2, double y2, Coordinate trans) {
        return this.coord(x2 + trans.x, y2 + trans.y);
    }

    protected class Dimensions {
        public Coordinate base;
        public Coordinate centre;
        public double width;
        public double height;

        protected Dimensions() {
        }

        public void setBase(Coordinate base) {
            this.base = base;
        }

        public Coordinate getBase() {
            return this.base;
        }

        public void setCentre(Coordinate centre) {
            this.centre = centre;
        }

        public Coordinate getCentre() {
            if (this.centre == null) {
                this.centre = new Coordinate(this.base.x + this.width / 2.0, this.base.y + this.height / 2.0);
            }
            return this.centre;
        }

        public void setSize(double size) {
            this.height = size;
            this.width = size;
        }

        public double getMinSize() {
            return Math.min(this.width, this.height);
        }

        public void setWidth(double width) {
            this.width = width;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double height) {
            this.height = height;
        }

        public void setEnvelope(Envelope env) {
            this.width = env.getWidth();
            this.height = env.getHeight();
            this.base = new Coordinate(env.getMinX(), env.getMinY());
            this.centre = new Coordinate(env.centre());
        }

        public Envelope getEnvelope() {
            if (this.base != null) {
                return new Envelope(this.base.x, this.base.x + this.width, this.base.y, this.base.y + this.height);
            }
            if (this.centre != null) {
                return new Envelope(this.centre.x - this.width / 2.0, this.centre.x + this.width / 2.0, this.centre.y - this.height / 2.0, this.centre.y + this.height / 2.0);
            }
            return new Envelope(0.0, this.width, 0.0, this.height);
        }
    }
}

