/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate.quadedge;

import com.vividsolutions.jts.algorithm.HCoordinate;
import com.vividsolutions.jts.algorithm.NotRepresentableException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdge;
import com.vividsolutions.jts.triangulate.quadedge.TrianglePredicate;

public class Vertex {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int BEYOND = 2;
    public static final int BEHIND = 3;
    public static final int BETWEEN = 4;
    public static final int ORIGIN = 5;
    public static final int DESTINATION = 6;
    private Coordinate p;

    public Vertex(double _x, double _y) {
        this.p = new Coordinate(_x, _y);
    }

    public Vertex(double _x, double _y, double _z) {
        this.p = new Coordinate(_x, _y, _z);
    }

    public Vertex(Coordinate _p) {
        this.p = new Coordinate(_p);
    }

    public double getX() {
        return this.p.x;
    }

    public double getY() {
        return this.p.y;
    }

    public double getZ() {
        return this.p.z;
    }

    public void setZ(double _z) {
        this.p.z = _z;
    }

    public Coordinate getCoordinate() {
        return this.p;
    }

    public String toString() {
        return "POINT (" + this.p.x + " " + this.p.y + ")";
    }

    public boolean equals(Vertex _x) {
        return this.p.x == _x.getX() && this.p.y == _x.getY();
    }

    public boolean equals(Vertex _x, double tolerance) {
        return this.p.distance(_x.getCoordinate()) < tolerance;
    }

    public int classify(Vertex p0, Vertex p1) {
        Vertex b2;
        Vertex p2 = this;
        Vertex a2 = p1.sub(p0);
        double sa = a2.crossProduct(b2 = p2.sub(p0));
        if (sa > 0.0) {
            return 0;
        }
        if (sa < 0.0) {
            return 1;
        }
        if (a2.getX() * b2.getX() < 0.0 || a2.getY() * b2.getY() < 0.0) {
            return 3;
        }
        if (a2.magn() < b2.magn()) {
            return 2;
        }
        if (p0.equals(p2)) {
            return 5;
        }
        if (p1.equals(p2)) {
            return 6;
        }
        return 4;
    }

    double crossProduct(Vertex v2) {
        return this.p.x * v2.getY() - this.p.y * v2.getX();
    }

    double dot(Vertex v2) {
        return this.p.x * v2.getX() + this.p.y * v2.getY();
    }

    Vertex times(double c2) {
        return new Vertex(c2 * this.p.x, c2 * this.p.y);
    }

    Vertex sum(Vertex v2) {
        return new Vertex(this.p.x + v2.getX(), this.p.y + v2.getY());
    }

    Vertex sub(Vertex v2) {
        return new Vertex(this.p.x - v2.getX(), this.p.y - v2.getY());
    }

    double magn() {
        return Math.sqrt(this.p.x * this.p.x + this.p.y * this.p.y);
    }

    Vertex cross() {
        return new Vertex(this.p.y, -this.p.x);
    }

    public boolean isInCircle(Vertex a2, Vertex b2, Vertex c2) {
        return TrianglePredicate.isInCircleRobust(a2.p, b2.p, c2.p, this.p);
    }

    public final boolean isCCW(Vertex b2, Vertex c2) {
        return (b2.p.x - this.p.x) * (c2.p.y - this.p.y) - (b2.p.y - this.p.y) * (c2.p.x - this.p.x) > 0.0;
    }

    public final boolean rightOf(QuadEdge e2) {
        return this.isCCW(e2.dest(), e2.orig());
    }

    public final boolean leftOf(QuadEdge e2) {
        return this.isCCW(e2.orig(), e2.dest());
    }

    private HCoordinate bisector(Vertex a2, Vertex b2) {
        double dx2 = b2.getX() - a2.getX();
        double dy2 = b2.getY() - a2.getY();
        HCoordinate l1 = new HCoordinate(a2.getX() + dx2 / 2.0, a2.getY() + dy2 / 2.0, 1.0);
        HCoordinate l2 = new HCoordinate(a2.getX() - dy2 + dx2 / 2.0, a2.getY() + dx2 + dy2 / 2.0, 1.0);
        return new HCoordinate(l1, l2);
    }

    private double distance(Vertex v1, Vertex v2) {
        return Math.sqrt(Math.pow(v2.getX() - v1.getX(), 2.0) + Math.pow(v2.getY() - v1.getY(), 2.0));
    }

    public double circumRadiusRatio(Vertex b2, Vertex c2) {
        Vertex x2 = this.circleCenter(b2, c2);
        double radius = this.distance(x2, b2);
        double edgeLength = this.distance(this, b2);
        double el2 = this.distance(b2, c2);
        if (el2 < edgeLength) {
            edgeLength = el2;
        }
        if ((el2 = this.distance(c2, this)) < edgeLength) {
            edgeLength = el2;
        }
        return radius / edgeLength;
    }

    public Vertex midPoint(Vertex a2) {
        double xm = (this.p.x + a2.getX()) / 2.0;
        double ym = (this.p.y + a2.getY()) / 2.0;
        double zm = (this.p.z + a2.getZ()) / 2.0;
        return new Vertex(xm, ym, zm);
    }

    public Vertex circleCenter(Vertex b2, Vertex c2) {
        Vertex a2 = new Vertex(this.getX(), this.getY());
        HCoordinate cab = this.bisector(a2, b2);
        HCoordinate cbc = this.bisector(b2, c2);
        HCoordinate hcc = new HCoordinate(cab, cbc);
        Vertex cc2 = null;
        try {
            cc2 = new Vertex(hcc.getX(), hcc.getY());
        }
        catch (NotRepresentableException nre) {
            System.err.println("a: " + a2 + "  b: " + b2 + "  c: " + c2);
            System.err.println(nre);
        }
        return cc2;
    }

    public double interpolateZValue(Vertex v0, Vertex v1, Vertex v2) {
        double x0 = v0.getX();
        double y0 = v0.getY();
        double a2 = v1.getX() - x0;
        double b2 = v2.getX() - x0;
        double c2 = v1.getY() - y0;
        double d2 = v2.getY() - y0;
        double det = a2 * d2 - b2 * c2;
        double dx2 = this.getX() - x0;
        double dy2 = this.getY() - y0;
        double t2 = (d2 * dx2 - b2 * dy2) / det;
        double u2 = (-c2 * dx2 + a2 * dy2) / det;
        double z2 = v0.getZ() + t2 * (v1.getZ() - v0.getZ()) + u2 * (v2.getZ() - v0.getZ());
        return z2;
    }

    public static double interpolateZ(Coordinate p2, Coordinate v0, Coordinate v1, Coordinate v2) {
        double x0 = v0.x;
        double y0 = v0.y;
        double a2 = v1.x - x0;
        double b2 = v2.x - x0;
        double c2 = v1.y - y0;
        double d2 = v2.y - y0;
        double det = a2 * d2 - b2 * c2;
        double dx2 = p2.x - x0;
        double dy2 = p2.y - y0;
        double t2 = (d2 * dx2 - b2 * dy2) / det;
        double u2 = (-c2 * dx2 + a2 * dy2) / det;
        double z2 = v0.z + t2 * (v1.z - v0.z) + u2 * (v2.z - v0.z);
        return z2;
    }

    public static double interpolateZ(Coordinate p2, Coordinate p0, Coordinate p1) {
        double segLen = p0.distance(p1);
        double ptLen = p2.distance(p0);
        double dz2 = p1.z - p0.z;
        double pz2 = p0.z + dz2 * (ptLen / segLen);
        return pz2;
    }
}

