/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public class RectangleContains {
    private Envelope rectEnv;

    public static boolean contains(Polygon rectangle, Geometry b2) {
        RectangleContains rc = new RectangleContains(rectangle);
        return rc.contains(b2);
    }

    public RectangleContains(Polygon rectangle) {
        this.rectEnv = rectangle.getEnvelopeInternal();
    }

    public boolean contains(Geometry geom) {
        if (!this.rectEnv.contains(geom.getEnvelopeInternal())) {
            return false;
        }
        return !this.isContainedInBoundary(geom);
    }

    private boolean isContainedInBoundary(Geometry geom) {
        if (geom instanceof Polygon) {
            return false;
        }
        if (geom instanceof Point) {
            return this.isPointContainedInBoundary((Point)geom);
        }
        if (geom instanceof LineString) {
            return this.isLineStringContainedInBoundary((LineString)geom);
        }
        for (int i2 = 0; i2 < geom.getNumGeometries(); ++i2) {
            Geometry comp = geom.getGeometryN(i2);
            if (this.isContainedInBoundary(comp)) continue;
            return false;
        }
        return true;
    }

    private boolean isPointContainedInBoundary(Point point) {
        return this.isPointContainedInBoundary(point.getCoordinate());
    }

    private boolean isPointContainedInBoundary(Coordinate pt2) {
        return pt2.x == this.rectEnv.getMinX() || pt2.x == this.rectEnv.getMaxX() || pt2.y == this.rectEnv.getMinY() || pt2.y == this.rectEnv.getMaxY();
    }

    private boolean isLineStringContainedInBoundary(LineString line) {
        CoordinateSequence seq = line.getCoordinateSequence();
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        for (int i2 = 0; i2 < seq.size() - 1; ++i2) {
            seq.getCoordinate(i2, p0);
            seq.getCoordinate(i2 + 1, p1);
            if (this.isLineSegmentContainedInBoundary(p0, p1)) continue;
            return false;
        }
        return true;
    }

    private boolean isLineSegmentContainedInBoundary(Coordinate p0, Coordinate p1) {
        if (p0.equals(p1)) {
            return this.isPointContainedInBoundary(p0);
        }
        return p0.x == p1.x ? p0.x == this.rectEnv.getMinX() || p0.x == this.rectEnv.getMaxX() : p0.y == p1.y && (p0.y == this.rectEnv.getMinY() || p0.y == this.rectEnv.getMaxY());
    }
}

