/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.polygonize;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.polygonize.EdgeRing;
import com.vividsolutions.jts.operation.polygonize.PolygonizeGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Polygonizer {
    private LineStringAdder lineStringAdder = new LineStringAdder();
    protected PolygonizeGraph graph;
    protected Collection dangles = new ArrayList();
    protected List cutEdges = new ArrayList();
    protected List invalidRingLines = new ArrayList();
    protected List holeList = null;
    protected List shellList = null;
    protected List polyList = null;

    public void add(Collection geomList) {
        for (Geometry geometry : geomList) {
            this.add(geometry);
        }
    }

    public void add(Geometry g2) {
        g2.apply(this.lineStringAdder);
    }

    private void add(LineString line) {
        if (this.graph == null) {
            this.graph = new PolygonizeGraph(line.getFactory());
        }
        this.graph.addEdge(line);
    }

    public Collection getPolygons() {
        this.polygonize();
        return this.polyList;
    }

    public Collection getDangles() {
        this.polygonize();
        return this.dangles;
    }

    public Collection getCutEdges() {
        this.polygonize();
        return this.cutEdges;
    }

    public Collection getInvalidRingLines() {
        this.polygonize();
        return this.invalidRingLines;
    }

    private void polygonize() {
        if (this.polyList != null) {
            return;
        }
        this.polyList = new ArrayList();
        if (this.graph == null) {
            return;
        }
        this.dangles = this.graph.deleteDangles();
        this.cutEdges = this.graph.deleteCutEdges();
        List edgeRingList = this.graph.getEdgeRings();
        ArrayList validEdgeRingList = new ArrayList();
        this.invalidRingLines = new ArrayList();
        this.findValidRings(edgeRingList, validEdgeRingList, this.invalidRingLines);
        this.findShellsAndHoles(validEdgeRingList);
        Polygonizer.assignHolesToShells(this.holeList, this.shellList);
        this.polyList = new ArrayList();
        for (EdgeRing er2 : this.shellList) {
            this.polyList.add(er2.getPolygon());
        }
    }

    private void findValidRings(List edgeRingList, List validEdgeRingList, List invalidRingList) {
        for (EdgeRing er2 : edgeRingList) {
            if (er2.isValid()) {
                validEdgeRingList.add(er2);
                continue;
            }
            invalidRingList.add(er2.getLineString());
        }
    }

    private void findShellsAndHoles(List edgeRingList) {
        this.holeList = new ArrayList();
        this.shellList = new ArrayList();
        for (EdgeRing er2 : edgeRingList) {
            if (er2.isHole()) {
                this.holeList.add(er2);
                continue;
            }
            this.shellList.add(er2);
        }
    }

    private static void assignHolesToShells(List holeList, List shellList) {
        for (EdgeRing holeER : holeList) {
            Polygonizer.assignHoleToShell(holeER, shellList);
        }
    }

    private static void assignHoleToShell(EdgeRing holeER, List shellList) {
        EdgeRing shell = EdgeRing.findEdgeRingContaining(holeER, shellList);
        if (shell != null) {
            shell.addHole(holeER.getRing());
        }
    }

    private class LineStringAdder
    implements GeometryComponentFilter {
        private LineStringAdder() {
        }

        public void filter(Geometry g2) {
            if (g2 instanceof LineString) {
                Polygonizer.this.add((LineString)g2);
            }
        }
    }
}

