/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class LineBuilder {
    private OverlayOp op;
    private GeometryFactory geometryFactory;
    private PointLocator ptLocator;
    private List lineEdgesList = new ArrayList();
    private List resultLineList = new ArrayList();

    public LineBuilder(OverlayOp op2, GeometryFactory geometryFactory, PointLocator ptLocator) {
        this.op = op2;
        this.geometryFactory = geometryFactory;
        this.ptLocator = ptLocator;
    }

    public List build(int opCode) {
        this.findCoveredLineEdges();
        this.collectLines(opCode);
        this.buildLines(opCode);
        return this.resultLineList;
    }

    private void findCoveredLineEdges() {
        for (Node node : this.op.getGraph().getNodes()) {
            ((DirectedEdgeStar)node.getEdges()).findCoveredLineEdges();
        }
        for (DirectedEdge de2 : this.op.getGraph().getEdgeEnds()) {
            Edge e2 = de2.getEdge();
            if (!de2.isLineEdge() || e2.isCoveredSet()) continue;
            boolean isCovered = this.op.isCoveredByA(de2.getCoordinate());
            e2.setCovered(isCovered);
        }
    }

    private void collectLines(int opCode) {
        for (DirectedEdge de2 : this.op.getGraph().getEdgeEnds()) {
            this.collectLineEdge(de2, opCode, this.lineEdgesList);
            this.collectBoundaryTouchEdge(de2, opCode, this.lineEdgesList);
        }
    }

    private void collectLineEdge(DirectedEdge de2, int opCode, List edges) {
        Label label = de2.getLabel();
        Edge e2 = de2.getEdge();
        if (de2.isLineEdge() && !de2.isVisited() && OverlayOp.isResultOfOp(label, opCode) && !e2.isCovered()) {
            edges.add(e2);
            de2.setVisitedEdge(true);
        }
    }

    private void collectBoundaryTouchEdge(DirectedEdge de2, int opCode, List edges) {
        Label label = de2.getLabel();
        if (de2.isLineEdge()) {
            return;
        }
        if (de2.isVisited()) {
            return;
        }
        if (de2.isInteriorAreaEdge()) {
            return;
        }
        if (de2.getEdge().isInResult()) {
            return;
        }
        Assert.isTrue(!de2.isInResult() && !de2.getSym().isInResult() || !de2.getEdge().isInResult());
        if (OverlayOp.isResultOfOp(label, opCode) && opCode == 1) {
            edges.add(de2.getEdge());
            de2.setVisitedEdge(true);
        }
    }

    private void buildLines(int opCode) {
        for (Edge e2 : this.lineEdgesList) {
            Label label = e2.getLabel();
            LineString line = this.geometryFactory.createLineString(e2.getCoordinates());
            this.resultLineList.add(line);
            e2.setInResult(true);
        }
    }

    private void labelIsolatedLines(List edgesList) {
        for (Edge e2 : edgesList) {
            Label label = e2.getLabel();
            if (!e2.isIsolated()) continue;
            if (label.isNull(0)) {
                this.labelIsolatedLine(e2, 0);
                continue;
            }
            this.labelIsolatedLine(e2, 1);
        }
    }

    private void labelIsolatedLine(Edge e2, int targetIndex) {
        int loc = this.ptLocator.locate(e2.getCoordinate(), this.op.getArgGeometry(targetIndex));
        e2.getLabel().setLocation(targetIndex, loc);
    }
}

