/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance3d;

import com.vividsolutions.jts.algorithm.RayCrossingCounter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.math.Plane3D;
import com.vividsolutions.jts.math.Vector3D;
import com.vividsolutions.jts.operation.distance3d.AxisPlaneCoordinateSequence;

public class PlanarPolygon3D {
    private Plane3D plane;
    private Polygon poly;
    private int facingPlane = -1;

    public PlanarPolygon3D(Polygon poly) {
        this.poly = poly;
        this.plane = this.findBestFitPlane(poly);
        this.facingPlane = this.plane.closestAxisPlane();
    }

    private Plane3D findBestFitPlane(Polygon poly) {
        CoordinateSequence seq = poly.getExteriorRing().getCoordinateSequence();
        Coordinate basePt = this.averagePoint(seq);
        Vector3D normal = this.averageNormal(seq);
        return new Plane3D(normal, basePt);
    }

    private Vector3D averageNormal(CoordinateSequence seq) {
        int n2 = seq.size();
        Coordinate sum = new Coordinate(0.0, 0.0, 0.0);
        Coordinate p1 = new Coordinate(0.0, 0.0, 0.0);
        Coordinate p2 = new Coordinate(0.0, 0.0, 0.0);
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            seq.getCoordinate(i2, p1);
            seq.getCoordinate(i2 + 1, p2);
            sum.x += (p1.y - p2.y) * (p1.z + p2.z);
            sum.y += (p1.z - p2.z) * (p1.x + p2.x);
            sum.z += (p1.x - p2.x) * (p1.y + p2.y);
        }
        sum.x /= (double)n2;
        sum.y /= (double)n2;
        sum.z /= (double)n2;
        Vector3D norm = Vector3D.create(sum).normalize();
        return norm;
    }

    private Coordinate averagePoint(CoordinateSequence seq) {
        Coordinate a2 = new Coordinate(0.0, 0.0, 0.0);
        int n2 = seq.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            a2.x += seq.getOrdinate(i2, 0);
            a2.y += seq.getOrdinate(i2, 1);
            a2.z += seq.getOrdinate(i2, 2);
        }
        a2.x /= (double)n2;
        a2.y /= (double)n2;
        a2.z /= (double)n2;
        return a2;
    }

    public Plane3D getPlane() {
        return this.plane;
    }

    public Polygon getPolygon() {
        return this.poly;
    }

    public boolean intersects(Coordinate intPt) {
        if (2 == this.locate(intPt, this.poly.getExteriorRing())) {
            return false;
        }
        for (int i2 = 0; i2 < this.poly.getNumInteriorRing(); ++i2) {
            if (0 != this.locate(intPt, this.poly.getInteriorRingN(i2))) continue;
            return false;
        }
        return true;
    }

    private int locate(Coordinate pt2, LineString ring) {
        CoordinateSequence seq = ring.getCoordinateSequence();
        CoordinateSequence seqProj = PlanarPolygon3D.project(seq, this.facingPlane);
        Coordinate ptProj = PlanarPolygon3D.project(pt2, this.facingPlane);
        return RayCrossingCounter.locatePointInRing(ptProj, seqProj);
    }

    public boolean intersects(Coordinate pt2, LineString ring) {
        CoordinateSequence seq = ring.getCoordinateSequence();
        CoordinateSequence seqProj = PlanarPolygon3D.project(seq, this.facingPlane);
        Coordinate ptProj = PlanarPolygon3D.project(pt2, this.facingPlane);
        return 2 != RayCrossingCounter.locatePointInRing(ptProj, seqProj);
    }

    private static CoordinateSequence project(CoordinateSequence seq, int facingPlane) {
        switch (facingPlane) {
            case 1: {
                return AxisPlaneCoordinateSequence.projectToXY(seq);
            }
            case 3: {
                return AxisPlaneCoordinateSequence.projectToXZ(seq);
            }
        }
        return AxisPlaneCoordinateSequence.projectToYZ(seq);
    }

    private static Coordinate project(Coordinate p2, int facingPlane) {
        switch (facingPlane) {
            case 1: {
                return new Coordinate(p2.x, p2.y);
            }
            case 3: {
                return new Coordinate(p2.x, p2.z);
            }
        }
        return new Coordinate(p2.y, p2.z);
    }
}

