/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.geom.util.PointExtracter;
import com.vividsolutions.jts.geom.util.PolygonExtracter;
import com.vividsolutions.jts.operation.distance.ConnectedElementLocationFilter;
import com.vividsolutions.jts.operation.distance.GeometryLocation;
import java.util.List;

public class DistanceOp {
    private Geometry[] geom;
    private double terminateDistance = 0.0;
    private PointLocator ptLocator = new PointLocator();
    private GeometryLocation[] minDistanceLocation;
    private double minDistance = Double.MAX_VALUE;

    public static double distance(Geometry g0, Geometry g1) {
        DistanceOp distOp = new DistanceOp(g0, g1);
        return distOp.distance();
    }

    public static boolean isWithinDistance(Geometry g0, Geometry g1, double distance) {
        DistanceOp distOp = new DistanceOp(g0, g1, distance);
        return distOp.distance() <= distance;
    }

    public static Coordinate[] nearestPoints(Geometry g0, Geometry g1) {
        DistanceOp distOp = new DistanceOp(g0, g1);
        return distOp.nearestPoints();
    }

    public static Coordinate[] closestPoints(Geometry g0, Geometry g1) {
        DistanceOp distOp = new DistanceOp(g0, g1);
        return distOp.nearestPoints();
    }

    public DistanceOp(Geometry g0, Geometry g1) {
        this(g0, g1, 0.0);
    }

    public DistanceOp(Geometry g0, Geometry g1, double terminateDistance) {
        this.geom = new Geometry[2];
        this.geom[0] = g0;
        this.geom[1] = g1;
        this.terminateDistance = terminateDistance;
    }

    public double distance() {
        if (this.geom[0] == null || this.geom[1] == null) {
            throw new IllegalArgumentException("null geometries are not supported");
        }
        if (this.geom[0].isEmpty() || this.geom[1].isEmpty()) {
            return 0.0;
        }
        this.computeMinDistance();
        return this.minDistance;
    }

    public Coordinate[] nearestPoints() {
        this.computeMinDistance();
        Coordinate[] nearestPts = new Coordinate[]{this.minDistanceLocation[0].getCoordinate(), this.minDistanceLocation[1].getCoordinate()};
        return nearestPts;
    }

    public Coordinate[] closestPoints() {
        return this.nearestPoints();
    }

    public GeometryLocation[] nearestLocations() {
        this.computeMinDistance();
        return this.minDistanceLocation;
    }

    public GeometryLocation[] closestLocations() {
        return this.nearestLocations();
    }

    private void updateMinDistance(GeometryLocation[] locGeom, boolean flip) {
        if (locGeom[0] == null) {
            return;
        }
        if (flip) {
            this.minDistanceLocation[0] = locGeom[1];
            this.minDistanceLocation[1] = locGeom[0];
        } else {
            this.minDistanceLocation[0] = locGeom[0];
            this.minDistanceLocation[1] = locGeom[1];
        }
    }

    private void computeMinDistance() {
        if (this.minDistanceLocation != null) {
            return;
        }
        this.minDistanceLocation = new GeometryLocation[2];
        this.computeContainmentDistance();
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        this.computeFacetDistance();
    }

    private void computeContainmentDistance() {
        GeometryLocation[] locPtPoly = new GeometryLocation[2];
        this.computeContainmentDistance(0, locPtPoly);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        this.computeContainmentDistance(1, locPtPoly);
    }

    private void computeContainmentDistance(int polyGeomIndex, GeometryLocation[] locPtPoly) {
        int locationsIndex = 1 - polyGeomIndex;
        List polys = PolygonExtracter.getPolygons(this.geom[polyGeomIndex]);
        if (polys.size() > 0) {
            List insideLocs = ConnectedElementLocationFilter.getLocations(this.geom[locationsIndex]);
            this.computeContainmentDistance(insideLocs, polys, locPtPoly);
            if (this.minDistance <= this.terminateDistance) {
                this.minDistanceLocation[locationsIndex] = locPtPoly[0];
                this.minDistanceLocation[polyGeomIndex] = locPtPoly[1];
                return;
            }
        }
    }

    private void computeContainmentDistance(List locs, List polys, GeometryLocation[] locPtPoly) {
        for (int i2 = 0; i2 < locs.size(); ++i2) {
            GeometryLocation loc = (GeometryLocation)locs.get(i2);
            for (int j2 = 0; j2 < polys.size(); ++j2) {
                this.computeContainmentDistance(loc, (Polygon)polys.get(j2), locPtPoly);
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private void computeContainmentDistance(GeometryLocation ptLoc, Polygon poly, GeometryLocation[] locPtPoly) {
        Coordinate pt2 = ptLoc.getCoordinate();
        if (2 != this.ptLocator.locate(pt2, (Geometry)poly)) {
            this.minDistance = 0.0;
            locPtPoly[0] = ptLoc;
            locPtPoly[1] = new GeometryLocation(poly, pt2);
            return;
        }
    }

    private void computeFacetDistance() {
        GeometryLocation[] locGeom = new GeometryLocation[2];
        List lines0 = LinearComponentExtracter.getLines(this.geom[0]);
        List lines1 = LinearComponentExtracter.getLines(this.geom[1]);
        List pts0 = PointExtracter.getPoints(this.geom[0]);
        List pts1 = PointExtracter.getPoints(this.geom[1]);
        this.computeMinDistanceLines(lines0, lines1, locGeom);
        this.updateMinDistance(locGeom, false);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        locGeom[0] = null;
        locGeom[1] = null;
        this.computeMinDistanceLinesPoints(lines0, pts1, locGeom);
        this.updateMinDistance(locGeom, false);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        locGeom[0] = null;
        locGeom[1] = null;
        this.computeMinDistanceLinesPoints(lines1, pts0, locGeom);
        this.updateMinDistance(locGeom, true);
        if (this.minDistance <= this.terminateDistance) {
            return;
        }
        locGeom[0] = null;
        locGeom[1] = null;
        this.computeMinDistancePoints(pts0, pts1, locGeom);
        this.updateMinDistance(locGeom, false);
    }

    private void computeMinDistanceLines(List lines0, List lines1, GeometryLocation[] locGeom) {
        for (int i2 = 0; i2 < lines0.size(); ++i2) {
            LineString line0 = (LineString)lines0.get(i2);
            for (int j2 = 0; j2 < lines1.size(); ++j2) {
                LineString line1 = (LineString)lines1.get(j2);
                this.computeMinDistance(line0, line1, locGeom);
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private void computeMinDistancePoints(List points0, List points1, GeometryLocation[] locGeom) {
        for (int i2 = 0; i2 < points0.size(); ++i2) {
            Point pt0 = (Point)points0.get(i2);
            for (int j2 = 0; j2 < points1.size(); ++j2) {
                Point pt1 = (Point)points1.get(j2);
                double dist = pt0.getCoordinate().distance(pt1.getCoordinate());
                if (dist < this.minDistance) {
                    this.minDistance = dist;
                    locGeom[0] = new GeometryLocation(pt0, 0, pt0.getCoordinate());
                    locGeom[1] = new GeometryLocation(pt1, 0, pt1.getCoordinate());
                }
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private void computeMinDistanceLinesPoints(List lines, List points, GeometryLocation[] locGeom) {
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            LineString line = (LineString)lines.get(i2);
            for (int j2 = 0; j2 < points.size(); ++j2) {
                Point pt2 = (Point)points.get(j2);
                this.computeMinDistance(line, pt2, locGeom);
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private void computeMinDistance(LineString line0, LineString line1, GeometryLocation[] locGeom) {
        if (line0.getEnvelopeInternal().distance(line1.getEnvelopeInternal()) > this.minDistance) {
            return;
        }
        Coordinate[] coord0 = line0.getCoordinates();
        Coordinate[] coord1 = line1.getCoordinates();
        for (int i2 = 0; i2 < coord0.length - 1; ++i2) {
            for (int j2 = 0; j2 < coord1.length - 1; ++j2) {
                double dist = CGAlgorithms.distanceLineLine(coord0[i2], coord0[i2 + 1], coord1[j2], coord1[j2 + 1]);
                if (dist < this.minDistance) {
                    this.minDistance = dist;
                    LineSegment seg0 = new LineSegment(coord0[i2], coord0[i2 + 1]);
                    LineSegment seg1 = new LineSegment(coord1[j2], coord1[j2 + 1]);
                    Coordinate[] closestPt = seg0.closestPoints(seg1);
                    locGeom[0] = new GeometryLocation(line0, i2, closestPt[0]);
                    locGeom[1] = new GeometryLocation(line1, j2, closestPt[1]);
                }
                if (!(this.minDistance <= this.terminateDistance)) continue;
                return;
            }
        }
    }

    private void computeMinDistance(LineString line, Point pt2, GeometryLocation[] locGeom) {
        if (line.getEnvelopeInternal().distance(pt2.getEnvelopeInternal()) > this.minDistance) {
            return;
        }
        Coordinate[] coord0 = line.getCoordinates();
        Coordinate coord = pt2.getCoordinate();
        for (int i2 = 0; i2 < coord0.length - 1; ++i2) {
            double dist = CGAlgorithms.distancePointLine(coord, coord0[i2], coord0[i2 + 1]);
            if (dist < this.minDistance) {
                this.minDistance = dist;
                LineSegment seg = new LineSegment(coord0[i2], coord0[i2 + 1]);
                Coordinate segClosestPoint = seg.closestPoint(coord);
                locGeom[0] = new GeometryLocation(line, i2, segClosestPoint);
                locGeom[1] = new GeometryLocation(pt2, 0, coord);
            }
            if (!(this.minDistance <= this.terminateDistance)) continue;
            return;
        }
    }
}

