/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.operation.buffer.RightmostEdgeFinder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class BufferSubgraph
implements Comparable {
    private RightmostEdgeFinder finder;
    private List dirEdgeList = new ArrayList();
    private List nodes = new ArrayList();
    private Coordinate rightMostCoord = null;
    private Envelope env = null;

    public BufferSubgraph() {
        this.finder = new RightmostEdgeFinder();
    }

    public List getDirectedEdges() {
        return this.dirEdgeList;
    }

    public List getNodes() {
        return this.nodes;
    }

    public Envelope getEnvelope() {
        if (this.env == null) {
            Envelope edgeEnv = new Envelope();
            for (DirectedEdge dirEdge : this.dirEdgeList) {
                Coordinate[] pts = dirEdge.getEdge().getCoordinates();
                for (int i2 = 0; i2 < pts.length - 1; ++i2) {
                    edgeEnv.expandToInclude(pts[i2]);
                }
            }
            this.env = edgeEnv;
        }
        return this.env;
    }

    public Coordinate getRightmostCoordinate() {
        return this.rightMostCoord;
    }

    public void create(Node node) {
        this.addReachable(node);
        this.finder.findEdge(this.dirEdgeList);
        this.rightMostCoord = this.finder.getCoordinate();
    }

    private void addReachable(Node startNode) {
        Stack<Node> nodeStack = new Stack<Node>();
        nodeStack.add(startNode);
        while (!nodeStack.empty()) {
            Node node = (Node)nodeStack.pop();
            this.add(node, nodeStack);
        }
    }

    private void add(Node node, Stack nodeStack) {
        node.setVisited(true);
        this.nodes.add(node);
        Iterator i2 = ((DirectedEdgeStar)node.getEdges()).iterator();
        while (i2.hasNext()) {
            DirectedEdge de2 = (DirectedEdge)i2.next();
            this.dirEdgeList.add(de2);
            DirectedEdge sym = de2.getSym();
            Node symNode = sym.getNode();
            if (symNode.isVisited()) continue;
            nodeStack.push(symNode);
        }
    }

    private void clearVisitedEdges() {
        for (DirectedEdge de2 : this.dirEdgeList) {
            de2.setVisited(false);
        }
    }

    public void computeDepth(int outsideDepth) {
        this.clearVisitedEdges();
        DirectedEdge de2 = this.finder.getEdge();
        Node n2 = de2.getNode();
        Label label = de2.getLabel();
        de2.setEdgeDepths(2, outsideDepth);
        this.copySymDepths(de2);
        this.computeDepths(de2);
    }

    private void computeDepths(DirectedEdge startEdge) {
        HashSet<Node> nodesVisited = new HashSet<Node>();
        LinkedList<Node> nodeQueue = new LinkedList<Node>();
        Node startNode = startEdge.getNode();
        nodeQueue.addLast(startNode);
        nodesVisited.add(startNode);
        startEdge.setVisited(true);
        while (!nodeQueue.isEmpty()) {
            Node n2 = (Node)nodeQueue.removeFirst();
            nodesVisited.add(n2);
            this.computeNodeDepth(n2);
            Iterator i2 = ((DirectedEdgeStar)n2.getEdges()).iterator();
            while (i2.hasNext()) {
                Node adjNode;
                DirectedEdge de2 = (DirectedEdge)i2.next();
                DirectedEdge sym = de2.getSym();
                if (sym.isVisited() || nodesVisited.contains(adjNode = sym.getNode())) continue;
                nodeQueue.addLast(adjNode);
                nodesVisited.add(adjNode);
            }
        }
    }

    private void computeNodeDepth(Node n2) {
        DirectedEdge de2;
        DirectedEdge startEdge = null;
        Iterator i2 = ((DirectedEdgeStar)n2.getEdges()).iterator();
        while (i2.hasNext()) {
            de2 = (DirectedEdge)i2.next();
            if (!de2.isVisited() && !de2.getSym().isVisited()) continue;
            startEdge = de2;
            break;
        }
        if (startEdge == null) {
            throw new TopologyException("unable to find edge to compute depths at " + n2.getCoordinate());
        }
        ((DirectedEdgeStar)n2.getEdges()).computeDepths(startEdge);
        i2 = ((DirectedEdgeStar)n2.getEdges()).iterator();
        while (i2.hasNext()) {
            de2 = (DirectedEdge)i2.next();
            de2.setVisited(true);
            this.copySymDepths(de2);
        }
    }

    private void copySymDepths(DirectedEdge de2) {
        DirectedEdge sym = de2.getSym();
        sym.setDepth(1, de2.getDepth(2));
        sym.setDepth(2, de2.getDepth(1));
    }

    public void findResultEdges() {
        for (DirectedEdge de2 : this.dirEdgeList) {
            if (de2.getDepth(2) < 1 || de2.getDepth(1) > 0 || de2.isInteriorAreaEdge()) continue;
            de2.setInResult(true);
        }
    }

    public int compareTo(Object o2) {
        BufferSubgraph graph = (BufferSubgraph)o2;
        if (this.rightMostCoord.x < graph.rightMostCoord.x) {
            return -1;
        }
        if (this.rightMostCoord.x > graph.rightMostCoord.x) {
            return 1;
        }
        return 0;
    }
}

