/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.geom.Coordinate;

public class Octant {
    public static int octant(double dx2, double dy2) {
        if (dx2 == 0.0 && dy2 == 0.0) {
            throw new IllegalArgumentException("Cannot compute the octant for point ( " + dx2 + ", " + dy2 + " )");
        }
        double adx = Math.abs(dx2);
        double ady = Math.abs(dy2);
        if (dx2 >= 0.0) {
            if (dy2 >= 0.0) {
                if (adx >= ady) {
                    return 0;
                }
                return 1;
            }
            if (adx >= ady) {
                return 7;
            }
            return 6;
        }
        if (dy2 >= 0.0) {
            if (adx >= ady) {
                return 3;
            }
            return 2;
        }
        if (adx >= ady) {
            return 4;
        }
        return 5;
    }

    public static int octant(Coordinate p0, Coordinate p1) {
        double dx2 = p1.x - p0.x;
        double dy2 = p1.y - p0.y;
        if (dx2 == 0.0 && dy2 == 0.0) {
            throw new IllegalArgumentException("Cannot compute the octant for two identical points " + p0);
        }
        return Octant.octant(dx2, dy2);
    }

    private Octant() {
    }
}

