/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ByteArrayInStream;
import com.vividsolutions.jts.io.ByteOrderDataInStream;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;

public class WKBReader {
    private static final String INVALID_GEOM_TYPE_MSG = "Invalid geometry type encountered in ";
    private GeometryFactory factory;
    private CoordinateSequenceFactory csFactory;
    private PrecisionModel precisionModel;
    private int inputDimension = 2;
    private boolean hasSRID = false;
    private int SRID = 0;
    private boolean isStrict = false;
    private ByteOrderDataInStream dis = new ByteOrderDataInStream();
    private double[] ordValues;

    public static byte[] hexToBytes(String hex) {
        int byteLen = hex.length() / 2;
        byte[] bytes = new byte[byteLen];
        for (int i2 = 0; i2 < hex.length() / 2; ++i2) {
            byte b2;
            int i22 = 2 * i2;
            if (i22 + 1 > hex.length()) {
                throw new IllegalArgumentException("Hex string has odd length");
            }
            int nib1 = WKBReader.hexToInt(hex.charAt(i22));
            int nib0 = WKBReader.hexToInt(hex.charAt(i22 + 1));
            bytes[i2] = b2 = (byte)((nib1 << 4) + (byte)nib0);
        }
        return bytes;
    }

    private static int hexToInt(char hex) {
        int nib = Character.digit(hex, 16);
        if (nib < 0) {
            throw new IllegalArgumentException("Invalid hex digit: '" + hex + "'");
        }
        return nib;
    }

    public WKBReader() {
        this(new GeometryFactory());
    }

    public WKBReader(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
        this.precisionModel = this.factory.getPrecisionModel();
        this.csFactory = this.factory.getCoordinateSequenceFactory();
    }

    public Geometry read(byte[] bytes) throws ParseException {
        try {
            return this.read(new ByteArrayInStream(bytes));
        }
        catch (IOException ex2) {
            throw new RuntimeException("Unexpected IOException caught: " + ex2.getMessage());
        }
    }

    public Geometry read(InStream is2) throws IOException, ParseException {
        this.dis.setInStream(is2);
        Geometry g2 = this.readGeometry();
        return g2;
    }

    private Geometry readGeometry() throws IOException, ParseException {
        byte byteOrderWKB = this.dis.readByte();
        int byteOrder = byteOrderWKB == 1 ? 2 : 1;
        this.dis.setOrder(byteOrder);
        int typeInt = this.dis.readInt();
        int geometryType = typeInt & 0xFF;
        boolean hasZ = (typeInt & Integer.MIN_VALUE) != 0;
        this.inputDimension = hasZ ? 3 : 2;
        this.hasSRID = (typeInt & 0x20000000) != 0;
        int SRID = 0;
        if (this.hasSRID) {
            SRID = this.dis.readInt();
        }
        if (this.ordValues == null || this.ordValues.length < this.inputDimension) {
            this.ordValues = new double[this.inputDimension];
        }
        Geometry geom = null;
        switch (geometryType) {
            case 1: {
                geom = this.readPoint();
                break;
            }
            case 2: {
                geom = this.readLineString();
                break;
            }
            case 3: {
                geom = this.readPolygon();
                break;
            }
            case 4: {
                geom = this.readMultiPoint();
                break;
            }
            case 5: {
                geom = this.readMultiLineString();
                break;
            }
            case 6: {
                geom = this.readMultiPolygon();
                break;
            }
            case 7: {
                geom = this.readGeometryCollection();
                break;
            }
            default: {
                throw new ParseException("Unknown WKB type " + geometryType);
            }
        }
        this.setSRID(geom, SRID);
        return geom;
    }

    private Geometry setSRID(Geometry g2, int SRID) {
        if (SRID != 0) {
            g2.setSRID(SRID);
        }
        return g2;
    }

    private Point readPoint() throws IOException {
        CoordinateSequence pts = this.readCoordinateSequence(1);
        return this.factory.createPoint(pts);
    }

    private LineString readLineString() throws IOException {
        int size = this.dis.readInt();
        CoordinateSequence pts = this.readCoordinateSequenceLineString(size);
        return this.factory.createLineString(pts);
    }

    private LinearRing readLinearRing() throws IOException {
        int size = this.dis.readInt();
        CoordinateSequence pts = this.readCoordinateSequenceRing(size);
        return this.factory.createLinearRing(pts);
    }

    private Polygon readPolygon() throws IOException {
        int numRings = this.dis.readInt();
        LinearRing[] holes = null;
        if (numRings > 1) {
            holes = new LinearRing[numRings - 1];
        }
        LinearRing shell = this.readLinearRing();
        for (int i2 = 0; i2 < numRings - 1; ++i2) {
            holes[i2] = this.readLinearRing();
        }
        return this.factory.createPolygon(shell, holes);
    }

    private MultiPoint readMultiPoint() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Point[] geoms = new Point[numGeom];
        for (int i2 = 0; i2 < numGeom; ++i2) {
            Geometry g2 = this.readGeometry();
            if (!(g2 instanceof Point)) {
                throw new ParseException("Invalid geometry type encountered in MultiPoint");
            }
            geoms[i2] = (Point)g2;
        }
        return this.factory.createMultiPoint(geoms);
    }

    private MultiLineString readMultiLineString() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        LineString[] geoms = new LineString[numGeom];
        for (int i2 = 0; i2 < numGeom; ++i2) {
            Geometry g2 = this.readGeometry();
            if (!(g2 instanceof LineString)) {
                throw new ParseException("Invalid geometry type encountered in MultiLineString");
            }
            geoms[i2] = (LineString)g2;
        }
        return this.factory.createMultiLineString(geoms);
    }

    private MultiPolygon readMultiPolygon() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Polygon[] geoms = new Polygon[numGeom];
        for (int i2 = 0; i2 < numGeom; ++i2) {
            Geometry g2 = this.readGeometry();
            if (!(g2 instanceof Polygon)) {
                throw new ParseException("Invalid geometry type encountered in MultiPolygon");
            }
            geoms[i2] = (Polygon)g2;
        }
        return this.factory.createMultiPolygon(geoms);
    }

    private GeometryCollection readGeometryCollection() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Geometry[] geoms = new Geometry[numGeom];
        for (int i2 = 0; i2 < numGeom; ++i2) {
            geoms[i2] = this.readGeometry();
        }
        return this.factory.createGeometryCollection(geoms);
    }

    private CoordinateSequence readCoordinateSequence(int size) throws IOException {
        CoordinateSequence seq = this.csFactory.create(size, this.inputDimension);
        int targetDim = seq.getDimension();
        if (targetDim > this.inputDimension) {
            targetDim = this.inputDimension;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            this.readCoordinate();
            for (int j2 = 0; j2 < targetDim; ++j2) {
                seq.setOrdinate(i2, j2, this.ordValues[j2]);
            }
        }
        return seq;
    }

    private CoordinateSequence readCoordinateSequenceLineString(int size) throws IOException {
        CoordinateSequence seq = this.readCoordinateSequence(size);
        if (this.isStrict) {
            return seq;
        }
        if (seq.size() == 0 || seq.size() >= 2) {
            return seq;
        }
        return CoordinateSequences.extend(this.csFactory, seq, 2);
    }

    private CoordinateSequence readCoordinateSequenceRing(int size) throws IOException {
        CoordinateSequence seq = this.readCoordinateSequence(size);
        if (this.isStrict) {
            return seq;
        }
        if (CoordinateSequences.isRing(seq)) {
            return seq;
        }
        return CoordinateSequences.ensureValidRing(this.csFactory, seq);
    }

    private void readCoordinate() throws IOException {
        for (int i2 = 0; i2 < this.inputDimension; ++i2) {
            this.ordValues[i2] = i2 <= 1 ? this.precisionModel.makePrecise(this.dis.readDouble()) : this.dis.readDouble();
        }
    }
}

