/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeEndStar;
import com.vividsolutions.jts.geomgraph.EdgeRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Quadrant;
import com.vividsolutions.jts.util.Assert;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DirectedEdgeStar
extends EdgeEndStar {
    private List resultAreaEdgeList;
    private Label label;
    private final int SCANNING_FOR_INCOMING = 1;
    private final int LINKING_TO_OUTGOING = 2;

    public void insert(EdgeEnd ee2) {
        DirectedEdge de2 = (DirectedEdge)ee2;
        this.insertEdgeEnd(de2, de2);
    }

    public Label getLabel() {
        return this.label;
    }

    public int getOutgoingDegree() {
        int degree = 0;
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            DirectedEdge de2 = (DirectedEdge)it2.next();
            if (!de2.isInResult()) continue;
            ++degree;
        }
        return degree;
    }

    public int getOutgoingDegree(EdgeRing er2) {
        int degree = 0;
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            DirectedEdge de2 = (DirectedEdge)it2.next();
            if (de2.getEdgeRing() != er2) continue;
            ++degree;
        }
        return degree;
    }

    public DirectedEdge getRightmostEdge() {
        List edges = this.getEdges();
        int size = edges.size();
        if (size < 1) {
            return null;
        }
        DirectedEdge de0 = (DirectedEdge)edges.get(0);
        if (size == 1) {
            return de0;
        }
        DirectedEdge deLast = (DirectedEdge)edges.get(size - 1);
        int quad0 = de0.getQuadrant();
        int quad1 = deLast.getQuadrant();
        if (Quadrant.isNorthern(quad0) && Quadrant.isNorthern(quad1)) {
            return de0;
        }
        if (!Quadrant.isNorthern(quad0) && !Quadrant.isNorthern(quad1)) {
            return deLast;
        }
        Object nonHorizontalEdge = null;
        if (de0.getDy() != 0.0) {
            return de0;
        }
        if (deLast.getDy() != 0.0) {
            return deLast;
        }
        Assert.shouldNeverReachHere("found two horizontal edges incident on node");
        return null;
    }

    public void computeLabelling(GeometryGraph[] geom) {
        super.computeLabelling(geom);
        this.label = new Label(-1);
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            EdgeEnd ee2 = (EdgeEnd)it2.next();
            Edge e2 = ee2.getEdge();
            Label eLabel = e2.getLabel();
            for (int i2 = 0; i2 < 2; ++i2) {
                int eLoc = eLabel.getLocation(i2);
                if (eLoc != 0 && eLoc != 1) continue;
                this.label.setLocation(i2, 0);
            }
        }
    }

    public void mergeSymLabels() {
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            DirectedEdge de2 = (DirectedEdge)it2.next();
            Label label = de2.getLabel();
            label.merge(de2.getSym().getLabel());
        }
    }

    public void updateLabelling(Label nodeLabel) {
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            DirectedEdge de2 = (DirectedEdge)it2.next();
            Label label = de2.getLabel();
            label.setAllLocationsIfNull(0, nodeLabel.getLocation(0));
            label.setAllLocationsIfNull(1, nodeLabel.getLocation(1));
        }
    }

    private List getResultAreaEdges() {
        if (this.resultAreaEdgeList != null) {
            return this.resultAreaEdgeList;
        }
        this.resultAreaEdgeList = new ArrayList();
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            DirectedEdge de2 = (DirectedEdge)it2.next();
            if (!de2.isInResult() && !de2.getSym().isInResult()) continue;
            this.resultAreaEdgeList.add(de2);
        }
        return this.resultAreaEdgeList;
    }

    public void linkResultDirectedEdges() {
        this.getResultAreaEdges();
        DirectedEdge firstOut = null;
        DirectedEdge incoming = null;
        int state = 1;
        block4: for (int i2 = 0; i2 < this.resultAreaEdgeList.size(); ++i2) {
            DirectedEdge nextOut = (DirectedEdge)this.resultAreaEdgeList.get(i2);
            DirectedEdge nextIn = nextOut.getSym();
            if (!nextOut.getLabel().isArea()) continue;
            if (firstOut == null && nextOut.isInResult()) {
                firstOut = nextOut;
            }
            switch (state) {
                case 1: {
                    if (!nextIn.isInResult()) continue block4;
                    incoming = nextIn;
                    state = 2;
                    continue block4;
                }
                case 2: {
                    if (!nextOut.isInResult()) continue block4;
                    incoming.setNext(nextOut);
                    state = 1;
                }
            }
        }
        if (state == 2) {
            if (firstOut == null) {
                throw new TopologyException("no outgoing dirEdge found", this.getCoordinate());
            }
            Assert.isTrue(firstOut.isInResult(), "unable to link last incoming dirEdge");
            incoming.setNext(firstOut);
        }
    }

    public void linkMinimalDirectedEdges(EdgeRing er2) {
        DirectedEdge firstOut = null;
        DirectedEdge incoming = null;
        int state = 1;
        block4: for (int i2 = this.resultAreaEdgeList.size() - 1; i2 >= 0; --i2) {
            DirectedEdge nextOut = (DirectedEdge)this.resultAreaEdgeList.get(i2);
            DirectedEdge nextIn = nextOut.getSym();
            if (firstOut == null && nextOut.getEdgeRing() == er2) {
                firstOut = nextOut;
            }
            switch (state) {
                case 1: {
                    if (nextIn.getEdgeRing() != er2) continue block4;
                    incoming = nextIn;
                    state = 2;
                    continue block4;
                }
                case 2: {
                    if (nextOut.getEdgeRing() != er2) continue block4;
                    incoming.setNextMin(nextOut);
                    state = 1;
                }
            }
        }
        if (state == 2) {
            Assert.isTrue(firstOut != null, "found null for first outgoing dirEdge");
            Assert.isTrue(firstOut.getEdgeRing() == er2, "unable to link last incoming dirEdge");
            incoming.setNextMin(firstOut);
        }
    }

    public void linkAllDirectedEdges() {
        this.getEdges();
        DirectedEdge prevOut = null;
        DirectedEdge firstIn = null;
        for (int i2 = this.edgeList.size() - 1; i2 >= 0; --i2) {
            DirectedEdge nextOut = (DirectedEdge)this.edgeList.get(i2);
            DirectedEdge nextIn = nextOut.getSym();
            if (firstIn == null) {
                firstIn = nextIn;
            }
            if (prevOut != null) {
                nextIn.setNext(prevOut);
            }
            prevOut = nextOut;
        }
        firstIn.setNext(prevOut);
    }

    public void findCoveredLineEdges() {
        int startLoc = -1;
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            DirectedEdge nextOut = (DirectedEdge)it2.next();
            DirectedEdge nextIn = nextOut.getSym();
            if (nextOut.isLineEdge()) continue;
            if (nextOut.isInResult()) {
                startLoc = 0;
                break;
            }
            if (!nextIn.isInResult()) continue;
            startLoc = 2;
            break;
        }
        if (startLoc == -1) {
            return;
        }
        int currLoc = startLoc;
        Iterator it3 = this.iterator();
        while (it3.hasNext()) {
            DirectedEdge nextOut = (DirectedEdge)it3.next();
            DirectedEdge nextIn = nextOut.getSym();
            if (nextOut.isLineEdge()) {
                nextOut.getEdge().setCovered(currLoc == 0);
                continue;
            }
            if (nextOut.isInResult()) {
                currLoc = 2;
            }
            if (!nextIn.isInResult()) continue;
            currLoc = 0;
        }
    }

    public void computeDepths(DirectedEdge de2) {
        int edgeIndex = this.findIndex(de2);
        Label label = de2.getLabel();
        int startDepth = de2.getDepth(1);
        int targetLastDepth = de2.getDepth(2);
        int nextDepth = this.computeDepths(edgeIndex + 1, this.edgeList.size(), startDepth);
        int lastDepth = this.computeDepths(0, edgeIndex, nextDepth);
        if (lastDepth != targetLastDepth) {
            throw new TopologyException("depth mismatch at " + de2.getCoordinate());
        }
    }

    private int computeDepths(int startIndex, int endIndex, int startDepth) {
        int currDepth = startDepth;
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            DirectedEdge nextDe = (DirectedEdge)this.edgeList.get(i2);
            Label label = nextDe.getLabel();
            nextDe.setEdgeDepths(2, currDepth);
            currDepth = nextDe.getDepth(1);
        }
        return currDepth;
    }

    public void print(PrintStream out) {
        System.out.println("DirectedEdgeStar: " + this.getCoordinate());
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            DirectedEdge de2 = (DirectedEdge)it2.next();
            out.print("out ");
            de2.print(out);
            out.println();
            out.print("in ");
            de2.getSym().print(out);
            out.println();
        }
    }
}

