/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.HCoordinate;
import com.vividsolutions.jts.algorithm.NotRepresentableException;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.io.Serializable;

public class LineSegment
implements Comparable,
Serializable {
    private static final long serialVersionUID = 3252005833466256227L;
    public Coordinate p0;
    public Coordinate p1;

    public LineSegment(Coordinate p0, Coordinate p1) {
        this.p0 = p0;
        this.p1 = p1;
    }

    public LineSegment(double x0, double y0, double x1, double y1) {
        this(new Coordinate(x0, y0), new Coordinate(x1, y1));
    }

    public LineSegment(LineSegment ls2) {
        this(ls2.p0, ls2.p1);
    }

    public LineSegment() {
        this(new Coordinate(), new Coordinate());
    }

    public Coordinate getCoordinate(int i2) {
        if (i2 == 0) {
            return this.p0;
        }
        return this.p1;
    }

    public void setCoordinates(LineSegment ls2) {
        this.setCoordinates(ls2.p0, ls2.p1);
    }

    public void setCoordinates(Coordinate p0, Coordinate p1) {
        this.p0.x = p0.x;
        this.p0.y = p0.y;
        this.p1.x = p1.x;
        this.p1.y = p1.y;
    }

    public double getLength() {
        return this.p0.distance(this.p1);
    }

    public boolean isHorizontal() {
        return this.p0.y == this.p1.y;
    }

    public boolean isVertical() {
        return this.p0.x == this.p1.x;
    }

    public int orientationIndex(LineSegment seg) {
        int orient0 = CGAlgorithms.orientationIndex(this.p0, this.p1, seg.p0);
        int orient1 = CGAlgorithms.orientationIndex(this.p0, this.p1, seg.p1);
        if (orient0 >= 0 && orient1 >= 0) {
            return Math.max(orient0, orient1);
        }
        if (orient0 <= 0 && orient1 <= 0) {
            return Math.max(orient0, orient1);
        }
        return 0;
    }

    public int orientationIndex(Coordinate p2) {
        return CGAlgorithms.orientationIndex(this.p0, this.p1, p2);
    }

    public void reverse() {
        Coordinate temp = this.p0;
        this.p0 = this.p1;
        this.p1 = temp;
    }

    public void normalize() {
        if (this.p1.compareTo(this.p0) < 0) {
            this.reverse();
        }
    }

    public double angle() {
        return Math.atan2(this.p1.y - this.p0.y, this.p1.x - this.p0.x);
    }

    public Coordinate midPoint() {
        return LineSegment.midPoint(this.p0, this.p1);
    }

    public static Coordinate midPoint(Coordinate p0, Coordinate p1) {
        return new Coordinate((p0.x + p1.x) / 2.0, (p0.y + p1.y) / 2.0);
    }

    public double distance(LineSegment ls2) {
        return CGAlgorithms.distanceLineLine(this.p0, this.p1, ls2.p0, ls2.p1);
    }

    public double distance(Coordinate p2) {
        return CGAlgorithms.distancePointLine(p2, this.p0, this.p1);
    }

    public double distancePerpendicular(Coordinate p2) {
        return CGAlgorithms.distancePointLinePerpendicular(p2, this.p0, this.p1);
    }

    public Coordinate pointAlong(double segmentLengthFraction) {
        Coordinate coord = new Coordinate();
        coord.x = this.p0.x + segmentLengthFraction * (this.p1.x - this.p0.x);
        coord.y = this.p0.y + segmentLengthFraction * (this.p1.y - this.p0.y);
        return coord;
    }

    public Coordinate pointAlongOffset(double segmentLengthFraction, double offsetDistance) {
        double segx = this.p0.x + segmentLengthFraction * (this.p1.x - this.p0.x);
        double segy = this.p0.y + segmentLengthFraction * (this.p1.y - this.p0.y);
        double dx2 = this.p1.x - this.p0.x;
        double dy2 = this.p1.y - this.p0.y;
        double len = Math.sqrt(dx2 * dx2 + dy2 * dy2);
        double ux = 0.0;
        double uy = 0.0;
        if (offsetDistance != 0.0) {
            if (len <= 0.0) {
                throw new IllegalStateException("Cannot compute offset from zero-length line segment");
            }
            ux = offsetDistance * dx2 / len;
            uy = offsetDistance * dy2 / len;
        }
        double offsetx = segx - uy;
        double offsety = segy + ux;
        Coordinate coord = new Coordinate(offsetx, offsety);
        return coord;
    }

    public double projectionFactor(Coordinate p2) {
        if (p2.equals(this.p0)) {
            return 0.0;
        }
        if (p2.equals(this.p1)) {
            return 1.0;
        }
        double dx2 = this.p1.x - this.p0.x;
        double dy2 = this.p1.y - this.p0.y;
        double len = dx2 * dx2 + dy2 * dy2;
        if (len <= 0.0) {
            return Double.NaN;
        }
        double r2 = ((p2.x - this.p0.x) * dx2 + (p2.y - this.p0.y) * dy2) / len;
        return r2;
    }

    public double segmentFraction(Coordinate inputPt) {
        double segFrac = this.projectionFactor(inputPt);
        if (segFrac < 0.0) {
            segFrac = 0.0;
        } else if (segFrac > 1.0 || Double.isNaN(segFrac)) {
            segFrac = 1.0;
        }
        return segFrac;
    }

    public Coordinate project(Coordinate p2) {
        if (p2.equals(this.p0) || p2.equals(this.p1)) {
            return new Coordinate(p2);
        }
        double r2 = this.projectionFactor(p2);
        Coordinate coord = new Coordinate();
        coord.x = this.p0.x + r2 * (this.p1.x - this.p0.x);
        coord.y = this.p0.y + r2 * (this.p1.y - this.p0.y);
        return coord;
    }

    public LineSegment project(LineSegment seg) {
        double pf0 = this.projectionFactor(seg.p0);
        double pf1 = this.projectionFactor(seg.p1);
        if (pf0 >= 1.0 && pf1 >= 1.0) {
            return null;
        }
        if (pf0 <= 0.0 && pf1 <= 0.0) {
            return null;
        }
        Coordinate newp0 = this.project(seg.p0);
        if (pf0 < 0.0) {
            newp0 = this.p0;
        }
        if (pf0 > 1.0) {
            newp0 = this.p1;
        }
        Coordinate newp1 = this.project(seg.p1);
        if (pf1 < 0.0) {
            newp1 = this.p0;
        }
        if (pf1 > 1.0) {
            newp1 = this.p1;
        }
        return new LineSegment(newp0, newp1);
    }

    public Coordinate closestPoint(Coordinate p2) {
        double dist1;
        double factor = this.projectionFactor(p2);
        if (factor > 0.0 && factor < 1.0) {
            return this.project(p2);
        }
        double dist0 = this.p0.distance(p2);
        if (dist0 < (dist1 = this.p1.distance(p2))) {
            return this.p0;
        }
        return this.p1;
    }

    public Coordinate[] closestPoints(LineSegment line) {
        Coordinate close11;
        Coordinate close10;
        Coordinate intPt = this.intersection(line);
        if (intPt != null) {
            return new Coordinate[]{intPt, intPt};
        }
        Coordinate[] closestPt = new Coordinate[2];
        double minDistance = Double.MAX_VALUE;
        Coordinate close00 = this.closestPoint(line.p0);
        minDistance = close00.distance(line.p0);
        closestPt[0] = close00;
        closestPt[1] = line.p0;
        Coordinate close01 = this.closestPoint(line.p1);
        double dist = close01.distance(line.p1);
        if (dist < minDistance) {
            minDistance = dist;
            closestPt[0] = close01;
            closestPt[1] = line.p1;
        }
        if ((dist = (close10 = line.closestPoint(this.p0)).distance(this.p0)) < minDistance) {
            minDistance = dist;
            closestPt[0] = this.p0;
            closestPt[1] = close10;
        }
        if ((dist = (close11 = line.closestPoint(this.p1)).distance(this.p1)) < minDistance) {
            minDistance = dist;
            closestPt[0] = this.p1;
            closestPt[1] = close11;
        }
        return closestPt;
    }

    public Coordinate intersection(LineSegment line) {
        RobustLineIntersector li2 = new RobustLineIntersector();
        li2.computeIntersection(this.p0, this.p1, line.p0, line.p1);
        if (li2.hasIntersection()) {
            return li2.getIntersection(0);
        }
        return null;
    }

    public Coordinate lineIntersection(LineSegment line) {
        try {
            Coordinate intPt = HCoordinate.intersection(this.p0, this.p1, line.p0, line.p1);
            return intPt;
        }
        catch (NotRepresentableException notRepresentableException) {
            return null;
        }
    }

    public LineString toGeometry(GeometryFactory geomFactory) {
        return geomFactory.createLineString(new Coordinate[]{this.p0, this.p1});
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof LineSegment)) {
            return false;
        }
        LineSegment other = (LineSegment)o2;
        return this.p0.equals(other.p0) && this.p1.equals(other.p1);
    }

    public int hashCode() {
        long bits0 = Double.doubleToLongBits(this.p0.x);
        int hash0 = (int)(bits0 ^= Double.doubleToLongBits(this.p0.y) * 31L) ^ (int)(bits0 >> 32);
        long bits1 = Double.doubleToLongBits(this.p1.x);
        int hash1 = (int)(bits1 ^= Double.doubleToLongBits(this.p1.y) * 31L) ^ (int)(bits1 >> 32);
        return hash0 ^ hash1;
    }

    public int compareTo(Object o2) {
        LineSegment other = (LineSegment)o2;
        int comp0 = this.p0.compareTo(other.p0);
        if (comp0 != 0) {
            return comp0;
        }
        return this.p1.compareTo(other.p1);
    }

    public boolean equalsTopo(LineSegment other) {
        return this.p0.equals(other.p0) && this.p1.equals(other.p1) || this.p0.equals(other.p1) && this.p1.equals(other.p0);
    }

    public String toString() {
        return "LINESTRING( " + this.p0.x + " " + this.p0.y + ", " + this.p1.x + " " + this.p1.y + ")";
    }
}

