/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;

public class CoordinateSequences {
    public static void reverse(CoordinateSequence seq) {
        int last = seq.size() - 1;
        int mid = last / 2;
        for (int i2 = 0; i2 <= mid; ++i2) {
            CoordinateSequences.swap(seq, i2, last - i2);
        }
    }

    public static void swap(CoordinateSequence seq, int i2, int j2) {
        if (i2 == j2) {
            return;
        }
        for (int dim = 0; dim < seq.getDimension(); ++dim) {
            double tmp = seq.getOrdinate(i2, dim);
            seq.setOrdinate(i2, dim, seq.getOrdinate(j2, dim));
            seq.setOrdinate(j2, dim, tmp);
        }
    }

    public static void copy(CoordinateSequence src, int srcPos, CoordinateSequence dest, int destPos, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            CoordinateSequences.copyCoord(src, srcPos + i2, dest, destPos + i2);
        }
    }

    public static void copyCoord(CoordinateSequence src, int srcPos, CoordinateSequence dest, int destPos) {
        for (int dim = 0; dim < src.getDimension(); ++dim) {
            dest.setOrdinate(destPos, dim, src.getOrdinate(srcPos, dim));
        }
    }

    public static boolean isRing(CoordinateSequence seq) {
        int n2 = seq.size();
        if (n2 == 0) {
            return true;
        }
        if (n2 <= 3) {
            return false;
        }
        return seq.getOrdinate(0, 0) == seq.getOrdinate(n2 - 1, 0) && seq.getOrdinate(0, 1) == seq.getOrdinate(n2 - 1, 1);
    }

    public static CoordinateSequence ensureValidRing(CoordinateSequenceFactory fact, CoordinateSequence seq) {
        boolean isClosed;
        int n2 = seq.size();
        if (n2 == 0) {
            return seq;
        }
        if (n2 <= 3) {
            return CoordinateSequences.createClosedRing(fact, seq, 4);
        }
        boolean bl2 = isClosed = seq.getOrdinate(0, 0) == seq.getOrdinate(n2 - 1, 0) && seq.getOrdinate(0, 1) == seq.getOrdinate(n2 - 1, 1);
        if (isClosed) {
            return seq;
        }
        return CoordinateSequences.createClosedRing(fact, seq, n2 + 1);
    }

    private static CoordinateSequence createClosedRing(CoordinateSequenceFactory fact, CoordinateSequence seq, int size) {
        CoordinateSequence newseq = fact.create(size, seq.getDimension());
        int n2 = seq.size();
        CoordinateSequences.copy(seq, 0, newseq, 0, n2);
        for (int i2 = n2; i2 < size; ++i2) {
            CoordinateSequences.copy(seq, 0, newseq, i2, 1);
        }
        return newseq;
    }

    public static CoordinateSequence extend(CoordinateSequenceFactory fact, CoordinateSequence seq, int size) {
        CoordinateSequence newseq = fact.create(size, seq.getDimension());
        int n2 = seq.size();
        CoordinateSequences.copy(seq, 0, newseq, 0, n2);
        if (n2 > 0) {
            for (int i2 = n2; i2 < size; ++i2) {
                CoordinateSequences.copy(seq, n2 - 1, newseq, i2, 1);
            }
        }
        return newseq;
    }
}

