/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm.distance;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.io.WKTWriter;

public class PointPairDistance {
    private Coordinate[] pt = new Coordinate[]{new Coordinate(), new Coordinate()};
    private double distance = Double.NaN;
    private boolean isNull = true;

    public void initialize() {
        this.isNull = true;
    }

    public void initialize(Coordinate p0, Coordinate p1) {
        this.pt[0].setCoordinate(p0);
        this.pt[1].setCoordinate(p1);
        this.distance = p0.distance(p1);
        this.isNull = false;
    }

    private void initialize(Coordinate p0, Coordinate p1, double distance) {
        this.pt[0].setCoordinate(p0);
        this.pt[1].setCoordinate(p1);
        this.distance = distance;
        this.isNull = false;
    }

    public double getDistance() {
        return this.distance;
    }

    public Coordinate[] getCoordinates() {
        return this.pt;
    }

    public Coordinate getCoordinate(int i2) {
        return this.pt[i2];
    }

    public void setMaximum(PointPairDistance ptDist) {
        this.setMaximum(ptDist.pt[0], ptDist.pt[1]);
    }

    public void setMaximum(Coordinate p0, Coordinate p1) {
        if (this.isNull) {
            this.initialize(p0, p1);
            return;
        }
        double dist = p0.distance(p1);
        if (dist > this.distance) {
            this.initialize(p0, p1, dist);
        }
    }

    public void setMinimum(PointPairDistance ptDist) {
        this.setMinimum(ptDist.pt[0], ptDist.pt[1]);
    }

    public void setMinimum(Coordinate p0, Coordinate p1) {
        if (this.isNull) {
            this.initialize(p0, p1);
            return;
        }
        double dist = p0.distance(p1);
        if (dist < this.distance) {
            this.initialize(p0, p1, dist);
        }
    }

    public String toString() {
        return WKTWriter.toLineString(this.pt[0], this.pt[1]);
    }
}

