/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;

public class NonRobustCGAlgorithms
extends CGAlgorithms {
    public static boolean isPointInRing(Coordinate p2, Coordinate[] ring) {
        int crossings = 0;
        int nPts = ring.length;
        for (int i2 = 1; i2 < nPts; ++i2) {
            double xInt;
            int i1 = i2 - 1;
            Coordinate p1 = ring[i2];
            Coordinate p22 = ring[i1];
            double x1 = p1.x - p2.x;
            double y1 = p1.y - p2.y;
            double x2 = p22.x - p2.x;
            double y2 = p22.y - p2.y;
            if (!(y1 > 0.0 && y2 <= 0.0) && (!(y2 > 0.0) || !(y1 <= 0.0)) || !(0.0 < (xInt = (x1 * y2 - x2 * y1) / (y2 - y1)))) continue;
            ++crossings;
        }
        return crossings % 2 == 1;
    }

    public static boolean isCCW(Coordinate[] ring) {
        int nPts = ring.length - 1;
        if (nPts < 4) {
            return false;
        }
        Coordinate hip = ring[0];
        int hii = 0;
        for (int i2 = 1; i2 <= nPts; ++i2) {
            Coordinate p2 = ring[i2];
            if (!(p2.y > hip.y)) continue;
            hip = p2;
            hii = i2;
        }
        int iPrev = hii;
        while (ring[iPrev = (iPrev - 1) % nPts].equals(hip) && iPrev != hii) {
        }
        int iNext = hii;
        while (ring[iNext = (iNext + 1) % nPts].equals(hip) && iNext != hii) {
        }
        Coordinate prev = ring[iPrev];
        Coordinate next = ring[iNext];
        if (prev.equals(hip) || next.equals(hip) || prev.equals(next)) {
            throw new IllegalArgumentException("degenerate ring (does not contain 3 different points)");
        }
        double next2x = next.x - hip.x;
        double prev2y = prev.y - hip.y;
        double next2y = next.y - hip.y;
        double prev2x = prev.x - hip.x;
        double disc = next2x * prev2y - next2y * prev2x;
        if (disc == 0.0) {
            return prev.x > next.x;
        }
        return disc > 0.0;
    }

    public static int computeOrientation(Coordinate p1, Coordinate p2, Coordinate q2) {
        return NonRobustCGAlgorithms.orientationIndex(p1, p2, q2);
    }

    public static int orientationIndex(Coordinate p1, Coordinate p2, Coordinate q2) {
        double dx1 = p2.x - p1.x;
        double dy2 = q2.y - p2.y;
        double dx2 = q2.x - p2.x;
        double dy1 = p2.y - p1.y;
        double det = dx1 * dy2 - dx2 * dy1;
        if (det > 0.0) {
            return 1;
        }
        if (det < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double distanceLineLine(Coordinate A2, Coordinate B2, Coordinate C2, Coordinate D2) {
        if (A2.equals(B2)) {
            return NonRobustCGAlgorithms.distancePointLine(A2, C2, D2);
        }
        if (C2.equals(D2)) {
            return NonRobustCGAlgorithms.distancePointLine(D2, A2, B2);
        }
        double r_top = (A2.y - C2.y) * (D2.x - C2.x) - (A2.x - C2.x) * (D2.y - C2.y);
        double r_bot = (B2.x - A2.x) * (D2.y - C2.y) - (B2.y - A2.y) * (D2.x - C2.x);
        double s_top = (A2.y - C2.y) * (B2.x - A2.x) - (A2.x - C2.x) * (B2.y - A2.y);
        double s_bot = (B2.x - A2.x) * (D2.y - C2.y) - (B2.y - A2.y) * (D2.x - C2.x);
        if (r_bot == 0.0 || s_bot == 0.0) {
            return Math.min(NonRobustCGAlgorithms.distancePointLine(A2, C2, D2), Math.min(NonRobustCGAlgorithms.distancePointLine(B2, C2, D2), Math.min(NonRobustCGAlgorithms.distancePointLine(C2, A2, B2), NonRobustCGAlgorithms.distancePointLine(D2, A2, B2))));
        }
        double s2 = s_top / s_bot;
        double r2 = r_top / r_bot;
        if (r2 < 0.0 || r2 > 1.0 || s2 < 0.0 || s2 > 1.0) {
            return Math.min(NonRobustCGAlgorithms.distancePointLine(A2, C2, D2), Math.min(NonRobustCGAlgorithms.distancePointLine(B2, C2, D2), Math.min(NonRobustCGAlgorithms.distancePointLine(C2, A2, B2), NonRobustCGAlgorithms.distancePointLine(D2, A2, B2))));
        }
        return 0.0;
    }
}

