/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ByteArrayCache;
import com.sun.marlin.Curve;
import com.sun.marlin.DPathConsumer2D;
import com.sun.marlin.DoubleArrayCache;
import com.sun.marlin.IntArrayCache;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.RendererContext;
import com.sun.marlin.stats.Histogram;
import com.sun.marlin.stats.StatLong;
import java.util.Arrays;

final class Helpers
implements MarlinConst {
    private Helpers() {
        throw new Error("This is a non instantiable class");
    }

    static boolean within(double d2, double d3, double d4) {
        double d5 = d3 - d2;
        return d5 <= d4 && d5 >= -d4;
    }

    static double evalCubic(double d2, double d3, double d4, double d5, double d6) {
        return d6 * (d6 * (d6 * d2 + d3) + d4) + d5;
    }

    static double evalQuad(double d2, double d3, double d4, double d5) {
        return d5 * (d5 * d2 + d3) + d4;
    }

    static int quadraticRoots(double d2, double d3, double d4, double[] dArray, int n2) {
        int n3 = n2;
        if (d2 != 0.0) {
            double d5 = d3 * d3 - 4.0 * d2 * d4;
            if (d5 > 0.0) {
                double d6 = Math.sqrt(d5);
                if (d3 >= 0.0) {
                    dArray[n3++] = 2.0 * d4 / (-d3 - d6);
                    dArray[n3++] = (-d3 - d6) / (2.0 * d2);
                } else {
                    dArray[n3++] = (-d3 + d6) / (2.0 * d2);
                    dArray[n3++] = 2.0 * d4 / (-d3 + d6);
                }
            } else if (d5 == 0.0) {
                dArray[n3++] = -d3 / (2.0 * d2);
            }
        } else if (d3 != 0.0) {
            dArray[n3++] = -d4 / d3;
        }
        return n3 - n2;
    }

    static int cubicRootsInAB(double d2, double d3, double d4, double d5, double[] dArray, int n2, double d6, double d7) {
        int n3;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        if (d2 == 0.0) {
            int n4 = Helpers.quadraticRoots(d3, d4, d5, dArray, n2);
            return Helpers.filterOutNotInAB(dArray, n2, n4, d6, d7) - n2;
        }
        if ((d13 = (d12 = 0.5 * (0.07407407407407407 * (d3 /= d2) * (d11 = d3 * d3) - (d10 = 0.3333333333333333 * d3) * (d4 /= d2) + (d5 /= d2))) * d12 + (d9 = (d8 = 0.3333333333333333 * (-0.3333333333333333 * d11 + d4)) * d8 * d8)) < 0.0) {
            double d14 = 0.3333333333333333 * Math.acos(-d12 / Math.sqrt(-d9));
            double d15 = 2.0 * Math.sqrt(-d8);
            dArray[n2] = d15 * Math.cos(d14) - d10;
            dArray[n2 + 1] = -d15 * Math.cos(d14 + 1.0471975511965976) - d10;
            dArray[n2 + 2] = -d15 * Math.cos(d14 - 1.0471975511965976) - d10;
            n3 = 3;
        } else {
            double d16 = Math.sqrt(d13);
            double d17 = Math.cbrt(d16 - d12);
            double d18 = -Math.cbrt(d16 + d12);
            dArray[n2] = d17 + d18 - d10;
            n3 = 1;
            if (Helpers.within(d13, 0.0, 1.0E-8)) {
                dArray[n2 + 1] = -0.5 * (d17 + d18) - d10;
                n3 = 2;
            }
        }
        return Helpers.filterOutNotInAB(dArray, n2, n3, d6, d7) - n2;
    }

    static int filterOutNotInAB(double[] dArray, int n2, int n3, double d2, double d3) {
        int n4 = n2;
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; ++i2) {
            if (!(dArray[i2] >= d2) || !(dArray[i2] < d3)) continue;
            dArray[n4++] = dArray[i2];
        }
        return n4;
    }

    static double fastLineLen(double d2, double d3, double d4, double d5) {
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        return Math.abs(d6) + Math.abs(d7);
    }

    static double linelen(double d2, double d3, double d4, double d5) {
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        return Math.sqrt(d6 * d6 + d7 * d7);
    }

    static double fastQuadLen(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d4 - d2;
        double d9 = d6 - d4;
        double d10 = d5 - d3;
        double d11 = d7 - d5;
        return Math.abs(d8) + Math.abs(d9) + Math.abs(d10) + Math.abs(d11);
    }

    static double quadlen(double d2, double d3, double d4, double d5, double d6, double d7) {
        return (Helpers.linelen(d2, d3, d4, d5) + Helpers.linelen(d4, d5, d6, d7) + Helpers.linelen(d2, d3, d6, d7)) / 2.0;
    }

    static double fastCurvelen(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d4 - d2;
        double d11 = d6 - d4;
        double d12 = d8 - d6;
        double d13 = d5 - d3;
        double d14 = d7 - d5;
        double d15 = d9 - d7;
        return Math.abs(d10) + Math.abs(d11) + Math.abs(d12) + Math.abs(d13) + Math.abs(d14) + Math.abs(d15);
    }

    static double curvelen(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return (Helpers.linelen(d2, d3, d4, d5) + Helpers.linelen(d4, d5, d6, d7) + Helpers.linelen(d6, d7, d8, d9) + Helpers.linelen(d2, d3, d8, d9)) / 2.0;
    }

    static int findSubdivPoints(Curve curve, double[] dArray, double[] dArray2, int n2, double d2) {
        double d3 = dArray[2] - dArray[0];
        double d4 = dArray[3] - dArray[1];
        if (d4 != 0.0 && d3 != 0.0) {
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            double d6 = d3 / d5;
            double d7 = d4 / d5;
            double d8 = d6 * dArray[0] + d7 * dArray[1];
            double d9 = d6 * dArray[1] - d7 * dArray[0];
            double d10 = d6 * dArray[2] + d7 * dArray[3];
            double d11 = d6 * dArray[3] - d7 * dArray[2];
            double d12 = d6 * dArray[4] + d7 * dArray[5];
            double d13 = d6 * dArray[5] - d7 * dArray[4];
            switch (n2) {
                case 8: {
                    double d14 = d6 * dArray[6] + d7 * dArray[7];
                    double d15 = d6 * dArray[7] - d7 * dArray[6];
                    curve.set(d8, d9, d10, d11, d12, d13, d14, d15);
                    break;
                }
                case 6: {
                    curve.set(d8, d9, d10, d11, d12, d13);
                    break;
                }
            }
        } else {
            curve.set(dArray, n2);
        }
        int n3 = 0;
        n3 += curve.dxRoots(dArray2, n3);
        n3 += curve.dyRoots(dArray2, n3);
        if (n2 == 8) {
            n3 += curve.infPoints(dArray2, n3);
        }
        n3 += curve.rootsOfROCMinusW(dArray2, n3, d2, 1.0E-4);
        n3 = Helpers.filterOutNotInAB(dArray2, 0, n3, 1.0E-4, 0.9999);
        Helpers.isort(dArray2, n3);
        return n3;
    }

    static int findClipPoints(Curve curve, double[] dArray, double[] dArray2, int n2, int n3, double[] dArray3) {
        curve.set(dArray, n2);
        int n4 = 0;
        if ((n3 & 4) != 0) {
            n4 += curve.xPoints(dArray2, n4, dArray3[2]);
        }
        if ((n3 & 8) != 0) {
            n4 += curve.xPoints(dArray2, n4, dArray3[3]);
        }
        if ((n3 & 1) != 0) {
            n4 += curve.yPoints(dArray2, n4, dArray3[0]);
        }
        if ((n3 & 2) != 0) {
            n4 += curve.yPoints(dArray2, n4, dArray3[1]);
        }
        Helpers.isort(dArray2, n4);
        return n4;
    }

    static void subdivide(double[] dArray, double[] dArray2, double[] dArray3, int n2) {
        switch (n2) {
            case 8: {
                Helpers.subdivideCubic(dArray, dArray2, dArray3);
                return;
            }
            case 6: {
                Helpers.subdivideQuad(dArray, dArray2, dArray3);
                return;
            }
        }
        throw new InternalError("Unsupported curve type");
    }

    static void isort(double[] dArray, int n2) {
        for (int i2 = 1; i2 < n2; ++i2) {
            double d2 = dArray[i2];
            for (int i3 = i2 - 1; i3 >= 0 && dArray[i3] > d2; --i3) {
                dArray[i3 + 1] = dArray[i3];
            }
            dArray[i3 + 1] = d2;
        }
    }

    static void subdivideCubic(double[] dArray, double[] dArray2, double[] dArray3) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        double d6 = dArray[4];
        double d7 = dArray[5];
        double d8 = dArray[6];
        double d9 = dArray[7];
        dArray2[0] = d2;
        dArray2[1] = d3;
        dArray3[6] = d8;
        dArray3[7] = d9;
        d2 = (d2 + d4) / 2.0;
        d3 = (d3 + d5) / 2.0;
        d8 = (d8 + d6) / 2.0;
        d9 = (d9 + d7) / 2.0;
        double d10 = (d4 + d6) / 2.0;
        double d11 = (d5 + d7) / 2.0;
        d4 = (d2 + d10) / 2.0;
        d5 = (d3 + d11) / 2.0;
        d6 = (d8 + d10) / 2.0;
        d7 = (d9 + d11) / 2.0;
        d10 = (d4 + d6) / 2.0;
        d11 = (d5 + d7) / 2.0;
        dArray2[2] = d2;
        dArray2[3] = d3;
        dArray2[4] = d4;
        dArray2[5] = d5;
        dArray2[6] = d10;
        dArray2[7] = d11;
        dArray3[0] = d10;
        dArray3[1] = d11;
        dArray3[2] = d6;
        dArray3[3] = d7;
        dArray3[4] = d8;
        dArray3[5] = d9;
    }

    static void subdivideCubicAt(double d2, double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        double d3 = dArray[n2];
        double d4 = dArray[n2 + 1];
        double d5 = dArray[n2 + 2];
        double d6 = dArray[n2 + 3];
        double d7 = dArray[n2 + 4];
        double d8 = dArray[n2 + 5];
        double d9 = dArray[n2 + 6];
        double d10 = dArray[n2 + 7];
        dArray2[n3] = d3;
        dArray2[n3 + 1] = d4;
        dArray2[n4 + 6] = d9;
        dArray2[n4 + 7] = d10;
        d3 += d2 * (d5 - d3);
        d4 += d2 * (d6 - d4);
        d9 = d7 + d2 * (d9 - d7);
        d10 = d8 + d2 * (d10 - d8);
        double d11 = d5 + d2 * (d7 - d5);
        double d12 = d6 + d2 * (d8 - d6);
        d5 = d3 + d2 * (d11 - d3);
        d6 = d4 + d2 * (d12 - d4);
        d7 = d11 + d2 * (d9 - d11);
        d8 = d12 + d2 * (d10 - d12);
        d11 = d5 + d2 * (d7 - d5);
        d12 = d6 + d2 * (d8 - d6);
        dArray2[n3 + 2] = d3;
        dArray2[n3 + 3] = d4;
        dArray2[n3 + 4] = d5;
        dArray2[n3 + 5] = d6;
        dArray2[n3 + 6] = d11;
        dArray2[n3 + 7] = d12;
        dArray2[n4] = d11;
        dArray2[n4 + 1] = d12;
        dArray2[n4 + 2] = d7;
        dArray2[n4 + 3] = d8;
        dArray2[n4 + 4] = d9;
        dArray2[n4 + 5] = d10;
    }

    static void subdivideQuad(double[] dArray, double[] dArray2, double[] dArray3) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = dArray[3];
        double d6 = dArray[4];
        double d7 = dArray[5];
        dArray2[0] = d2;
        dArray2[1] = d3;
        dArray3[4] = d6;
        dArray3[5] = d7;
        d2 = (d2 + d4) / 2.0;
        d3 = (d3 + d5) / 2.0;
        d6 = (d6 + d4) / 2.0;
        d7 = (d7 + d5) / 2.0;
        d4 = (d2 + d6) / 2.0;
        d5 = (d3 + d7) / 2.0;
        dArray2[2] = d2;
        dArray2[3] = d3;
        dArray2[4] = d4;
        dArray2[5] = d5;
        dArray3[0] = d4;
        dArray3[1] = d5;
        dArray3[2] = d6;
        dArray3[3] = d7;
    }

    static void subdivideQuadAt(double d2, double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        double d3 = dArray[n2];
        double d4 = dArray[n2 + 1];
        double d5 = dArray[n2 + 2];
        double d6 = dArray[n2 + 3];
        double d7 = dArray[n2 + 4];
        double d8 = dArray[n2 + 5];
        dArray2[n3] = d3;
        dArray2[n3 + 1] = d4;
        dArray2[n4 + 4] = d7;
        dArray2[n4 + 5] = d8;
        d3 += d2 * (d5 - d3);
        d4 += d2 * (d6 - d4);
        d7 = d5 + d2 * (d7 - d5);
        d8 = d6 + d2 * (d8 - d6);
        d5 = d3 + d2 * (d7 - d3);
        d6 = d4 + d2 * (d8 - d4);
        dArray2[n3 + 2] = d3;
        dArray2[n3 + 3] = d4;
        dArray2[n3 + 4] = d5;
        dArray2[n3 + 5] = d6;
        dArray2[n4] = d5;
        dArray2[n4 + 1] = d6;
        dArray2[n4 + 2] = d7;
        dArray2[n4 + 3] = d8;
    }

    static void subdivideLineAt(double d2, double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        double d3 = dArray[n2];
        double d4 = dArray[n2 + 1];
        double d5 = dArray[n2 + 2];
        double d6 = dArray[n2 + 3];
        dArray2[n3] = d3;
        dArray2[n3 + 1] = d4;
        dArray2[n4 + 2] = d5;
        dArray2[n4 + 3] = d6;
        d3 += d2 * (d5 - d3);
        d4 += d2 * (d6 - d4);
        dArray2[n3 + 2] = d3;
        dArray2[n3 + 3] = d4;
        dArray2[n4] = d3;
        dArray2[n4 + 1] = d4;
    }

    static void subdivideAt(double d2, double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        if (n4 == 8) {
            Helpers.subdivideCubicAt(d2, dArray, n2, dArray2, n3, n3 + n4);
        } else if (n4 == 4) {
            Helpers.subdivideLineAt(d2, dArray, n2, dArray2, n3, n3 + n4);
        } else {
            Helpers.subdivideQuadAt(d2, dArray, n2, dArray2, n3, n3 + n4);
        }
    }

    static int outcode(double d2, double d3, double[] dArray) {
        int n2 = d3 < dArray[0] ? 1 : (d3 >= dArray[1] ? 2 : 0);
        if (d2 < dArray[2]) {
            n2 |= 4;
        } else if (d2 >= dArray[3]) {
            n2 |= 8;
        }
        return n2;
    }

    static final class IndexStack {
        private static final int INITIAL_COUNT = MarlinConst.INITIAL_EDGES_COUNT >> 2;
        private int end;
        private int[] indices;
        private final IntArrayCache.Reference indices_ref;
        private int indicesUseMark;
        private final StatLong stat_idxstack_indices;
        private final Histogram hist_idxstack_indices;
        private final StatLong stat_array_idxstack_indices;

        IndexStack(RendererContext rendererContext) {
            this(rendererContext, null, null, null);
        }

        IndexStack(RendererContext rendererContext, StatLong statLong, Histogram histogram, StatLong statLong2) {
            this.indices_ref = rendererContext.newDirtyIntArrayRef(INITIAL_COUNT);
            this.indices = this.indices_ref.initial;
            this.end = 0;
            if (MarlinConst.DO_STATS) {
                this.indicesUseMark = 0;
            }
            this.stat_idxstack_indices = statLong;
            this.hist_idxstack_indices = histogram;
            this.stat_array_idxstack_indices = statLong2;
        }

        void dispose() {
            this.end = 0;
            if (MarlinConst.DO_STATS) {
                this.stat_idxstack_indices.add(this.indicesUseMark);
                this.hist_idxstack_indices.add(this.indicesUseMark);
                this.indicesUseMark = 0;
            }
            this.indices = this.indices_ref.putArray(this.indices);
        }

        boolean isEmpty() {
            return this.end == 0;
        }

        void reset() {
            this.end = 0;
        }

        void push(int n2) {
            int n3;
            int[] nArray = this.indices;
            if ((n3 = this.end--) != 0 && nArray[n3 - 1] == n2) {
                return;
            }
            if (nArray.length <= n3) {
                if (MarlinConst.DO_STATS) {
                    this.stat_array_idxstack_indices.add(n3 + 1);
                }
                this.indices = nArray = this.indices_ref.widenArray(nArray, n3, n3 + 1);
            }
            nArray[this.end++] = n2;
            if (MarlinConst.DO_STATS && this.end > this.indicesUseMark) {
                this.indicesUseMark = this.end;
            }
        }

        void pullAll(double[] dArray, DPathConsumer2D dPathConsumer2D) {
            int n2 = this.end;
            if (n2 == 0) {
                return;
            }
            int[] nArray = this.indices;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2] << 1;
                dPathConsumer2D.lineTo(dArray[n3], dArray[n3 + 1]);
            }
            this.end = 0;
        }
    }

    static final class PolyStack {
        private static final byte TYPE_LINETO = 0;
        private static final byte TYPE_QUADTO = 1;
        private static final byte TYPE_CUBICTO = 2;
        private static final int INITIAL_CURVES_COUNT = MarlinConst.INITIAL_EDGES_COUNT << 1;
        private static final int INITIAL_TYPES_COUNT = MarlinConst.INITIAL_EDGES_COUNT;
        double[] curves;
        int end;
        byte[] curveTypes;
        int numCurves;
        final DoubleArrayCache.Reference curves_ref;
        final ByteArrayCache.Reference curveTypes_ref;
        int curveTypesUseMark;
        int curvesUseMark;
        private final StatLong stat_polystack_types;
        private final StatLong stat_polystack_curves;
        private final Histogram hist_polystack_curves;
        private final StatLong stat_array_polystack_curves;
        private final StatLong stat_array_polystack_curveTypes;

        PolyStack(RendererContext rendererContext) {
            this(rendererContext, null, null, null, null, null);
        }

        PolyStack(RendererContext rendererContext, StatLong statLong, StatLong statLong2, Histogram histogram, StatLong statLong3, StatLong statLong4) {
            this.curves_ref = rendererContext.newDirtyDoubleArrayRef(INITIAL_CURVES_COUNT);
            this.curves = this.curves_ref.initial;
            this.curveTypes_ref = rendererContext.newDirtyByteArrayRef(INITIAL_TYPES_COUNT);
            this.curveTypes = this.curveTypes_ref.initial;
            this.numCurves = 0;
            this.end = 0;
            if (MarlinConst.DO_STATS) {
                this.curveTypesUseMark = 0;
                this.curvesUseMark = 0;
            }
            this.stat_polystack_types = statLong;
            this.stat_polystack_curves = statLong2;
            this.hist_polystack_curves = histogram;
            this.stat_array_polystack_curves = statLong3;
            this.stat_array_polystack_curveTypes = statLong4;
        }

        void dispose() {
            this.end = 0;
            this.numCurves = 0;
            if (MarlinConst.DO_STATS) {
                this.stat_polystack_types.add(this.curveTypesUseMark);
                this.stat_polystack_curves.add(this.curvesUseMark);
                this.hist_polystack_curves.add(this.curvesUseMark);
                this.curveTypesUseMark = 0;
                this.curvesUseMark = 0;
            }
            this.curves = this.curves_ref.putArray(this.curves);
            this.curveTypes = this.curveTypes_ref.putArray(this.curveTypes);
        }

        private void ensureSpace(int n2) {
            if (this.curves.length - this.end < n2) {
                if (MarlinConst.DO_STATS) {
                    this.stat_array_polystack_curves.add(this.end + n2);
                }
                this.curves = this.curves_ref.widenArray(this.curves, this.end, this.end + n2);
            }
            if (this.curveTypes.length <= this.numCurves) {
                if (MarlinConst.DO_STATS) {
                    this.stat_array_polystack_curveTypes.add(this.numCurves + 1);
                }
                this.curveTypes = this.curveTypes_ref.widenArray(this.curveTypes, this.numCurves, this.numCurves + 1);
            }
        }

        void pushCubic(double d2, double d3, double d4, double d5, double d6, double d7) {
            this.ensureSpace(6);
            this.curveTypes[this.numCurves++] = 2;
            double[] dArray = this.curves;
            int n2 = this.end;
            dArray[n2++] = d6;
            dArray[n2++] = d7;
            dArray[n2++] = d4;
            dArray[n2++] = d5;
            dArray[n2++] = d2;
            dArray[n2++] = d3;
            this.end = n2;
        }

        void pushQuad(double d2, double d3, double d4, double d5) {
            this.ensureSpace(4);
            this.curveTypes[this.numCurves++] = 1;
            double[] dArray = this.curves;
            int n2 = this.end;
            dArray[n2++] = d4;
            dArray[n2++] = d5;
            dArray[n2++] = d2;
            dArray[n2++] = d3;
            this.end = n2;
        }

        void pushLine(double d2, double d3) {
            this.ensureSpace(2);
            this.curveTypes[this.numCurves++] = 0;
            this.curves[this.end++] = d2;
            this.curves[this.end++] = d3;
        }

        void pullAll(DPathConsumer2D dPathConsumer2D) {
            int n2 = this.numCurves;
            if (n2 == 0) {
                return;
            }
            if (MarlinConst.DO_STATS) {
                if (this.numCurves > this.curveTypesUseMark) {
                    this.curveTypesUseMark = this.numCurves;
                }
                if (this.end > this.curvesUseMark) {
                    this.curvesUseMark = this.end;
                }
            }
            byte[] byArray = this.curveTypes;
            double[] dArray = this.curves;
            int n3 = 0;
            block5: for (int i2 = 0; i2 < n2; ++i2) {
                switch (byArray[i2]) {
                    case 0: {
                        dPathConsumer2D.lineTo(dArray[n3], dArray[n3 + 1]);
                        n3 += 2;
                        continue block5;
                    }
                    case 2: {
                        dPathConsumer2D.curveTo(dArray[n3], dArray[n3 + 1], dArray[n3 + 2], dArray[n3 + 3], dArray[n3 + 4], dArray[n3 + 5]);
                        n3 += 6;
                        continue block5;
                    }
                    case 1: {
                        dPathConsumer2D.quadTo(dArray[n3], dArray[n3 + 1], dArray[n3 + 2], dArray[n3 + 3]);
                        n3 += 4;
                        continue block5;
                    }
                }
            }
            this.numCurves = 0;
            this.end = 0;
        }

        void popAll(DPathConsumer2D dPathConsumer2D) {
            int n2 = this.numCurves;
            if (n2 == 0) {
                return;
            }
            if (MarlinConst.DO_STATS) {
                if (this.numCurves > this.curveTypesUseMark) {
                    this.curveTypesUseMark = this.numCurves;
                }
                if (this.end > this.curvesUseMark) {
                    this.curvesUseMark = this.end;
                }
            }
            byte[] byArray = this.curveTypes;
            double[] dArray = this.curves;
            int n3 = this.end;
            block5: while (n2 != 0) {
                switch (byArray[--n2]) {
                    case 0: {
                        dPathConsumer2D.lineTo(dArray[n3 -= 2], dArray[n3 + 1]);
                        continue block5;
                    }
                    case 2: {
                        dPathConsumer2D.curveTo(dArray[n3 -= 6], dArray[n3 + 1], dArray[n3 + 2], dArray[n3 + 3], dArray[n3 + 4], dArray[n3 + 5]);
                        continue block5;
                    }
                    case 1: {
                        dPathConsumer2D.quadTo(dArray[n3 -= 4], dArray[n3 + 1], dArray[n3 + 2], dArray[n3 + 3]);
                        continue block5;
                    }
                }
            }
            this.numCurves = 0;
            this.end = 0;
        }

        public String toString() {
            Object object = "";
            int n2 = this.numCurves;
            int n3 = this.end;
            while (n2 != 0) {
                int n4;
                switch (this.curveTypes[--n2]) {
                    case 0: {
                        n4 = 2;
                        object = (String)object + "line: ";
                        break;
                    }
                    case 1: {
                        n4 = 4;
                        object = (String)object + "quad: ";
                        break;
                    }
                    case 2: {
                        n4 = 6;
                        object = (String)object + "cubic: ";
                        break;
                    }
                    default: {
                        n4 = 0;
                    }
                }
                object = (String)object + Arrays.toString(Arrays.copyOfRange(this.curves, n3 -= n4, n3 + n4)) + "\n";
            }
            return object;
        }
    }
}

