/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import java.util.Arrays;

public final class ArrayCacheConst
implements MarlinConst {
    static final int BUCKETS = 8;
    static final int MIN_ARRAY_SIZE = 4096;
    static final int MAX_ARRAY_SIZE;
    static final int THRESHOLD_SMALL_ARRAY_SIZE = 0x400000;
    static final int THRESHOLD_ARRAY_SIZE;
    static final long THRESHOLD_HUGE_ARRAY_SIZE;
    static final int[] ARRAY_SIZES;

    private ArrayCacheConst() {
    }

    static int getBucket(int n2) {
        for (int i2 = 0; i2 < ARRAY_SIZES.length; ++i2) {
            if (n2 > ARRAY_SIZES[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int getNewSize(int n2, int n3) {
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException("array exceeds maximum capacity !");
        }
        assert (n2 >= 0);
        int n4 = n2;
        int n5 = n4 > THRESHOLD_ARRAY_SIZE ? n4 + (n4 >> 1) : n4 << 1;
        if (n5 < n3) {
            n5 = (n3 >> 12) + 1 << 12;
        }
        if (n5 < 0) {
            n5 = Integer.MAX_VALUE;
        }
        return n5;
    }

    public static long getNewLargeSize(long l2, long l3) {
        if (l3 >> 31 != 0L) {
            throw new ArrayIndexOutOfBoundsException("array exceeds maximum capacity !");
        }
        assert (l2 >= 0L);
        long l4 = l2 > THRESHOLD_HUGE_ARRAY_SIZE ? l2 + (l2 >> 2) : (l2 > (long)THRESHOLD_ARRAY_SIZE ? l2 + (l2 >> 1) : (l2 > 0x400000L ? l2 << 1 : l2 << 2));
        if (l4 < l3) {
            l4 = (l3 >> 12) + 1L << 12;
        }
        if (l4 > Integer.MAX_VALUE) {
            l4 = Integer.MAX_VALUE;
        }
        return l4;
    }

    static {
        ARRAY_SIZES = new int[8];
        int n2 = 4096;
        int n3 = 2;
        int n4 = 0;
        while (n4 < 8) {
            ArrayCacheConst.ARRAY_SIZES[n4] = n2;
            if (DO_TRACE) {
                MarlinUtils.logInfo("arraySize[" + n4 + "]: " + n2);
            }
            if (n2 >= 0x400000) {
                n3 = 1;
            }
            ++n4;
            n2 <<= n3;
        }
        MAX_ARRAY_SIZE = n2 >> n3;
        if (MAX_ARRAY_SIZE <= 0) {
            throw new IllegalStateException("Invalid max array size !");
        }
        THRESHOLD_ARRAY_SIZE = 0x1000000;
        THRESHOLD_HUGE_ARRAY_SIZE = 0x3000000L;
        if (DO_STATS) {
            MarlinUtils.logInfo("ArrayCache.BUCKETS        = 8");
            MarlinUtils.logInfo("ArrayCache.MIN_ARRAY_SIZE = 4096");
            MarlinUtils.logInfo("ArrayCache.MAX_ARRAY_SIZE = " + MAX_ARRAY_SIZE);
            MarlinUtils.logInfo("ArrayCache.ARRAY_SIZES = " + Arrays.toString(ARRAY_SIZES));
            MarlinUtils.logInfo("ArrayCache.THRESHOLD_ARRAY_SIZE = " + THRESHOLD_ARRAY_SIZE);
            MarlinUtils.logInfo("ArrayCache.THRESHOLD_HUGE_ARRAY_SIZE = " + THRESHOLD_HUGE_ARRAY_SIZE);
        }
    }

    static final class BucketStats {
        int getOp = 0;
        int createOp = 0;
        int returnOp = 0;
        int maxSize = 0;

        BucketStats() {
        }

        void reset() {
            this.getOp = 0;
            this.createOp = 0;
            this.returnOp = 0;
            this.maxSize = 0;
        }

        void updateMaxSize(int n2) {
            if (n2 > this.maxSize) {
                this.maxSize = n2;
            }
        }
    }

    static final class CacheStats {
        final String name;
        final BucketStats[] bucketStats;
        int resize = 0;
        int oversize = 0;
        long totalInitial = 0L;

        CacheStats(String string) {
            this.name = string;
            this.bucketStats = new BucketStats[8];
            for (int i2 = 0; i2 < 8; ++i2) {
                this.bucketStats[i2] = new BucketStats();
            }
        }

        void reset() {
            this.resize = 0;
            this.oversize = 0;
            for (int i2 = 0; i2 < 8; ++i2) {
                this.bucketStats[i2].reset();
            }
        }

        long dumpStats() {
            long l2 = 0L;
            if (MarlinConst.DO_STATS) {
                BucketStats bucketStats;
                int n2;
                for (n2 = 0; n2 < 8; ++n2) {
                    bucketStats = this.bucketStats[n2];
                    if (bucketStats.maxSize == 0) continue;
                    l2 += (long)(this.getByteFactor() * (bucketStats.maxSize * ARRAY_SIZES[n2]));
                }
                if (this.totalInitial != 0L || l2 != 0L || this.resize != 0 || this.oversize != 0) {
                    MarlinUtils.logInfo(this.name + ": resize: " + this.resize + " - oversize: " + this.oversize + " - initial: " + this.getTotalInitialBytes() + " bytes (" + this.totalInitial + " elements) - cache: " + l2 + " bytes");
                }
                if (l2 != 0L) {
                    MarlinUtils.logInfo(this.name + ": usage stats:");
                    for (n2 = 0; n2 < 8; ++n2) {
                        bucketStats = this.bucketStats[n2];
                        if (bucketStats.getOp == 0) continue;
                        MarlinUtils.logInfo("  Bucket[" + ARRAY_SIZES[n2] + "]: get: " + bucketStats.getOp + " - put: " + bucketStats.returnOp + " - create: " + bucketStats.createOp + " :: max size: " + bucketStats.maxSize);
                    }
                }
            }
            return l2;
        }

        private int getByteFactor() {
            int n2 = 1;
            if (this.name.contains("Int") || this.name.contains("Float")) {
                n2 = 4;
            } else if (this.name.contains("Double")) {
                n2 = 8;
            }
            return n2;
        }

        long getTotalInitialBytes() {
            return (long)this.getByteFactor() * this.totalInitial;
        }
    }
}

