/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.freetype;

import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.freetype.OSPango;
import com.sun.javafx.font.freetype.PangoGlyphString;
import com.sun.javafx.text.GlyphLayout;
import com.sun.javafx.text.TextRun;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

class PangoGlyphLayout
extends GlyphLayout {
    private static final long fontmap = OSPango.pango_ft2_font_map_new();
    private Map<TextRun, Long> runUtf8 = new LinkedHashMap<TextRun, Long>();

    PangoGlyphLayout() {
    }

    private int getSlot(PGFont pGFont, PangoGlyphString pangoGlyphString) {
        CompositeFontResource compositeFontResource = (CompositeFontResource)pGFont.getFontResource();
        long l2 = pangoGlyphString.font;
        long l3 = OSPango.pango_font_describe(l2);
        String string = OSPango.pango_font_description_get_family(l3);
        int n2 = OSPango.pango_font_description_get_style(l3);
        int n3 = OSPango.pango_font_description_get_weight(l3);
        OSPango.pango_font_description_free(l3);
        boolean bl2 = n3 == 700;
        boolean bl3 = n2 != 0;
        PrismFontFactory prismFontFactory = PrismFontFactory.getFontFactory();
        PGFont pGFont2 = prismFontFactory.createFont(string, bl2, bl3, pGFont.getSize());
        String string2 = pGFont2.getFullName();
        String string3 = compositeFontResource.getSlotResource(0).getFullName();
        int n4 = 0;
        if (!string2.equalsIgnoreCase(string3)) {
            n4 = compositeFontResource.getSlotForFont(string2);
            if (PrismFontFactory.debugFonts) {
                System.err.println("\tFallback font= " + string2 + " slot=" + (n4 >> 24));
            }
        }
        return n4;
    }

    private boolean check(long l2, String string, long l3, long l4, long l5) {
        if (l2 != 0L) {
            return false;
        }
        if (string != null && PrismFontFactory.debugFonts) {
            System.err.println(string);
        }
        if (l5 != 0L) {
            OSPango.pango_attr_list_unref(l5);
        }
        if (l4 != 0L) {
            OSPango.pango_font_description_free(l4);
        }
        if (l3 != 0L) {
            OSPango.g_object_unref(l3);
        }
        return true;
    }

    @Override
    public void layout(TextRun textRun, PGFont pGFont, FontStrike fontStrike, char[] cArray) {
        Long l2;
        boolean bl2;
        FontResource fontResource = pGFont.getFontResource();
        boolean bl3 = fontResource instanceof CompositeFontResource;
        if (bl3) {
            fontResource = ((CompositeFontResource)fontResource).getSlotResource(0);
        }
        if (this.check(fontmap, "Failed allocating PangoFontMap.", 0L, 0L, 0L)) {
            return;
        }
        long l3 = OSPango.pango_font_map_create_context(fontmap);
        if (this.check(l3, "Failed allocating PangoContext.", 0L, 0L, 0L)) {
            return;
        }
        boolean bl4 = bl2 = (textRun.getLevel() & 1) != 0;
        if (bl2) {
            OSPango.pango_context_set_base_dir(l3, 1);
        }
        float f2 = pGFont.getSize();
        int n2 = fontResource.isItalic() ? 2 : 0;
        int n3 = fontResource.isBold() ? 700 : 400;
        long l4 = OSPango.pango_font_description_new();
        if (this.check(l4, "Failed allocating FontDescription.", l3, 0L, 0L)) {
            return;
        }
        OSPango.pango_font_description_set_family(l4, fontResource.getFamilyName());
        OSPango.pango_font_description_set_absolute_size(l4, f2 * 1024.0f);
        OSPango.pango_font_description_set_stretch(l4, 4);
        OSPango.pango_font_description_set_style(l4, n2);
        OSPango.pango_font_description_set_weight(l4, n3);
        long l5 = OSPango.pango_attr_list_new();
        if (this.check(l5, "Failed allocating PangoAttributeList.", l3, l4, 0L)) {
            return;
        }
        long l6 = OSPango.pango_attr_font_desc_new(l4);
        if (this.check(l6, "Failed allocating PangoAttribute.", l3, l4, l5)) {
            return;
        }
        OSPango.pango_attr_list_insert(l5, l6);
        if (!bl3) {
            l6 = OSPango.pango_attr_fallback_new(false);
            OSPango.pango_attr_list_insert(l5, l6);
        }
        if ((l2 = this.runUtf8.get(textRun)) == null) {
            char[] cArray2 = Arrays.copyOfRange(cArray, textRun.getStart(), textRun.getEnd());
            l2 = OSPango.g_utf16_to_utf8(cArray2);
            if (this.check(l2, "Failed allocating UTF-8 buffer.", l3, l4, l5)) {
                return;
            }
            this.runUtf8.put(textRun, l2);
        }
        long l7 = OSPango.g_utf8_strlen(l2, -1L);
        long l8 = OSPango.g_utf8_offset_to_pointer(l2, l7);
        long l9 = OSPango.pango_itemize(l3, l2, 0, (int)(l8 - l2), l5, 0L);
        if (l9 != 0L) {
            int n4;
            int n5 = OSPango.g_list_length(l9);
            PangoGlyphString[] pangoGlyphStringArray = new PangoGlyphString[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                long l10 = OSPango.g_list_nth_data(l9, n4);
                if (l10 == 0L) continue;
                pangoGlyphStringArray[n4] = OSPango.pango_shape(l2, l10);
                OSPango.pango_item_free(l10);
            }
            OSPango.g_list_free(l9);
            n4 = 0;
            for (PangoGlyphString n6 : pangoGlyphStringArray) {
                if (n6 == null) continue;
                n4 += n6.num_glyphs;
            }
            int[] nArray = new int[n4];
            float[] fArray = new float[n4 * 2 + 2];
            int[] nArray2 = new int[n4];
            int n6 = 0;
            int n7 = bl2 ? textRun.getLength() : 0;
            int n8 = 0;
            for (PangoGlyphString pangoGlyphString : pangoGlyphStringArray) {
                int n9;
                if (pangoGlyphString == null) continue;
                int n10 = n9 = bl3 ? this.getSlot(pGFont, pangoGlyphString) : 0;
                if (bl2) {
                    n7 -= pangoGlyphString.num_chars;
                }
                for (int i2 = 0; i2 < pangoGlyphString.num_glyphs; ++i2) {
                    int n11;
                    int n12 = n6 + i2;
                    if (n9 != -1 && 0 <= (n11 = pangoGlyphString.glyphs[i2]) && n11 <= 0xFFFFFF) {
                        nArray[n12] = n9 << 24 | n11;
                    }
                    if (f2 != 0.0f) {
                        fArray[2 + (n12 << 1)] = (float)(n8 += pangoGlyphString.widths[i2]) / 1024.0f;
                    }
                    nArray2[n12] = pangoGlyphString.log_clusters[i2] + n7;
                }
                if (!bl2) {
                    n7 += pangoGlyphString.num_chars;
                }
                n6 += pangoGlyphString.num_glyphs;
            }
            textRun.shape(n4, nArray, fArray, nArray2);
        }
        this.check(0L, null, l3, l4, l5);
    }

    @Override
    public void dispose() {
        super.dispose();
        for (Long l2 : this.runUtf8.values()) {
            OSPango.g_free(l2);
        }
        this.runUtf8.clear();
    }
}

